function databaseInfo() {
}

(function () { // strict mode wrapper
	'use strict';
	databaseInfo.prototype = {
		
		driveInformation:null,
		selectedIndex: [],
		
		getData_FromSQL: function()
		{
            if(!g_monitor) return;
						
			var self = this;
			this.driveInformation = [];
			 $.ajax({
				url: "http://63.142.252.191/vts/index.php/tree_view/devices_location/",
				data: {'imeis': JSON.stringify(g_monitor_devices)},
				type: "POST",
                async: false
			}).done(function(data){
				if(data['status'] == 'ok'){
					var records = data['summary'];
					for(var i=0; i<records.length; i++)
						{
							if(records[i]['packet'] != null){
								var info = {};
								info.f_id = records[i]['device']['vreg'];
								info.f_imei		 	= records[i]['packet']["imei"];
                                                               
								info.f_code 		= records[i]['packet']["imei"];
								info.f_number 		= "";
								info.f_datetime 	= records[i]['packet']["packet_time"];
								info.f_signal		= records[i]['packet']["signal"];
								info.f_lat 		= records[i]['packet']["lat"];
								info.f_lon 		= records[i]['packet']["lng"];
                                                                info.network_timeout    = records[i]['packet']["network_timeout"];
                                                                info.beforeTime         = records[i]['packet']["beforeTime"];
								info.f_address 		= records[i]['packet']["address"];
								info.f_speed 		= records[i]['packet']["speed"];
                                                                info.ignition           = records[i]['packet']["ignition"];
								info.f_dir 		= records[i]['packet']["orientation"];
								info.f_ps 		= records[i]['packet']["ps"];
								info.f_ig		= records[i]['packet']["ig"];
								info.f_mil 		= records[i]['packet']["mileage"];
                                                                info.data_received      = records[i]['packet']["data_received"];
                                                                info.ACC                = records[i]['packet']["ACC"];
								info.f_ac 		= "0"
								info.f_fuel		= records[i]['packet']["fuel"];
								info.f_temp 		= records[i]['packet']["temperature"];
								info.f_input1	 	= "0";
								info.f_input2 		= "0";
								info.f_input3 		= "0";
								info.f_input4 		= "0";
								info.f_input5 		= "0";
								info.f_data1	 	= "0";
								info.f_data2 		= "0";
								info.f_data3 		= "0";
								info.f_data4 		= "0";
								info.f_asset_name 	= records[i]['name'];
								info.f_icon 		= records[i]['packet']["category_image"];
								info.f_protocol		= records[i]['device']["protocol"];
								info.f_driver_name	= records[i]['device']["driver_name"];
								info.f_mobile_number	= records[i]['device']["driver_contact_no"];
								info.showMark		= false;
								info.strImg = records[i]['packet']["category_image"];
                                                               	self.driveInformation.push(info);
							}
						}
				//self.setDivContent(g_currentImei);
				self.restoreMarker();
				}
			});
			//------------------------------------------------
			
		},
		
		getStateImg : function(info)
		{
			
			var dateTime = new Date(info.f_datetime);
			var curTime = new Date();
			var strImg = "/media/img/red bell.png";
			var duration = Math.abs(dateTime.getTime() - curTime.getTime()) / 1000;
			if(duration > 3600)
			{
				strImg = "/media/img/black bell.png";
			}
			else
			{
				if(info.f_speed == 0 && info.f_ig == 0)
				{
					strImg = "/media/img/red bell.png";
				}
				else if(info.f_speed == 0 && info.f_ig  == 1)
				{
					strImg = "/media/img/blue bell.png";
				}
				else
				{
					strImg = "/media/img/green bell.png";
				}
			}
			return strImg;
		},
		
		setAlertBox:function(imei, asset_name){
			$("#divalertbox").show("show");
			var div = document.getElementById("divalertcontent");
			var request = $.ajax({ url: "/dashboard/ajax/mapdata", type: "GET", data: {action: "GET_ALERT", imei: imei},  dataType: "json"});
			request.done(function(returnArrays) 
			{
			var html = "";
			var listalert = ["Power cut","Accident", "SOS", "Antithef","Low speed", "Hight speed", "Geo out","Move","SOS","Low battery"];
			var listID03 = ["","Location Live","Mains ON", "Mains OFF", "Tamper ON","Tamper OFF", "Ignition ON", "Ignition OFF","SOS","Bat Below Threshold"];
				for(var index = 0; index < returnArrays.length; index++)
				{
					var returnInfo = returnArrays[index];
					
					var alert = returnInfo.alert;
					var datetime = returnInfo.timestamp;
					var asset_name = returnInfo.asset_name;
					var protocol = returnInfo.protocol;
					if(protocol != '4'){ //protocol 4 is ID03
						html += "<b>"+asset_name+"</b>:"+listalert[alert]+";"+datetime+"<br />";
					}else{
						html += "<b>"+asset_name+"</b>:"+listID03[alert]+";"+datetime+"<br />";
					}
				}
				div.innerHTML = html;
			});
		},
		
		setDivContent: function( imei)
		{
			var info = {};
			var list_imei = [];
			list_imei.push(imei);
			 $.ajax({
				url: "http://63.142.252.191/vts/index.php/tree_view/devices_location/",
				data: {'imeis': JSON.stringify(list_imei)},
				type: "POST",
                 async: false
			}).done(function(data){
				if(data['status'] == 'ok'){
					var records = data['summary'];
					for(var i=0; i<records.length; i++)
						{
							if(records[i]['packet'] != null){
								
								info.f_imei		= records[i]['packet']["imei"];
								info.f_code 		= records[i]['packet']["imei"];
								info.f_number 		= "";
								info.f_datetime 	= records[i]['packet']["packet_time"];
								info.f_signal		= records[i]['packet']["signal"];
								info.f_lat 		= records[i]['packet']["lat"];
								info.f_lon 		= records[i]['packet']["lng"];
                                                                info.ACC                = records[i]['packet']["ACC"];
                                                                info.network_timeout     = records[i]['packet']["network_timeout"];
								info.f_address 		= records[i]['packet']["address"];
								info.f_speed 		= records[i]['packet']["speed"];
                                                                info.ignition         = records[i]['packet']["ignition"];
                                                                info.beforeTime       = records[i]['packet']["beforeTime"];
								info.f_dir 		= records[i]['packet']["orientation"];
								info.f_ps 		= records[i]['packet']["ps"];
								info.f_ig		= records[i]['packet']["ig"];
                                                                info.data_received      = records[i]['packet']["data_received"];
								info.f_mil 		= records[i]['packet']["mileage"];
								info.f_ac 		= "0"
								info.f_fuel		= records[i]['packet']["fuel"];
								info.f_temp 		= records[i]['packet']["temperature"];
								info.f_input1	 	= "0";
								info.f_input2 		= "0";
								info.f_input3 		= "0";
								info.f_input4 		= "0";
								info.f_input5 		= "0";
								info.f_data1	 	= "0";
								info.f_data2 		= "0";
								info.f_data3 		= "0";
								info.f_data4 		= "0";
								info.f_asset_name 	= records[i]['name'];
								info.f_icon 		= records[i]['packet']["category_image"];
								info.f_protocol		= records[i]['device']["protocol"];
								info.f_driver_name	= records[i]['device']["driver_name"];
								info.f_mobile_number	= records[i]['device']["driver_contact_no"];
								info.showMark		= false;
								info.strImg = records[i]['packet']["category_image"];
	
			
				
					var div = document.getElementById("detailvehicle");
				
					var content = '';
				
		
					
					//var strImg = localDataInfo.getStateImg(info);
					var power = 'OFF';
					var ac ='WORKING';
                                        var network_timeout =  info.network_timeout ;
					if(info.f_ps == 1) power = "ON";
					if(info.f_ac == 0) power = "STOP";
                                         var minutes = info.beforeTime;
                                        var vehicleStatus = "";
                                        if(minutes < network_timeout &&  info.f_speed > 10){
                                            vehicleStatus = "Running";
                                        }else if(minutes < network_timeout &&  info.f_speed <= 0 && info.ignition == 'OFF'  ){
                                            vehicleStatus = "Parked";
                                        }else if(minutes < network_timeout &&  info.f_speed <= 10 && info.ignition == 'ON'){
                                            vehicleStatus = "Idle";
                                        }else if(minutes > network_timeout && minutes < (network_timeout+36000)){
                                            vehicleStatus = "Out of network";
                                        }else{
                                            vehicleStatus = "Out of network";

                                        }
					content = content + '<b>'+info.f_asset_name+'</b><br />';
					content = content + '<img src="' + info.f_icon + '" style="width:auto; height:30px">  &nbsp;&nbsp;&nbsp;<br />';
					content = content + 'IMEI: '+imei + '<br />';
                                        content = content + 'Ignition: '+info.ignition  + ', ';
                                        content = content + 'AC Status: '+info.ACC  + '<br />';
					content = content + 'Speed: '+ info.f_speed + ' km/h<br>';
					content = content + 'Address: '+info.f_address + '<br>';
                                        content = content + 'Status: '+ vehicleStatus + '<br>';
                                        content = content + 'Date-Time:'+info.f_datetime + '<br>';
					
                                       div.innerHTML = content;
					}
						}
			
			}
			});

		},
		
		setDivStyle : function(id)
		{
			var info = this.driveInformation;
			var divString = "carList_row" + id;
			var div = document.getElementById(divString);
			if(info[id].showMark == false)
			{
				div.style.backgroundColor = '#999';
			}
			else
			{
				div.style.backgroundColor = '#F4EDE3';
			}
		},
		//----------add by vuxuantuyen.mta@gmail.com 11/01/2014---------------
		
		checkboxClick:function(status, imei){
                   			var info = this.driveInformation;

			if(status == true)
			{
				this.selectedIndex.push(imei);

			}
			else
			{
				for(var i = 0; i < this.selectedIndex.length; i++)
				{
					if(this.selectedIndex[i] == imei)
					{
						this.selectedIndex.splice(i,1);	
					}
				}
	
			}
	
		},
		
		//-------------------------------------------------------
		
		
		divClick: function(id)
		{
			var info = this.driveInformation;
			this.setDivStyle(id);
			if(info[id].showMark == false)
			{
				this.selectedIndex.push(id);
				info[id].showMark = true;
                                
				globalFunc_AddMarker(info[id], id, true);
			}
			else
			{
				for(var i = 0; i < this.selectedIndex.length; i++)
				{
					if(this.selectedIndex[i] == id)
					{
						this.selectedIndex.splice(i,1);	
					}
				}
				info[id].showMark = false;
                               
				globalFunc_AddMarker(info[id], id, false);
			}
			this.setCenterPoint();
		},
		
		restoreMarker: function()
		{
			var info = this.driveInformation;
			
			for(var i = 0; i < info.length; i++)
			{
			
				for(var j = 0; j < this.selectedIndex.length; j++)
				{
					if(this.selectedIndex[j] == info[i].f_imei)
					{
						info[i].showMark = true;
						globalFunc_AddMarker(info[i], i, true);
					}
				}
				
			}
			
			this.setCenterPoint();
		},
		
		setCenterPoint: function()
		{
			var info = this.driveInformation;
			if(this.selectedIndex.length == 0)
				return;
			var count = 0;
			var lat = 0.0;
			var lng = 0.0;
			var zoom = 0 ;
			var bounds = new google.maps.LatLngBounds();
			for(var i = 0; i < info.length; i++)
			{
			
				for(var j = 0; j < this.selectedIndex.length; j++)
				{
					if(this.selectedIndex[j] == info[i].f_imei)
					{
						
						bounds.extend(new google.maps.LatLng(info[i].f_lat,info[i].f_lon));
					}
				}
				
			}
			if(tempGoogleMap != null)
				tempGoogleMap.fitBounds(bounds);
			if(tempGoogleMap != null)
				tempGoogleMap.panToBounds(bounds);
			var zoomLevel = 15;
			if(tempGoogleMap != null)
				 zoomLevel = tempGoogleMap.getZoom();
			lat = bounds.getCenter().lat();
			lng = bounds.getCenter().lng();
			
			globalFunc_setCenterZoom(lat, lng,zoomLevel);
		},
		
		
		//---------------------------------------this below for tracking-------------------------------------------
		
		getTrackingVehicleInfo : function(imei)
		{
			var self = this;
			g_playIndex=0;
			//g_currentVehicleInfo = [];
			var list_imei = [];
			list_imei.push(imei);
		 $.ajax({
				url: "ajaxviews/devices-location.php",
				data: {'imeis': JSON.stringify(list_imei)},
				type: "POST",
                async: false
			}).done(function(data){
				if(data['status'] == 'ok'){
					var records = data['summary'];
					for(var i=0; i<records.length; i++)
						{
							if(records[i]['packet'] != null){
							var info = {};
								info.f_code 		= records[i]['packet']["imei"];								
								info.f_datetime 	= records[i]['packet']["packet_time"];
								info.f_lat 			= records[i]['packet']["lat"];
								info.f_lon 			= records[i]['packet']["lng"];
								info.f_address 		= records[i]['packet']["address"];
								info.f_speed 		= records[i]['packet']["speed"];
								info.f_dir 			= records[i]['packet']["orientation"];
								info.f_ig			= records[i]['packet']["ig"];								
								info.strImg = self.getTrackingStateImg(info);
								info.f_imei = imei;
								g_currentVehicleInfo.push(info);
							}
						}
				}
			});
			
			
				tk_globalDrawPolyLineOnMap();
		
		},
		
		getTrackingStateImg : function(info)
		{
			var strImg = "media/cars/";
			
			{
				if(info.f_speed == 0 && info.f_ig == 0)
				{
					strImg = strImg + "red/";
				}
				else if(info.f_speed == 0 && info.f_ig  == 1)
				{
					strImg = strImg + "yellow/";
				}
				else if(info.f_speed > 60 )
				{
					strImg = strImg + "blue/";
				}
				else
				{
					strImg = strImg + "green/";
				}
				
				var direction = (info.f_dir / 3).toFixed(0);
				strImg = strImg + direction*3 + ".png";
				
			}
			
			return strImg;
		},
		
	};
}());