$(function() {
	// Define toggleFullScreen
	var toggleFullScreen = {
	    init: function() {
	        if ((window.screenfull !== undefined) && screenfull.enabled) {
	            $('#toggleFullScreen').on('click', function(e) {
	                screenfull.toggle(window.document[0]);
	                $('body').toggleClass('fullScreen');
	                e.preventDefault();
	            });
	        } else {
	            $('#toggleFullScreen').addClass('hidden');
	        }
	    }
	};
	// toggleFullScreen init
	toggleFullScreen.init();

	var boxFullScreen = {
	    init: function() {
	        if ((window.screenfull !== undefined) && screenfull.enabled) {
	            $('.full-box').on('click', function(e) {
	              var $toggledPanel = $(this).parents('.box')[0];
	                screenfull.toggle($toggledPanel);
	                $(this).parents('.box').toggleClass('full-screen-box');
	                $(this).parents('.box').children('.body').toggleClass('full-screen-box');
	                $(this).children('i').toggleClass('fa-compress');
	                e.preventDefault();
	            });
	        } else {
	            $('.full-box').addClass('hidden');
	        }
	    }
	};
	// boxFullScreen init
	boxFullScreen.init();
	  
 })
 
 
 function modalsAlert(title, message, id){
	var obj = $("#"+id);
	
	var html = '<div class="modal-dialog"> '+
        		'<div class="modal-content">'+
    			'<div class="modal-header">'+
    			'<button type="button" class="close" data-dismiss="modal"'+
    			'aria-hidden="true">&times;</button>'+
    			'<h4 class="modal-title">'+title+'</h4>'+
    			'</div>'+
    			'<div class="modal-body">'+
    			'<p>'+
    				message +
    			'</p>'+
    			'</div>'+
    			'<div class="modal-footer">'+
                '<button type="button" class="btn btn-default" data-dismiss="modal">OK</button>'+
                '</div>'
    			'</div>'+
    			'</div>';
	 obj.html(html);
	 obj.modal(); 
}

function make_ts(dstr){
    var match = dstr.match(/^(\d+)-(\d+)-(\d+) (\d+)\:(\d+)\:(\d+)$/);
    var date = new Date(match[1], match[2] - 1, match[3], match[4], match[5], match[6]);
    return date;
}
function round_ts(dstr){
	 var match = dstr.match(/^(\d+)-(\d+)-(\d+) (\d+)\:(\d+)\:(\d+)$/);
	    var date = new Date(match[1], match[2] - 1, match[3], 0, 0, 0);
	    return date;
}


function get_hms(totalSeconds){
    hours = Math.floor(totalSeconds / 3600);
    totalSeconds %= 3600;
    minutes = Math.floor(totalSeconds / 60);
    seconds = totalSeconds % 60;
    return  '' + hours + ':' + minutes + ':' + seconds;
}


function feedback(){
	var obj = $('#feedback_modals');
	var form = "";
	$.ajax({
		url: "forms/feedback.php",			
		type:'POST'
		
	    }).done(function(data){
	    	form= data;

	   	 obj.html(form);
	   	 obj.modal();
	    });
		
}
function saveFeedback(){
	var frm = $("#frm_feedback");

	$.ajax({
        type: frm.attr('method'),
        url: frm.attr('action'),
        data: frm.serialize(),
        success: function (data) {
           console.info(data);
           if(data['status']=='success'){
        	   $("#actionStatus1").removeClass('error').addClass('success').html("Save successful");           	   
           }else{
        	   $("#actionStatus1").removeClass('success').addClass('error').html("Can't save data, please contact administrator for supporting");
           }
        },
        error: function(data) {
            $("#actionStatus1").html("<font color='red'>Something went wrong!</font>");
        }
    });
}