<?php

	require_once("db.php");
	
	// This function is used to get the time difference from two dates passed into it.
	// Difference can have different formats, such as seconds, minutes, hours, weeks, days et.c
	function timeBetween($startDate, $endDate, $format = 1)
	{
		list($date,$time) = explode(' ',$endDate);
		$startdate = explode("-",$date);
		$starttime = explode(":",$time);
	
		list($date,$time) = explode(' ',$startDate);
		$enddate = explode("-",$date);
		$endtime = explode(":",$time);
	
		$secondsDifference = mktime($endtime[0],$endtime[1],$endtime[2],
			$enddate[1],$enddate[2],$enddate[0]) - mktime($starttime[0],
				$starttime[1],$starttime[2],$startdate[1],$startdate[2],$startdate[0]);
		
		switch($format){
			// Difference in Minutes
			case 1: 
				return floor($secondsDifference/60);
			// Difference in Hours    
			case 2:
				return floor($secondsDifference/60/60);
			// Difference in Days    
			case 3:
				return floor($secondsDifference/60/60/24);
			// Difference in Weeks    
			case 4:
				return floor($secondsDifference/60/60/24/7);
			// Difference in Months    
			case 5:
				return floor($secondsDifference/60/60/24/7/4);
			// Difference in Years    
			default:
				return floor($secondsDifference/365/60/60/24);
		}                
	}   
	function convertSpeed($kms, $unit="miles") {
		
		if($unit == 'angstrom'){
			$ratio = 10000000000000;
			$result = $kms * $ratio;
		}
		if($unit == 'centimeters'){
			$ratio = 100000;
			$result = $kms * $ratio;
		}
		if($unit == 'feet'){
			$ratio = 3280.84;
			$result = $kms * $ratio;
		}
		if($unit == 'furlongs'){
			$ratio = 4.97;
			$result = $kms * $ratio;
		}
		if($unit == 'inches'){
			$ratio = 39370.08;
			$result = $kms * $ratio;
		}
		if($unit == ' meters'){
			$ratio = 1000;
			$result = $kms * $ratio;
		}
		if($unit == 'microns'){
			$ratio = 1000000000;
			$result = $kms * $ratio;
		}
		if($unit == 'miles'){
			$ratio = 1.609344;
			$result = $kms / $ratio;
		}
		if($unit == 'millimeters'){
			$ratio = 1000000;
			$result = $kms * $ratio;
		}
		if($unit == 'yards'){
			$ratio = 1093.61;
			$result = $kms * $ratio;
		}
		return $result;
	}
	
	function create_image_file($str, $img_name) {
		
		$strCamData = $str;

		$StrAscii = "";
		While (strlen($strCamData) > 0) {
			$strTemp = substr($strCamData, 0, 2);    	
			$Value1 = chr(hexdec($strTemp));
			$StrAscii = $StrAscii.$Value1;
			//remove first 2 chars
			$strCamData = substr($strCamData, 2);
		}
		//8859_1 is the ISO code for ASCII plus Latin. Require this for image.
		mb_detect_encoding($StrAscii, 'UTF-8, ISO-8859-1',true);
		// write to file
		$fp = fopen(CAPTURE_PATH . $img_name, 'w');
		fwrite($fp, $StrAscii);
		fclose($fp);
	}
	
	function convert_time_zone($date_time, $to_tz, $ret_format = 'Y-m-d H:i:s', $from_tz = 'GMT') {
		$time_object = new DateTime($date_time, new DateTimeZone($from_tz));
		$time_object->setTimezone(new DateTimeZone($to_tz));
		return $time_object->format($ret_format);
    }
	
	function deg_to_decimal($deg) {
		
		if($deg == '') return 0.000000;
		
		$sign = substr($deg, -1);
		
		if(strtoupper($sign) == "N" || strtoupper($sign) == "E") $sign = 1;
		if(strtoupper($sign) == "W" || strtoupper($sign) == "S") $sign = -1;
		
		//1836.25582 latitude
		$deg = floatval(preg_replace('/^0+/','',$deg));
		$deg1 = explode(".",$deg);
		
		$degree = substr($deg, 0, 2);
		
		$first = intval(intval($deg1[0])/100);
		$last = intval(intval($deg1[0])%100);
		
		$deg = floatval($last.".".$deg1[1]) / 60;
		

		$decimal = $sign * (floatval($first + $deg));
		
		//echo "<br/>degree : $degree, Deg : $deg, Decimal : $decimal";
		
		return $decimal;
	}
	function deg_to_decimal2($deg) {
		
		if($deg == '') return 0.000000;
		
		$sign = substr($deg, -1);
		
		if(strtoupper($sign) == "N" || strtoupper($sign) == "E") $sign = 1;
		if(strtoupper($sign) == "W" || strtoupper($sign) == "S") $sign = -1;
		
		$deg = substr($deg, 0, strlen($deg)-1);
		
		$deg = preg_replace('/^0+/','',$deg);
		
		$degree = substr($deg, 0, 2);
		
		$deg = substr($deg, 2);

		if(!strpos('.', $deg)) {
		  $deg = ($deg/10000);
		}

		$decimal = $sign * (floatval((($degree * 1.0) + ($deg/60))));
		
		//echo "<br/>degree : $degree, Deg : $deg, Decimal : $decimal";
		
		return $decimal;
	}
	function deg_to_decimal_new($deg) {
		
		if($deg == '') return 0.000000;
				
		if($deg < 0)
			$sign = -1;
		else
			$sign = 1;
		
		$deg = substr($deg, 1, strlen($deg));
				
		$deg = preg_replace('/^0+/','',$deg);
		
		$degree = substr($deg, 0, 2);
		
		$deg = substr($deg, 2);
		
		$decimal = $sign * number_format(floatval((($degree * 1.0) + ($deg/60))),6);
		
		return $decimal;
	}
	
	function getNearest($lat, $lng){
		$query = "SELECT latitude, longitude, address, 
			 ( 3959 * acos( cos( radians($lat) ) * cos( radians( latitude ) ) 
			  * cos( radians( longitude ) - radians($lng) ) + sin( radians($lat) ) 
			  * sin( radians( latitude ) ) ) ) AS distance 
			FROM tbl_geodata HAVING distance < 50 
			ORDER BY distance LIMIT 1";
		$res = mysql_query($query);
		
		if(mysql_num_rows($res) > 0){
			$row = mysql_fetch_assoc($res);
			return number_format($row['distance'], 2)." Km from ".$row['address'];
		}else{
			return '';
		}
	}
	
	function distance($a, $b)
	{
		list($lat1, $lon1) = $a;
		list($lat2, $lon2) = $b;

		$theta = $lon1 - $lon2;
		$dist = sin(@deg2rad($lat1)) * sin(@deg2rad($lat2)) +  cos(@deg2rad($lat1)) * cos(@deg2rad($lat2)) * cos(@deg2rad($theta));
		$dist = acos($dist);
		$dist = rad2deg($dist);
		$miles = $dist * 60 * 1.1515;
		return $miles;
	}

	function is_in_polygon($points_polygon, $vertices_x, $vertices_y, $longitude_x, $latitude_y)
	{
	  $i = $j = $c = 0;
	  for ($i = 0, $j = $points_polygon-1 ; $i < $points_polygon; $j = $i++) {
	    if ( (($vertices_y[$i] > $latitude_y != ($vertices_y[$j] > $latitude_y)) &&
	    ($longitude_x < ($vertices_x[$j] - $vertices_x[$i]) * ($latitude_y - $vertices_y[$i]) / ($vertices_y[$j] - $vertices_y[$i]) + $vertices_x[$i]) ) ) 
		$c = !$c;
	  }
	  return $c;
	}


	function getAddress($lat, $lng) {
		
		$today = gmdate(DATE);
		
		if(intval($lat) == 0 && intval($lng) == 0) {
			return '';
		}

		$query = "SELECT address FROM tbl_cell_data WHERE latitude = '$lat' AND longitude = '$lng' ORDER BY id DESC LIMIT 0,1";
		$res = mysql_query($query);
		
		if(mysql_num_rows($res) > 0){
			$row = mysql_fetch_assoc($res);
			return $row['address'];
		}
		else {
			
			$limit_query = "SELECT google, mapquest, yahoo FROM api_requests WHERE add_date = '$today'";
			$limit_res   = mysql_query($limit_query);
			
			if(mysql_num_rows($limit_res)>0){
				$row = mysql_fetch_assoc($limit_res);
				
				if($row['google']<=2500){				
					$address = googleGeocode($lat, $lng);
					$qryUpdt = "UPDATE api_requests SET google=".intval($row['google']+1)." WHERE add_date='$today'";
					$insrtGeo = mysql_query($qryUpdt);
				}
				else if($row['yahoo']<=4500){
					$address = yahooGeocode($lat, $lng);
					$qryUpdt = "UPDATE api_requests SET yahoo=".intval($row['yahoo']+1)." WHERE add_date='$today'";
					$insrtGeo = mysql_query($qryUpdt);
				}
				else{
					$lat = substr($lat, 0, 7);
					$lng = substr($lng, 0, 7);
					$query = "SELECT address FROM tbl_cell_data WHERE latitude like '%$lat%' AND longitude like '%$lng%' ORDER BY id DESC LIMIT 0,1";
					$res = mysql_query($query);
					
					if(mysql_num_rows($res) > 0){
						$row = mysql_fetch_assoc($res);
						return $row['address'];
					}
					return '';
				}
			}else{
				$qryGeo = "Insert into api_requests values(NULL,1,0,0,'$today')";
				$insrtGeo = mysql_query($qryGeo);
				$address = googleGeocode($lat, $lng);
				
			}
			if($address == '')
				return '';
				
			$insert = "INSERT INTO tbl_cell_data(latitude, longitude, address, add_date) VALUES ('".addslashes($lat)."', '".addslashes($lng)."', '".addslashes($address)."', '".$today."')";
			@mysql_query($insert);			
			return $address;
			
		}
	}
	
	function googleGeocode($lat,$lng){
		//Google Map
		$latlng = "$lat,$lng";
		$strURL = "http://maps.google.com/maps/api/geocode/xml?latlng=". $latlng ."&sensor=false&region=in";
		
		$address = "";
		
		$resURL = curl_init();
		curl_setopt($resURL, CURLOPT_URL, $strURL);
		curl_setopt($resURL, CURLOPT_RETURNTRANSFER, true);
		$xmlstr = curl_exec($resURL);
		
		$objDOM = new DOMDocument();
		
		if(! @$objDOM->loadXML($xmlstr)) {
			//die("XML Parsing Failed");
			return '';
		}
		
		$address = @$objDOM->getElementsByTagName("formatted_address")->item(0)->nodeValue;
		if($address!=""){
			return $address;
		}else{
			return '';
		}		
	}


	function yahooGeocode($lat,$lng){
		$address = "";
		//$strURL = "http://where.yahooapis.com/geocode?q=".$latlng."&gflags=R&appid=7c4fb61963dbd896a6237ba53d896f85629ee99b";
		$strURL = 'http://query.yahooapis.com/v1/public/yql?q='.urlencode('select * from geo.placefinder where text="'.$lat.','.$lng.'" and gflags="R"');
		$resURL = curl_init();
		curl_setopt($resURL, CURLOPT_URL, $strURL);
		curl_setopt($resURL, CURLOPT_RETURNTRANSFER, true);
		$xmlstr = curl_exec($resURL);
		
		$objDOM = new DOMDocument();
		
		if(! @$objDOM->loadXML($xmlstr)) {
			//die("XML Parsing Failed");
			return '';
		}
		if( strstr(@$objDOM->getElementsByTagName("line2")->item(0)->nodeValue,"$lat")){
			return '';
		}
		
		$address = @$objDOM->getElementsByTagName("line1")->item(0)->nodeValue;
		if( @$objDOM->getElementsByTagName("line2")->item(0)->nodeValue!=""){
			$address .= ", ".@$objDOM->getElementsByTagName("line2")->item(0)->nodeValue;
		}
		if( @$objDOM->getElementsByTagName("line3")->item(0)->nodeValue!=""){
			$address .= ", ".@$objDOM->getElementsByTagName("line3")->item(0)->nodeValue;
		}
		if( @$objDOM->getElementsByTagName("line4")->item(0)->nodeValue!=""){
			$address .= ", ".@$objDOM->getElementsByTagName("line4")->item(0)->nodeValue;
		}
		return $address;
	}

	function MapQuestGeocode($lat,$lng){
	
		$strURL = "http://www.mapquestapi.com/geocoding/v1/reverse?key=Fmjtd|luuan16b21%2Ca2%3Do5-96rauy&lat=$lat&lng=$lng&callback=renderReverse&inFormat=kvp&outFormat=xml";
		$address = "";
		
		$resURL = curl_init();
		curl_setopt($resURL, CURLOPT_URL, $strURL);
		curl_setopt($resURL, CURLOPT_RETURNTRANSFER, true);
		$xmlstr = curl_exec($resURL);
		
		$objDOM = new DOMDocument();
		
		if(! @$objDOM->loadXML($xmlstr)) {
			//die("XML Parsing Failed");
			return '';
		}
		
		$address = @$objDOM->getElementsByTagName("street")->item(0)->nodeValue;
		if( @$objDOM->getElementsByTagName("adminArea5")->item(0)->nodeValue!=""){
			$address .= ", ".@$objDOM->getElementsByTagName("adminArea5")->item(0)->nodeValue;
		}
		if( @$objDOM->getElementsByTagName("adminArea3")->item(0)->nodeValue!=""){
			$address .= ", ".@$objDOM->getElementsByTagName("adminArea3")->item(0)->nodeValue;
		}
		if( @$objDOM->getElementsByTagName("adminArea4")->item(0)->nodeValue!=""){
			$address .= ", ".@$objDOM->getElementsByTagName("adminArea4")->item(0)->nodeValue;
		}
		if( @$objDOM->getElementsByTagName("adminArea1")->item(0)->nodeValue!=""){
			$address .= ", ".@$objDOM->getElementsByTagName("adminArea1")->item(0)->nodeValue;
		}
		return $address;
	}


	function getDistance($lat1, $lng1, $lat2, $lng2, $unit){
		$distance = 0;				
		
		if($lat1 && $lng1){
			$dist = 0;
			$theta = $lng1 - $lng2;  
			 $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));  
			 $dist = acos($dist);  
			 $dist = rad2deg($dist);  
			 $miles = $dist * 60 * 1.1515;  
			 
			 if ($unit == "K") {  
				 
				 $dstn = round(($miles * 1.609344), 2);
				 if(!is_nan($dstn)){
					 
					$distance = $dstn;  
					 
				 }
			 }  
			 else if ($unit == "N") {  
				  $distance = ($miles * 0.8684);  
			 }  
			 else {  
				 $distance = $miles;  
			 }
		}
		return $distance;
	}

	function chat_alert($to_mail, $to_mesg) {
		if($to_mail != '' && $to_mesg != '') {
			
			$data = array('to' => $to_mail, 'msg' => $to_mesg);
			
			$ch = curl_init();
			$url = "http://localhost/telnet/chat_alert.php";
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $data);	
			$curl_result = curl_exec ($ch);
			curl_close ($ch);
		}
	}
	
	function WriteLog($string) {
		$myFile = LOG_DIR . "log_".date(DISP_DATE).".txt";
		$fh = fopen($myFile, 'a') or die("can't open file");
		$current = date(DISP_TIME);
		$stringData = "[$current] : $string\r\n\r\n";
		fwrite($fh, $stringData);
		fclose($fh);		
	}


	function sec2HourMinute($seconds){
		
		$hours = floor($seconds / 3600);
		$minutes = floor(($seconds / 60) % 60);
		//$seconds = $seconds % 60;
		$HourMinute = "";
		if($hours > 0)		$HourMinute .= "$hours Hours ";
		if($minutes > 0)	$HourMinute .= "$minutes Minutes ";
		
		return $HourMinute;
	}

	function send_email($to, $subject, $msg) {
		
		$headers = "Nkonnect-VTS";
		$data = array("cmd"=>"", "to" => $to, "subject" => $subject, "msg" => $msg, "frm" =>$headers);
		$fields_string = '';
		foreach($data as $key=>$value){
			$fields_string .= $key.'='.$value.'&';
		}
		$ch = curl_init();
		$url = "http://72.2.112.25/telnet/email.php";
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$curl_result = curl_exec ($ch);
		curl_close ($ch);
		
		WriteLog($curl_result."\n");
		WriteLog("Mail Sent to $to\n Message :\n$msg");
	}
	
function log_raw_data($device, $data) {
  
  $rawsql = "INSERT INTO tbl_raw_data (device_id, raw_data, add_uid, add_date) VALUES ('".$device."','".$data."','1','".date(DATE_TIME)."')";
  
  $raw_res = mysql_query($rawsql);
}


?>