<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Eye View Design CMS module Ajax Model
 *
 * PHP version 5
 *
 * @category  CodeIgniter
 * @package   EVD CMS
 * @author    Frederico Carvalho
 * @copyright 2008 Mentes 100Limites
 * @version   0.1
 */
class ETAdetailsreport_model extends Model {

    /**
     * Instanciar o CI
     */
    public function ETAdetailsreport_model() {
        parent::Model();
        $this->CI = & get_instance();
        $this->load->database();
        $this->table_name = "bin_details";
        $this->tbl_assets = "assests_master";
    }

    function getAllData() {
        $cmd = $this->input->get('cmd');
        $user_id = $this->session->userdata('user_id');
        $page = isset($_GET["page"]) ? $_GET["page"] : 1;
        $limit = isset($_GET["rows"]) ? $_GET["rows"] : 10;
        $sidx = isset($_GET['sidx']) ? $_GET['sidx'] : 'id';
        $sord = isset($_GET['sord']) ? $_GET['sord'] : '';

        $SQL = "SELECT tau.journey_status,tau.assets_id,tau.user_id,tau.add_date,tau.DispatchDate,tau.id,tau.CustomerName,am.assets_name,tau.TPTName,tau.TotalDistance,tau.CurrentLocation,tau.Jaurneytarvelled_KM,tau.Bjt_travelled_km,tau.ExpectedArrivalDateTime,lm.name as Destination,tau.ETA FROM `tbl_Assets_url` tau LEFT JOIN assests_master am ON am.device_id=tau.assets_id LEFT JOIN landmark lm ON lm.id=tau.landmark_id WHERE tau.status=1 AND tau.del_date is null and tau.add_uid='".$user_id."'";
        $result = $this->db->query($SQL);
        $as_row = $result->result_array();
        $count = count($result->result_array());

        if ($count > 0) {
            $total_pages = ceil($count / $limit);
            $start = ($limit * $page) - $limit;
        } else {
            $total_pages = 0;
            $start = 0;
        }

        if ($page > $total_pages)
            $page = $total_pages;

        $SQL .= " ORDER BY tau.journey_status ASC";
        $query = $this->db->query($SQL);

        if ($cmd == 'export') {

            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=ETA-Details-Report" . date("s") . ".xls");
            $EXCEL = "";
            $fitr = "";

            //session date & time format
            $date_format = $this->session->userdata('date_format');
            $time_format = $this->session->userdata('time_format');

            $fitr .= "<tr>";
            $fitr .= "<th>Dispatch Date</th>";
            $fitr .= "<th>Customer Name</th>";
            $fitr .= "<th>Assets Name</th>";
            $fitr .= "<th>TPT Name</th>";
            $fitr .= "<th>Destination</th>";
            $fitr .= "<th>Total Distance</th>";
            $fitr .= "<th>Current Location</th>";
            $fitr .= "<th>Jaurney tarvelled(KM)</th>";
            $fitr .= "<th>Balance journey to be travelled(KM)</th>";
            $fitr .= "<th>Expected Arrival DateTime</th>";
            $fitr .= "<th>ETA</th>";
            $fitr .= "</tr>";
            foreach ($result->result_array() as $data) {
                $Date = $data['DispatchDate'];
                $EXCEL .= "<tr align='center'>";
                $EXCEL .= "<td>" . date("$date_format $time_format", strtotime($Date)) . "</td>";
                $EXCEL .= "<td>" . $data['CustomerName'] . "</td>";
                $EXCEL .= "<td>" . $data['assets_name'] . "</td>";
                $EXCEL .= "<td>" . $data['TPTName'] . "</td>";
                $EXCEL .= "<td>" . $data['Destination'] . "</td>";
                $EXCEL .= "<td>" . $data['TotalDistance'] . "</td>";
                $EXCEL .= "<td>" . $data['CurrentLocation'] . "</td>";
                $EXCEL .= "<td>" . $data['Jaurneytarvelled_KM'] . "</td>";
                $EXCEL .= "<td>" . $data['Bjt_travelled_km'] . "</td>";
                $EXCEL .= "<td>" . $data['ExpectedArrivalDateTime'] . "</td>";
                $EXCEL .= "<td>" . $data['ETA'] . "</td>";                
                $EXCEL .= "</tr>";
            }
            echo "<table border='1'>";
            echo "<tr><th colspan='5'> ETA Details Report </th></tr>";
            echo $fitr;
            echo $EXCEL;
            echo "</table>";
            die();
        }

        $data = array();
        $data['result'] = $query->result();
        $data['page'] = $page;
        $data['total_pages'] = $total_pages;
        $data['count'] = $count;
        $data['sql'] = $SQL;
        return $data;
    }

    public function prepareCombo() {

        $user_id = $this->session->userdata('user_id');

        if ($user_id != 1) {
            $SQL = "select id, device_id, assets_name from assests_master am where find_in_set(am.id, (SELECT assets_ids FROM user_assets_map um where user_id = $user_id)) AND am.status = 1 AND am.del_date is null";
        } else {
            $SQL = "SELECT device_id, assets_name FROM assests_master am WHERE am.status = 1 AND am.del_date is null";
        }

        $SQL .= " order by am.assets_name asc";

        $query = $this->db->query($SQL);

        $option = '';
        if ($query->num_rows() != 1)
            $option = "";
        foreach ($query->result() as $row) {
            $option .= "<option value='" . $row->device_id . "'>" . $row->assets_name . " (" . $row->device_id . ")</option>";
        }
        return $option;
    }

}

?>