<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=7" />
    <!--The viewport meta tag is used to improve the presentation and behavior of the
    samples on iOS devices-->
    <meta name="viewport" content="initial-scale=1, maximum-scale=1,user-scalable=no"
    />
    <title>
      Flickr
    </title>
    <link rel="stylesheet" type="text/css" href="http://serverapi.arcgisonline.com/jsapi/arcgis/2.2/js/dojo/dijit/themes/claro/claro.css">
    <style>
      html, body { height: 100%; width: 100%; margin: 0; padding: 0; } .esriScalebar{
      padding: 20px 20px; } #map{ padding:0; }
    </style>
    <script type="text/javascript">
      var djConfig = {
        parseOnLoad: true
      };
    </script>
    <script type="text/javascript" src="http://serverapi.arcgisonline.com/jsapi/arcgis/?v=2.2">
    </script>
    <script type="text/javascript">
      dojo.require("dijit.layout.BorderContainer");
      dojo.require("dijit.layout.ContentPane");
      dojo.require("esri.map");
      dojo.require("esri.layers.FeatureLayer");


      var map;
      var resizeTimer;

      function init() {
        //get geotagged photos from flickr
        var requestHandle = esri.request({
          url: "http://api.flickr.com/services/feeds/geo?tags=dog&tagmode=all&format=json",
          callbackParamName: "jsoncallback",
          load: requestSucceeded,
          error: requestFailed
        }, {
          useProxy: false
        });
        //setup the map's initial extent (World View)
        var initExtent = new esri.geometry.Extent({"xmin":-15043351,"ymin":2402839,"xmax":6892241,"ymax":13223877,"spatialReference":{"wkid":102100}});
        map = new esri.Map("map", {
          extent: initExtent
        });
        //Add the topographic layer to the map. View the ArcGIS Online site for services http://arcgisonline/home/search.html?t=content&f=typekeywords:service    
        var basemap = new esri.layers.ArcGISTiledMapServiceLayer("http://server.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer");
        map.addLayer(basemap);

        //resize the map when the browser resizes - view the 'Resizing and repositioning the map' section in 
        //the following help topic for more details http://help.esri.com/EN/webapi/javascript/arcgis/help/jshelp_start.htm#jshelp/inside_guidelines.htm
        dojo.connect(map, 'onLoad', function(theMap) {
          dojo.connect(dijit.byId('map'), 'resize', function() { //resize the map if the div is resized
            clearTimeout(resizeTimer);
            resizeTimer = setTimeout(function() {
              map.resize();
              map.reposition();
            }, 500);
          });
        });
      }

      function requestSucceeded(response, io) {
        //create a feature collection for the flickr photos
        var featureCollection = {
          "layerDefinition": null,
          "featureSet": {
            "features": [],
            "geometryType": "esriGeometryPoint"
          }
        };
        featureCollection.layerDefinition = {
          "geometryType": "esriGeometryPoint",
          "objectIdField": "OBJECTID",
          "drawingInfo": {
            "renderer": {
              "type": "simple",
              "symbol": {
                "type": "esriSMS",
                "style": "esriSMSCircle",
                "size": 10,
                "color": [0, 173, 81, 255]
              }
            }
          },
          "fields": [{
            "name": "OBJECTID",
            "alias": "OBJECTID",
            "type": "esriFieldTypeOID"
          }, {
            "name": "DEFINITION",
            "alias": "Details",
            "type": "esriFieldTypeString"
          }]
        };
        var id = 0;
        //loop through the items and add each to the feature collection
        dojo.forEach(response.items, function(item) {
          var attr = {};
          attr["OBJECTID"] = id;
          attr["DEFINITION"] = item.description;
          var geometry = esri.geometry.geographicToWebMercator(new esri.geometry.Point(item.longitude, item.latitude));
   
          var feature = {
            "geometry": geometry.toJson(),
            "attributes": attr
          };
          featureCollection.featureSet.features.push(feature);
          id++;

        });
        //create a feature layer based on the feature collection and define 
        //an info template
        var infoTemplate = new esri.InfoTemplate('Flickr', "${DEFINITION}");
        var featureLayer = new esri.layers.FeatureLayer(featureCollection, {
          infoTemplate: infoTemplate,
          id: 'flickrLayer'
        });
        //add the feature layer that contains the flickr photos to the map
        map.addLayer(featureLayer);
        map.infoWindow.resize(300, 300);

      }

      function requestFailed(error) {
        console.log('failed');
      }
      dojo.addOnLoad(init);
    </script>
  </head>  
  <body class="claro">
    <div dojotype="dijit.layout.BorderContainer" design="headline" gutters="false" style="width: 100%; height: 100%; margin: 0;">
      <div id="map" dojotype="dijit.layout.ContentPane" region="center" style="border:1px solid #000;padding:0;">
      </div>
    </div>
  </body>
</html>