<?php (defined('BASEPATH')) OR exit('No direct script access allowed');

class Device_settings extends Admin_Controller {
	
	function __construct() {

		parent::__construct(TRUE);

		$this->load->model('device_settings_model','',TRUE);
		$this->load->model('form_model','',TRUE);
		$this->load->helper('file');
		$this->load->helper('uri');
	}

	function index() {
		
		if (!$this->form_model->validate()) {
			$this->load->helper('form');
			$rows = $this->device_settings_model->fetch_devices();
			$opt = '';
			
			foreach ($rows as $row) {
				$opt .= '<option value="'.$row->device_id.'"';
				$opt .= '>'.$row->assets_name.' ('.$row->device_id.')</option>';
			}
			
			$this->form_model->device_ids = $opt;
			$this->load->view('device_settings');
		}
		else {
			
			$formdata = $this->form_model->db_array();
			$data = $this->device_settings_model->save($formdata);
			//die($data);
			$this->output->set_output($data);
			//die();
		}
	}
	
}
?>