/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CommandThread
extends Thread {
    public static String SERVERURL = "http://localhost/telnet/java.php";
    public static ServerSocket serverSocket;
    public static int COMMAND_PORT;
    protected ExecutorService threadPool = Executors.newCachedThreadPool();
    public static int countConnections;
    private List<Future<CommandThreadSingle>> tasks;
    private static int threadNo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        while (true) {
            try {
                try {
                    serverSocket = new ServerSocket(COMMAND_PORT, 2000);
                    this.tasks = new CopyOnWriteArrayList();
                    System.out.println("Opening Port " + COMMAND_PORT);
                    while (true) {
                        Socket socket = serverSocket.accept();
                        ++countConnections;
                        Future future = this.threadPool.submit(new CommandThreadSingle(socket, ++threadNo));
                        this.tasks.add(future);
                    }
                }
                catch (RuntimeException runtimeException) {
                    CommandThreadSingle.appendLog((String)("Error CT:" + runtimeException.getMessage()), (String)"ErrorLog.txt");
                    try {
                        serverSocket.close();
                        CommandThreadSingle.appendLog((String)("CT " + COMMAND_PORT + " Closed"), (String)"ErrorLog.txt");
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Could not close socket Server:" + exception.getMessage());
                        System.exit(0);
                        break;
                    }
                }
                catch (Exception exception) {
                    CommandThreadSingle.appendLog((String)("Error CT:" + exception.getMessage()), (String)"ErrorLog.txt");
                    continue;
                }
                catch (Error error) {
                    CommandThreadSingle.appendLog((String)("Error e CT:" + error.getMessage()), (String)"ErrorLog.txt");
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        serverSocket.close();
                        CommandThreadSingle.appendLog((String)("CT " + COMMAND_PORT + " Closed"), (String)"ErrorLog.txt");
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Could not close socket Server:" + exception.getMessage());
                        System.exit(0);
                        break;
                    }
                }
                {
                    finally {
                        try {
                            serverSocket.close();
                            CommandThreadSingle.appendLog((String)("CT " + COMMAND_PORT + " Closed"), (String)"ErrorLog.txt");
                        }
                        catch (Exception exception) {
                            System.out.println("Could not close socket Server:" + exception.getMessage());
                            System.exit(0);
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                CommandThreadSingle.appendLog((String)("CT Final loop Ex:" + exception.getMessage()), (String)"ErrorLog.txt");
                break;
            }
            catch (Error error) {
                CommandThreadSingle.appendLog((String)("CT Final loop Er:" + error.getMessage()), (String)"ErrorLog.txt");
                break;
            }
        }
    }

    public void sendDataCommand(String string, String string2) {
        boolean bl = false;
        for (Future future : this.tasks) {
            try {
                if (((CommandThreadSingle)future.get()).getDeviceId() == null || !((CommandThreadSingle)future.get()).getDeviceId().equals(string)) continue;
                ((CommandThreadSingle)future.get()).setDeviceCommand(string2);
                bl = true;
                break;
            }
            catch (Exception exception) {
                CommandThreadSingle.appendLog((String)("ERROR sendDataCommand() " + exception), (String)"cmd-response.txt");
            }
        }
        if (!bl) {
            System.out.println("Device ID not found");
            CommandThreadSingle.appendLog((String)("Device ID not found " + string + " - " + string2), (String)"cmd-response.txt");
        }
    }

    public void viewDeviceCommand(String string) {
        boolean bl = false;
        for (Future future : this.tasks) {
            try {
                if (!((CommandThreadSingle)future.get()).getDeviceId().equals(string)) continue;
                bl = true;
                break;
            }
            catch (Exception exception) {
                CommandThreadSingle.appendLog((String)("ERROR viewDeviceCommand()" + exception), (String)"cmd-response.txt");
            }
        }
        if (!bl) {
            System.out.println("Device ID not found");
            CommandThreadSingle.appendLog((String)("Device ID not found  - " + string), (String)"cmd-response.txt");
        } else {
            System.out.println("Device ID Exists");
            CommandThreadSingle.appendLog((String)("Device ID Exists  - " + string), (String)"cmd-response.txt");
        }
    }

    public void viewDeviceCommand() {
        System.out.println("List of devices connected:");
        int n = 0;
        String string = "";
        if (this.tasks != null) {
            for (Future future : this.tasks) {
                try {
                    String string2 = ((CommandThreadSingle)future.get()).getDeviceId();
                    if (string2 != null && string2.length() > 0) {
                        System.out.println("ID:" + string2);
                        string = string + "Id: " + string2 + "\n";
                        ++n;
                    }
                    if (n % 100 != 0) continue;
                    CommandThreadSingle.appendLog((String)string, (String)"cmd-response.txt");
                    string = "";
                }
                catch (Exception exception) {
                    CommandThreadSingle.appendLog((String)("Error viewDeviceCommand()  - " + exception), (String)"cmd-response.txt");
                }
            }
            if (!string.equals("")) {
                CommandThreadSingle.appendLog((String)string, (String)"cmd-response.txt");
                string = "";
            }
            CommandThreadSingle.appendLog((String)("List of devices connected: " + n), (String)"cmd-response.txt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommandToDevice() {
        try {
            List list = TrackVehicleOnline.getLines();
            RandomAccessFile randomAccessFile = new RandomAccessFile(new File(System.getProperty("user.dir") + File.separator + "Command_Log_" + COMMAND_PORT + ".txt"), "rwd");
            FileChannel fileChannel = randomAccessFile.getChannel();
            fileChannel.truncate(0L);
            while (list.size() != 0) {
                String string = (String)list.get(0);
                if (string.contains("Device_Id:") && string.contains("Command:")) {
                    String string2 = string.substring(string.indexOf("Device_Id:"));
                    String string3 = string2.substring(string2.indexOf(" Command:") + 9);
                    string2 = string2.substring(0, string2.indexOf(" Command:"));
                    String string4 = string2.substring(string2.indexOf("Device_Id:") + 10);
                    if (this.tasks != null) {
                        boolean bl = false;
                        for (Future future : this.tasks) {
                            String string5 = "";
                            OutputStream outputStream = null;
                            try {
                                string5 = ((CommandThreadSingle)future.get()).getDeviceId();
                                if (string5 == null || !string5.equals(string4)) continue;
                                outputStream = ((CommandThreadSingle)future.get()).getOutputConnection();
                                outputStream.write(string3.getBytes());
                                bl = true;
                            }
                            catch (Exception exception) {
                                CommandThreadSingle.appendLog((String)("Error readAndSendData-IP:" + string4 + " Data:" + string3 + " Error:" + exception), (String)"ErrorLog.txt");
                                bl = false;
                            }
                            catch (Error error) {
                                CommandThreadSingle.appendLog((String)("Error readAndSendData-IP:" + string4 + " Data:" + string3 + " Error:" + error), (String)"ErrorLog.txt");
                                bl = false;
                            }
                            finally {
                                if (outputStream == null) continue;
                                try {
                                    outputStream.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (!bl) {
                            randomAccessFile.write(((String)list.get(0) + System.getProperty("line.separator")).getBytes());
                        }
                    } else {
                        randomAccessFile.write(((String)list.get(0) + System.getProperty("line.separator")).getBytes());
                    }
                    list.remove(0);
                    continue;
                }
                list.remove(0);
            }
            fileChannel.close();
            randomAccessFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeFinishedTasks() {
        if (this.tasks != null) {
            for (Future future : this.tasks) {
                try {
                    String string = ((CommandThreadSingle)future.get()).getDeviceId();
                    if (string == null || !string.equals("")) continue;
                    this.tasks.remove(future);
                }
                catch (Exception exception) {
                    CommandThreadSingle.appendLog((String)("Error removeFinishedTasks()  - " + exception), (String)"ErrorLog.txt");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCommandLogFile() {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(System.getProperty("user.dir") + File.separator + "Command_Log_" + COMMAND_PORT + ".txt")));
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.contains("Device_Id:") || !string.contains("Data:")) continue;
                String string2 = string.substring(string.indexOf("Device_Id:"));
                String string3 = string2.substring(string2.indexOf(" Data:") + 6);
                string2 = string2.substring(0, string2.indexOf(" Data:"));
                String string4 = string2.substring(string2.indexOf("Device_Id:") + 10);
                for (Future future : this.tasks) {
                    String string5 = "";
                    try {
                        string5 = ((CommandThreadSingle)future.get()).getDeviceId();
                        if (string5 == null || string5.equals(string4)) continue;
                        OutputStream outputStream = ((CommandThreadSingle)future.get()).getOutputConnection();
                        outputStream.write(string3.getBytes());
                    }
                    catch (Exception exception) {
                        CommandThreadSingle.appendLog((String)("Error readAndSendData-IP:" + string4 + " Data:" + string3 + " Error:" + exception), (String)"ErrorLog.txt");
                    }
                    catch (Error error) {
                        CommandThreadSingle.appendLog((String)("Error readAndSendData-IP:" + string4 + " Data:" + string3 + " Error:" + error), (String)"ErrorLog.txt");
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            TrackVehicleOnline.isReadingFile = false;
        }
    }

    static {
        COMMAND_PORT = 6060;
        countConnections = 0;
        threadNo = 0;
    }
}

