/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CommandThread
extends Thread {
    public static String SERVERURL = "http://localhost/telnet/java.php";
    public static ServerSocket serverSocket;
    public static int COMMAND_PORT;
    public static String COMMAND_REQUEST_RESPONSE;
    protected ExecutorService threadPool = Executors.newCachedThreadPool();
    public static int countConnections;
    private List<Future<CommandThreadSingle>> tasks;
    private static int threadNo;

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        try {
            while (true) {
                try {
                    serverSocket = new ServerSocket(COMMAND_PORT, 2000);
                    this.tasks = new CopyOnWriteArrayList<Future<CommandThreadSingle>>();
                    System.out.println("Opening Port " + COMMAND_PORT);
                    while (true) {
                        Object object = serverSocket.accept();
                        ++countConnections;
                        object = this.threadPool.submit(new CommandThreadSingle((Socket)object, ++threadNo));
                        this.tasks.add((Future<CommandThreadSingle>)object);
                    }
                }
                catch (RuntimeException runtimeException) {
                    CommandThreadSingle.appendLog("Error CT:" + runtimeException.getMessage(), "ErrorLog.txt");
                    try {
                        serverSocket.close();
                        CommandThreadSingle.appendLog("CT " + COMMAND_PORT + " Closed", "ErrorLog.txt");
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Could not close socket Server:" + exception.getMessage());
                        System.exit(0);
                        break;
                    }
                }
                catch (Exception exception) {
                    CommandThreadSingle.appendLog("Error CT:" + exception.getMessage(), "ErrorLog.txt");
                    continue;
                }
                catch (Error error) {
                    CommandThreadSingle.appendLog("Error e CT:" + error.getMessage(), "ErrorLog.txt");
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        serverSocket.close();
                        CommandThreadSingle.appendLog("CT " + COMMAND_PORT + " Closed", "ErrorLog.txt");
                        continue;
                    }
                    catch (Exception exception) {
                        System.out.println("Could not close socket Server:" + exception.getMessage());
                        System.exit(0);
                        break;
                    }
                }
                {
                    finally {
                        try {
                            serverSocket.close();
                            CommandThreadSingle.appendLog("CT " + COMMAND_PORT + " Closed", "ErrorLog.txt");
                        }
                        catch (Exception exception) {
                            System.out.println("Could not close socket Server:" + exception.getMessage());
                            System.exit(0);
                            break;
                        }
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception exception) {
            CommandThreadSingle.appendLog("CT Final loop Ex:" + exception.getMessage(), "ErrorLog.txt");
            return;
        }
        catch (Error error) {
            CommandThreadSingle.appendLog("CT Final loop Er:" + error.getMessage(), "ErrorLog.txt");
        }
    }

    public void sendDataCommand(String string, String string2) {
        boolean bl = false;
        for (Future<CommandThreadSingle> future : this.tasks) {
            try {
                if (future.get().getDeviceId() == null || !future.get().getDeviceId().equals(string)) continue;
                future.get().setDeviceCommand(string2);
                bl = true;
                break;
            }
            catch (Exception exception) {
                CommandThreadSingle.appendLog("ERROR sendDataCommand() " + exception, "cmd-response.txt");
            }
        }
        if (!bl) {
            System.out.println("Device ID not found");
            CommandThreadSingle.appendLog("Device ID not found " + string + " - " + string2, "cmd-response.txt");
        }
    }

    public void viewDeviceCommand(String string) {
        boolean bl = false;
        for (Future<CommandThreadSingle> future : this.tasks) {
            try {
                if (!future.get().getDeviceId().equals(string)) continue;
                bl = true;
                break;
            }
            catch (Exception exception) {
                CommandThreadSingle.appendLog("ERROR viewDeviceCommand()" + exception, "cmd-response.txt");
            }
        }
        if (!bl) {
            System.out.println("Device ID not found");
            CommandThreadSingle.appendLog("Device ID not found  - " + string, "cmd-response.txt");
            return;
        }
        System.out.println("Device ID Exists");
        CommandThreadSingle.appendLog("Device ID Exists  - " + string, "cmd-response.txt");
    }

    public void viewDeviceCommand() {
        System.out.println("List of devices connected:");
        int n = 0;
        String string = "";
        if (this.tasks != null) {
            for (Future<CommandThreadSingle> exception : this.tasks) {
                try {
                    String string2 = exception.get().getDeviceId();
                    if (string2 != null && string2.length() > 0) {
                        System.out.println("ID:" + string2);
                        string = string + "Id: " + string2 + "\n";
                        ++n;
                    }
                    if (n % 100 != 0) continue;
                    CommandThreadSingle.appendLog(string, "cmd-response.txt");
                    string = "";
                }
                catch (Exception exception2) {
                    CommandThreadSingle.appendLog("Error viewDeviceCommand()  - " + exception2, "cmd-response.txt");
                }
            }
            if (!string.equals("")) {
                CommandThreadSingle.appendLog(string, "cmd-response.txt");
            }
            CommandThreadSingle.appendLog("List of devices connected: " + n, "cmd-response.txt");
        }
    }

    /*
     * Loose catch block
     */
    public void sendCommandToDevice() {
        try {
            List<String> list = TrackVehicleOnline.getLines();
            RandomAccessFile randomAccessFile = new RandomAccessFile(new File(System.getProperty("user.dir") + File.separator + "Command_Log_" + COMMAND_PORT + ".txt"), "rwd");
            FileChannel fileChannel = randomAccessFile.getChannel();
            fileChannel.truncate(0L);
            while (list.size() != 0) {
                String string = list.get(0);
                if (string.contains("Device_Id:") && string.contains("Command:")) {
                    string = string.substring(string.indexOf("Device_Id:"));
                    String string2 = string.substring(string.indexOf(" Command:") + 9);
                    string = string.substring(0, string.indexOf(" Command:"));
                    string = string.substring(string.indexOf("Device_Id:") + 10);
                    if (this.tasks != null) {
                        boolean bl = false;
                        for (Future<CommandThreadSingle> future : this.tasks) {
                            String string3 = null;
                            OutputStream outputStream = null;
                            string3 = future.get().getDeviceId();
                            if (string3 != null && string3.equals(string)) {
                                outputStream = future.get().getOutputConnection();
                                outputStream.write(string2.getBytes());
                                bl = true;
                            }
                            if (outputStream == null) continue;
                            try {
                                outputStream.close();
                            }
                            catch (Exception exception) {}
                            continue;
                            catch (Exception exception) {
                                CommandThreadSingle.appendLog("Error readAndSendData-IP:" + string + " Data:" + string2 + " Error:" + exception, "ErrorLog.txt");
                                bl = false;
                                if (outputStream == null) continue;
                                try {
                                    outputStream.close();
                                }
                                catch (Exception exception2) {}
                                continue;
                            }
                            catch (Error error) {
                                CommandThreadSingle.appendLog("Error readAndSendData-IP:" + string + " Data:" + string2 + " Error:" + error, "ErrorLog.txt");
                                bl = false;
                                if (outputStream == null) continue;
                                {
                                    catch (Throwable throwable) {
                                        if (outputStream != null) {
                                            try {
                                                outputStream.close();
                                            }
                                            catch (Exception exception) {}
                                        }
                                        throw throwable;
                                    }
                                }
                                try {
                                    outputStream.close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (!bl) {
                            randomAccessFile.write((list.get(0) + System.getProperty("line.separator")).getBytes());
                        }
                    } else {
                        randomAccessFile.write((list.get(0) + System.getProperty("line.separator")).getBytes());
                    }
                    list.remove(0);
                    continue;
                }
                list.remove(0);
            }
            fileChannel.close();
            randomAccessFile.close();
            return;
        }
        catch (Exception exception) {
            Exception exception3 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public void removeFinishedTasks() {
        if (this.tasks != null) {
            for (Future<CommandThreadSingle> future : this.tasks) {
                try {
                    String string = future.get().getDeviceId();
                    if (string == null || !string.equals("")) continue;
                    this.tasks.remove(future);
                }
                catch (Exception exception) {
                    CommandThreadSingle.appendLog("Error removeFinishedTasks()  - " + exception, "ErrorLog.txt");
                }
            }
        }
    }

    public void readCommandLogFile() {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(System.getProperty("user.dir") + File.separator + "Command_Log_" + COMMAND_PORT + ".txt")));
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.contains("Device_Id:") || !string.contains("Data:")) continue;
                string = string.substring(string.indexOf("Device_Id:"));
                String string2 = string.substring(string.indexOf(" Data:") + 6);
                string = string.substring(0, string.indexOf(" Data:"));
                string = string.substring(string.indexOf("Device_Id:") + 10);
                for (Future<CommandThreadSingle> exception : this.tasks) {
                    String string3 = null;
                    try {
                        string3 = exception.get().getDeviceId();
                        if (string3 == null || string3.equals(string)) continue;
                        OutputStream error = exception.get().getOutputConnection();
                        error.write(string2.getBytes());
                    }
                    catch (Exception exception2) {
                        CommandThreadSingle.appendLog("Error readAndSendData-IP:" + string + " Data:" + string2 + " Error:" + exception2, "ErrorLog.txt");
                    }
                    catch (Error error) {
                        CommandThreadSingle.appendLog("Error readAndSendData-IP:" + string + " Data:" + string2 + " Error:" + error, "ErrorLog.txt");
                    }
                }
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
        finally {
            TrackVehicleOnline.isReadingFile = false;
        }
    }

    static {
        COMMAND_PORT = 6060;
        COMMAND_REQUEST_RESPONSE = "";
        countConnections = 0;
        threadNo = 0;
    }
}

