/*
 * Decompiled with CFR 0.152.
 */
package serversocketminagt06;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import serversocketminagt06.ConnectionManager;
import serversocketminagt06.DBConfiguration;
import serversocketminagt06.DataHandler;
import serversocketminagt06.Message;

public class HandlerClass
extends IoHandlerAdapter {
    ExecutorService executorService = null;
    String pattern = "YYYY-MM-dd HH:mm:ss";
    SimpleDateFormat format = new SimpleDateFormat(this.pattern);
    static long globalTaskCount;
    long taskCount;

    public HandlerClass() {
        ConnectionManager connectionManager = new ConnectionManager(new DBConfiguration());
        this.executorService = Executors.newCachedThreadPool();
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        System.out.println("Error in handler class for " + session.getRemoteAddress() + " at " + this.format.format(new Date()) + " due to ");
        cause.printStackTrace();
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        Message rawdata = (Message)message;
        String actualData = rawdata.message;
        System.out.println(actualData);
        String protocol = actualData.substring(9, 11);
        System.out.println("Protocol in message is " + Integer.toHexString(rawdata.protocol));
        if (protocol.equals("01")) {
            String phoneNO;
            System.out.println("Protocol is 01");
            String phoneNoTemp = actualData.substring(12, 35);
            System.out.println("phoneNoTemp is " + phoneNoTemp);
            String phoneNoWithoutSpaces = phoneNoTemp.replaceAll(" ", "");
            String deviceNO = phoneNO = phoneNoWithoutSpaces.startsWith("0") ? phoneNoWithoutSpaces.substring(1) : phoneNoWithoutSpaces;
            System.out.println("Phone no. is " + phoneNO);
            session.setAttribute((Object)"deviceNO", (Object)deviceNO);
        } else {
            String deviceNO = (String)session.getAttribute((Object)"deviceNO");
            this.executorService.execute(new DataHandler(protocol, actualData, session.getRemoteAddress().toString(), this.format.format(new Date()), deviceNO));
            System.out.println("Protocol is " + protocol);
        }
        session.write((Object)rawdata);
    }

    public void sessionCreated(IoSession session) throws Exception {
        System.out.println("Session Created with " + session.getRemoteAddress() + " at " + this.format.format(new Date()));
    }

    public void sessionOpened(IoSession session) throws Exception {
        System.out.println("Session Created with " + session.getRemoteAddress() + " at " + this.format.format(new Date()));
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        System.out.println("Timing out session for " + session.getRemoteAddress() + " at " + this.format.format(new Date()));
        session.close();
    }
}

