/*
 * Decompiled with CFR 0.152.
 */
package serversocketminagt06;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import serversocketminagt06.DBConfiguration;

public class ConnectionManager {
    public static DataSource ds = null;
    private static GenericObjectPool _pool = null;

    public ConnectionManager(DBConfiguration config) {
        try {
            this.connectToDB(config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void connectToDB(DBConfiguration config) {
        try {
            Class.forName(config.getDbDriverName()).newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Saibaba Trying to connect to database...");
        try {
            ds = ConnectionManager.setupDataSource(config.getDbURI(), config.getDbUser(), config.getDbPassword(), config.getDbPoolMinSize(), config.getDbPoolMaxSize());
            System.out.println("Connection attempt to database succeeded.");
        }
        catch (Exception e) {
            System.out.println("Error when attempting to connect to DB " + e.getMessage());
        }
    }

    public static DataSource setupDataSource(String connectURI, String username, String password, int minIdle, int maxActive) throws Exception {
        GenericObjectPool connectionPool = new GenericObjectPool(null);
        connectionPool.setMinIdle(minIdle);
        connectionPool.setMaxActive(maxActive);
        GenericObjectPool _tmp = connectionPool;
        connectionPool.setWhenExhaustedAction((byte)2);
        _pool = connectionPool;
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectURI, username, password);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
        PoolingDataSource dataSource = new PoolingDataSource((ObjectPool)connectionPool);
        return dataSource;
    }

    public static String printDriverStats() {
        GenericObjectPool connectionPool = _pool;
        System.out.println("NumActive: " + connectionPool.getNumActive());
        System.out.println("NumIdle: " + connectionPool.getNumIdle());
        return " Number of active connections are " + connectionPool.getNumActive() + " and Number of idle connections are " + connectionPool.getNumIdle();
    }

    public int getNumLockedProcesses() {
        int num_locked_connections = 0;
        Connection con = null;
        PreparedStatement p_stmt = null;
        ResultSet rs = null;
        try {
            con = ds.getConnection();
            p_stmt = con.prepareStatement("SHOW PROCESSLIST");
            rs = p_stmt.executeQuery();
            while (rs.next()) {
                if (rs.getString("State") == null || !rs.getString("State").equals("Locked")) continue;
                ++num_locked_connections;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                rs.close();
                p_stmt.close();
                con.close();
            }
            catch (SQLException ex) {
                System.out.println(ex.toString());
            }
            try {
                rs.close();
                p_stmt.close();
                con.close();
            }
            catch (SQLException ex) {
                System.out.println(ex.toString());
            }
        }
        return num_locked_connections;
    }

    protected void finalize() {
        System.out.println("Finalizing ConnectionManager");
        try {
            super.finalize();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

