/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CommandThread
extends Thread {
    public static String SERVERURL = "http://localhost/telnet/java.php";
    public static ServerSocket serverSocket;
    public static int COMMAND_PORT;
    protected ExecutorService threadPool = Executors.newCachedThreadPool();
    public static int countConnections;
    private List<Future<CommandThreadSingle>> tasks;
    private static int threadNo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        while (true) {
            try {
                try {
                    serverSocket = new ServerSocket(COMMAND_PORT, 2000);
                    this.tasks = new CopyOnWriteArrayList<Future<CommandThreadSingle>>();
                    System.out.println("Opening Port " + COMMAND_PORT);
                    while (true) {
                        Socket client = serverSocket.accept();
                        ++countConnections;
                        Future future = this.threadPool.submit(new CommandThreadSingle(client, ++threadNo));
                        this.tasks.add(future);
                    }
                }
                catch (RuntimeException e) {
                    CommandThreadSingle.appendLog("Error CT:" + e.getMessage(), "ErrorLog.txt");
                    try {
                        serverSocket.close();
                        CommandThreadSingle.appendLog("CT " + COMMAND_PORT + " Closed", "ErrorLog.txt");
                        continue;
                    }
                    catch (Exception e2) {
                        System.out.println("Could not close socket Server:" + e2.getMessage());
                        System.exit(0);
                        break;
                    }
                }
                catch (Exception e) {
                    CommandThreadSingle.appendLog("Error CT:" + e.getMessage(), "ErrorLog.txt");
                    continue;
                }
                catch (Error e) {
                    CommandThreadSingle.appendLog("Error e CT:" + e.getMessage(), "ErrorLog.txt");
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        serverSocket.close();
                        CommandThreadSingle.appendLog("CT " + COMMAND_PORT + " Closed", "ErrorLog.txt");
                        continue;
                    }
                    catch (Exception e3) {
                        System.out.println("Could not close socket Server:" + e3.getMessage());
                        System.exit(0);
                        break;
                    }
                }
                {
                    finally {
                        try {
                            serverSocket.close();
                            CommandThreadSingle.appendLog("CT " + COMMAND_PORT + " Closed", "ErrorLog.txt");
                        }
                        catch (Exception e) {
                            System.out.println("Could not close socket Server:" + e.getMessage());
                            System.exit(0);
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                CommandThreadSingle.appendLog("CT Final loop Ex:" + e.getMessage(), "ErrorLog.txt");
                break;
            }
            catch (Error e) {
                CommandThreadSingle.appendLog("CT Final loop Er:" + e.getMessage(), "ErrorLog.txt");
                break;
            }
        }
    }

    public void sendDataCommand(String deviceId, String command) {
        boolean deviceIdFound = false;
        for (Future<CommandThreadSingle> future : this.tasks) {
            try {
                if (future.get().getDeviceId() == null || !future.get().getDeviceId().equals(deviceId)) continue;
                future.get().setDeviceCommand(command);
                deviceIdFound = true;
                break;
            }
            catch (Exception ex) {
                CommandThreadSingle.appendLog("ERROR sendDataCommand() " + ex, "cmd-response.txt");
            }
        }
        if (!deviceIdFound) {
            System.out.println("Device ID not found");
            CommandThreadSingle.appendLog("Device ID not found " + deviceId + " - " + command, "cmd-response.txt");
        }
    }

    public void viewDeviceCommand(String deviceId) {
        boolean deviceIdFound = false;
        for (Future<CommandThreadSingle> future : this.tasks) {
            try {
                if (!future.get().getDeviceId().equals(deviceId)) continue;
                deviceIdFound = true;
                break;
            }
            catch (Exception ex) {
                CommandThreadSingle.appendLog("ERROR viewDeviceCommand()" + ex, "cmd-response.txt");
            }
        }
        if (!deviceIdFound) {
            System.out.println("Device ID not found");
            CommandThreadSingle.appendLog("Device ID not found  - " + deviceId, "cmd-response.txt");
        } else {
            System.out.println("Device ID Exists");
            CommandThreadSingle.appendLog("Device ID Exists  - " + deviceId, "cmd-response.txt");
        }
    }

    public void viewDeviceCommand() {
        System.out.println("List of devices connected:");
        int count = 0;
        String data = "";
        if (this.tasks != null) {
            for (Future<CommandThreadSingle> future : this.tasks) {
                try {
                    String deviceid = future.get().getDeviceId();
                    if (deviceid != null && deviceid.length() > 0) {
                        System.out.println("ID:" + deviceid);
                        data = data + "Id: " + deviceid + "\n";
                        ++count;
                    }
                    if (count % 100 != 0) continue;
                    CommandThreadSingle.appendLog(data, "cmd-response.txt");
                    data = "";
                }
                catch (Exception ex) {
                    CommandThreadSingle.appendLog("Error viewDeviceCommand()  - " + ex, "cmd-response.txt");
                }
            }
            if (!data.equals("")) {
                CommandThreadSingle.appendLog(data, "cmd-response.txt");
                data = "";
            }
            CommandThreadSingle.appendLog("List of devices connected: " + count, "cmd-response.txt");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommandToDevice() {
        try {
            List<String> lines = TrackVehicleOnline.getLines();
            RandomAccessFile randomAccessFile = new RandomAccessFile(new File(System.getProperty("user.dir") + File.separator + "Command_Log_" + COMMAND_PORT + ".txt"), "rwd");
            FileChannel fileChannel = randomAccessFile.getChannel();
            fileChannel.truncate(0L);
            while (lines.size() != 0) {
                String readCommand = lines.get(0);
                if (readCommand.contains("Device_Id:") && readCommand.contains("Command:")) {
                    String data = readCommand.substring(readCommand.indexOf("Device_Id:"));
                    String currentCommand = data.substring(data.indexOf(" Command:") + 9);
                    data = data.substring(0, data.indexOf(" Command:"));
                    String currentId = data.substring(data.indexOf("Device_Id:") + 10);
                    if (this.tasks != null) {
                        boolean deviceConnectionExists = false;
                        for (Future<CommandThreadSingle> future : this.tasks) {
                            String deviceid = "";
                            OutputStream out = null;
                            try {
                                deviceid = future.get().getDeviceId();
                                if (deviceid == null || !deviceid.equals(currentId)) continue;
                                out = future.get().getOutputConnection();
                                out.write(currentCommand.getBytes());
                                CommandThreadSingle.appendLog("Command " + currentCommand + " sent to " + currentId, "cmd-response.txt");
                                deviceConnectionExists = true;
                            }
                            catch (Exception ex) {
                                CommandThreadSingle.appendLog("Error readAndSendData-IP:" + currentId + " Data:" + currentCommand + " Error:" + ex, "ErrorLog.txt");
                                deviceConnectionExists = false;
                            }
                            catch (Error ex) {
                                CommandThreadSingle.appendLog("Error readAndSendData-IP:" + currentId + " Data:" + currentCommand + " Error:" + ex, "ErrorLog.txt");
                                deviceConnectionExists = false;
                            }
                            finally {
                                if (out == null) continue;
                                try {
                                    out.close();
                                }
                                catch (Exception e) {}
                            }
                        }
                        if (!deviceConnectionExists) {
                            randomAccessFile.write((lines.get(0) + System.getProperty("line.separator")).getBytes());
                        }
                    } else {
                        randomAccessFile.write((lines.get(0) + System.getProperty("line.separator")).getBytes());
                    }
                    lines.remove(0);
                    continue;
                }
                lines.remove(0);
            }
            fileChannel.close();
            randomAccessFile.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void removeFinishedTasks() {
        if (this.tasks != null) {
            for (Future<CommandThreadSingle> future : this.tasks) {
                try {
                    String deviceid = future.get().getDeviceId();
                    if (deviceid == null || !deviceid.equals("")) continue;
                    this.tasks.remove(future);
                }
                catch (Exception ex) {
                    CommandThreadSingle.appendLog("Error removeFinishedTasks()  - " + ex, "ErrorLog.txt");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readCommandLogFile() {
        try {
            String readCommand;
            BufferedReader br = new BufferedReader(new FileReader(new File(System.getProperty("user.dir") + File.separator + "Command_Log_" + COMMAND_PORT + ".txt")));
            while ((readCommand = br.readLine()) != null) {
                if (!readCommand.contains("Device_Id:") || !readCommand.contains("Data:")) continue;
                String data = readCommand.substring(readCommand.indexOf("Device_Id:"));
                String receivedData = data.substring(data.indexOf(" Data:") + 6);
                data = data.substring(0, data.indexOf(" Data:"));
                String receivedIp = data.substring(data.indexOf("Device_Id:") + 10);
                for (Future<CommandThreadSingle> future : this.tasks) {
                    String deviceid = "";
                    try {
                        deviceid = future.get().getDeviceId();
                        if (deviceid == null || deviceid.equals(receivedIp)) continue;
                        OutputStream out = future.get().getOutputConnection();
                        out.write(receivedData.getBytes());
                    }
                    catch (Exception ex) {
                        CommandThreadSingle.appendLog("Error readAndSendData-IP:" + receivedIp + " Data:" + receivedData + " Error:" + ex, "ErrorLog.txt");
                    }
                    catch (Error ex) {
                        CommandThreadSingle.appendLog("Error readAndSendData-IP:" + receivedIp + " Data:" + receivedData + " Error:" + ex, "ErrorLog.txt");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            TrackVehicleOnline.isReadingFile = false;
        }
    }

    static {
        COMMAND_PORT = 6060;
        countConnections = 0;
        threadNo = 0;
    }
}

