function GoogleMap() {
}

(function () { // strict mode wrapper
	'use strict';
	GoogleMap.prototype = {
		
		id: '#pageMaps',
		map: null,
		markers: null,
		markers_stop: null,
		marker_anchor: null,
		infowindow :new google.maps.InfoWindow({}),
		
		initMap: function(divmap_obj) {
			var self = this;
			if (this.map == null) 
			{
				this.markers = [];
				this.markers_stop = [];
				this.map = new google.maps.Map(divmap_obj, {
				    zoom: 9,
				    center: new google.maps.LatLng(28.6139, 77.2090),
				    disableDefaultUI: false,
					overviewMapControl:true,
				    mapTypeId: google.maps.MapTypeId.ROADMAP
					
				});
				
				google.maps.event.trigger(this.map, 'resize');
				google.maps.event.addListener(this.map, 'click', 
					function(event) 
					{
					}
				);
			}
			
		},
		
		addMarker: function(info, index, action)
		{
			
			
			var self = this;
			if(this.map != null && action == true)
			{
				var pos = new google.maps.LatLng(info.f_lat, info.f_lon);				
				var marker = new MarkerWithLabel({
				  	 	position: pos,
				    	        map: this.map,
						icon: info.f_icon,
					  	info: info,
					  	index: index,
				   		labelContent: info.f_asset_name,
				   		labelAnchor: new google.maps.Point(22, 10),
				   		labelClass: "labels" // the CSS class for the label
				 });
				
				google.maps.event.addListener(marker, 'click', (function(event) {

				var unix_now = new Date().getTime()/1000;
				var ago = marker.info.data_received;
                                var date_time = marker.info.f_datetime;
                                var network_timeout = marker.info.network_timeout ;
                                var speed = "Speed: " + marker.info.f_speed +" km/h, ";
                                var ignition = "Ignition: "+ marker.info.ignition + ", ";
                                var ACC = "AC Status: "+ marker.info.ACC;
                                var minutes = marker.info.beforeTime;
				console.log(marker.info.f_asset_name+minutes+network_timeout+marker.info.f_speed+marker.info.ignition);
                                var vehicleStatus = "";
                                if(minutes < network_timeout &&  marker.info.f_speed > 10){
                                    vehicleStatus = "Running";
                                }else if(minutes < network_timeout &&  marker.info.f_speed <= 0 && marker.info.ignition == 'OFF'  ){
                                    vehicleStatus = "Parked";
                                }else if(minutes < network_timeout &&  marker.info.f_speed <= 10 && marker.info.ignition == 'ON'){
                                    vehicleStatus = "Idle";
                                }else if(minutes > network_timeout && minutes < (network_timeout+36000)){
                                    vehicleStatus = "Out of network";
                                }else{
                                    vehicleStatus = "Out of network";
		
                                }
                               
                                
				var tb = '<div style="overflow: hidden;text-align:left;"> '+'<b>'+marker.info.f_asset_name+" ("+marker.info.f_imei+")"+'</b> <br />'+ago+" ago, "+date_time+'<br />'+speed+" "+ignition+" "+ACC+'<br />'+"Address: "+marker.info.f_address+'<br />'+"Status: "+vehicleStatus+'</td>'+'</div>';					
					self.infowindow.setContent(tb);
    			
					self.infowindow.open(self.map);
					self.infowindow.setPosition(marker.getPosition());
				
				})); 
				this.markers.push(marker);
			}
			else if(this.map != null)
			{
				var i =0;
				for(i = 0; i< this.markers.length; i++)
				{
					if(this.markers[i].index == index)
					{
						this.markers[i].setMap(null);
						this.markers.splice(i,1);	
					}
				}
			}
		},
		removeAllMarker: function()
		{
			var i =0;
			for(i = 0; i< this.markers.length; i++)
			{
				 this.markers[i].setMap(null);
			}
			this.markers = [];
		},
		setCenterPos: function(lat, lng, zoom)
		{
			var pos = new google.maps.LatLng(lat,lng);
			this.map.setCenter(pos);
			if(zoom <15 )
				this.map.setZoom(zoom);	
			else
				this.map.setZoom(15);	
		},
		//-----------------------this is for tracking--------------------------------------
		
		createPathObj_fromPoints:function(g_currentVehicleInfo)
		{
			var path = new Array();
			var j = 0;
			for(j = 0 ; j < g_currentVehicleInfo.length; j++)
			{
				path[j] = new google.maps.LatLng(g_currentVehicleInfo[j].f_lat, g_currentVehicleInfo[j].f_lon); 	
			}
			
			return path;
		},
		
		drawPolyLine: function()
		{
			
			if(g_currentVehicleInfo.length <1)
				return;
				
			this.removePolyLine();
			this.removeMarker();
			
			{
				var self = this;
				var path = self.createPathObj_fromPoints(g_currentVehicleInfo);
				this.polyLineObj = new google.maps.Polyline({
					f_index: g_currentVehicleInfo[0].f_index,
					path: path,
					strokeColor: "#ff0000",
					strokeOpacity: 1,
					strokeWeight: 2,
					map: this.map,
				});
			}
			
			{
				this.setCenterViewPort(g_currentVehicleInfo[0].f_lat,g_currentVehicleInfo[0].f_lon);
			}
		},
		
		drawMarker: function(index)
		{
			if(index < g_currentVehicleInfo.length && g_currentVehicleInfo.length > 0)
			{
				
				this.removeMarker();
				var info = g_currentVehicleInfo[index];
                                var pos = new google.maps.LatLng(info.f_lat, info.f_lon);
				var icon = new google.maps.MarkerImage(info.strImg, null, null, new google.maps.Point(15, 15), google.maps.Size(30, 30));
                                this.marker = new google.maps.Marker({
				  	 	position: pos,
                                                map: this.map,
						icon: icon,
					  	index: index,
						anchorPoint: new google.maps.Point(-30, -30)
				});
				this.setCenterViewPort(info.f_lat, info.f_lon);
			}
		},
		
		removeMarker: function()
		{
			if(this.marker != null)
			{
				this.marker.setMap(null);
				this.marker = null;	
			}	
		},
		removePolyLine: function()
		{
			if(this.polyLineObj != null)
			{
				this.polyLineObj.setMap(null);
				this.polyLineObj = null;
			}
		},
		setCenterViewPort: function(lat, lon)
		{
			var pos = new google.maps.LatLng(lat, lon);
			this.map.setCenter(pos);
			this.map.setZoom(15);
		},
		//---------------------------------this for stop marker------------------------
		addMarkerStop: function(info)
		{
			var self = this;
			if(this.map != null)
			{
				var pos = new google.maps.LatLng(info.f_lat, info.f_lon);				
				var marker = new MarkerWithLabel({
				  	 	position: pos,
				    	map: this.map,
						icon: "media/icon/icon-stop.png",
					  	info: info				   		
				 });
				
				google.maps.event.addListener(marker, 'click', (function(event) {
				var unix_now = new Date().getTime()/1000;
				var ago = Math.floor((unix_now-marker.info.f_datetime)/60);
				var tb = '<div style="overflow: hidden; width:350px;"> '+
					'<b>'+marker.info.f_imei+'</b> <br />'+
					'<table border="0">'+				
					'<tr>'+
					'<td style="width:200px;">Position time: '+ago+'m ago</td>'+
					'<td>'+(moment(marker.info.f_datetime*1000)).format('DD-MM-YYYY HH:mm:ss')+'</td>'+
					'</tr>'+
					'<tr>'+
					'<td colspan="2">'+marker.info.f_address+'</td>'+
					
					'</tr>'+
					'</table>'+					
					'</div>';
									self.infowindow.setContent(tb);
    			
					self.infowindow.open(self.map);
					self.infowindow.setPosition(marker.getPosition());
				
				})); 
				this.markers_stop.push(marker);
			}
			
		},
		showMarkersStop: function(){
			for (var i = 0; i < this.markers_stop.length; i++) {
				this.markers_stop[i].setMap(this.map);
			  }

		},
		hiddenMarkersStop: function(){
			for (var i = 0; i < this.markers_stop.length; i++) {
				this.markers_stop[i].setMap(null);
			  }
		},
		clearMarkersStop: function(){
			this.hiddenMarkersStop();
			this.markers_stop = [];
		},
		showAnchor: function(info){
			var self = this;
			if(this.map != null)
			{
				
				
				var pos = new google.maps.LatLng(info.f_lat, info.f_lon);
				if(self.marker_anchor != null) self.marker_anchor.setMap(null);
				self.marker_anchor = new MarkerWithLabel({
				  	 	position: pos,
				    	map: this.map,
				    	icon:info.f_icon,
					  	info: info				   		
				 });
				
				var unix_now = new Date().getTime()/1000;
				var ago = Math.floor((unix_now-self.marker_anchor.info.f_datetime)/60);
				var tb = '<div style="overflow: hidden; width:350px;"> '+
					'<b>'+self.marker_anchor.info.f_imei+'</b> <br />'+
					'<table border="0">'+				
					'<tr>'+
					'<td style="width:200px;">Position time: '+ago+'m ago</td>'+
					'<td>'+(moment(self.marker_anchor.info.f_datetime*1000)).format('DD-MM-YYYY HH:mm:ss')+'</td>'+
					'</tr>'+
					'<tr>'+
					'<td colspan="2">'+self.marker_anchor.info.f_address+'</td>'+
					
					'</tr>'+
					'</table>'+					
					'</div>';
					self.infowindow.setContent(tb);
    			
					self.infowindow.open(self.map);
					self.infowindow.setPosition(pos);
				
		}
	},
	showMarker: function(info)
	{
		var self = this;
		
		if(info == null) return;
		if(this.map != null)
		{
			
			var pos = new google.maps.LatLng(info.f_lat, info.f_lon);				
			var marker = new MarkerWithLabel({
			  	 	position: pos,
			    	map: this.map,
					icon: info.f_icon,
				  	info: info				   		
			 });
			
			google.maps.event.addListener(marker, 'click', (function(event) {
			var unix_now = new Date().getTime()/1000;
			var ago = Math.floor((unix_now-marker.info.f_datetime)/60);
			var tb = '<div style="overflow: hidden; width:350px;"> '+
				'<b>'+marker.info.f_imei+'</b> <br />'+
				'<table border="0">'+				
				'<tr>'+
				'<td style="width:200px;">Position time: '+ago+'m ago</td>'+
				'<td>'+(moment(marker.info.f_datetime*1000)).format('DD-MM-YYYY HH:mm:ss')+'</td>'+
				'</tr>'+
				'<tr>'+
				'<td colspan="2">'+marker.info.f_address+'</td>'+
				
				'</tr>'+
				'</table>'+					
				'</div>';
								self.infowindow.setContent(tb);
			
				self.infowindow.open(self.map);
				self.infowindow.setPosition(marker.getPosition());
			
			})); 
			self.setCenterViewPort(info.f_lat, info.f_lon);
		}
		
	},
}
	}());