<?php 
    $this->load->view('common/header');
    $this->load->view('common/left_panel');
?>

<!-- START BREADCRUMB -->
<?= $breadcrumbs ?>
<!-- END BREADCRUMB -->

<!-- PAGE CONTENT WRAPPER -->
<!-- START DEFAULT DATATABLE -->
<div class="page-content-wrap">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title"><strong><?php echo $heading; ?></strong></h3>
                    <h3 class="panel-title"><span class="msghide"><?= $this->session->userdata('message') <> '' ? $this->session->userdata('message') : ''; ?></span></h3>
                    <h3><span id="success_zone_entry"></span></h3>
                    <ul class="panel-controls">
                        <li><a href="#" data-toggle="modal" data-target="#myModal"><span class="fa fa-plus"></span></a></li>
                    </ul>
                </div>
                <div class="panel-body">
                    <table class="table table-bordered table-striped table-actions example_datatable table-condensed">
                        <thead>
                            <tr>
                                <th>Sr No.</th>
                                <th>City</th>      
                                <th>Zone Name</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END DEFAULT DATATABLE -->

<script type="text/javascript">
    var url = "<?= $ajax_manage_page; ?>";
    var actioncolumn = "<?= $actioncolumn; ?>";
</script>

<div class="modal inmodal" id="checkStatus" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content animated bounceInRight">
            <form method="post" action="<?= $changeAction ?>">
                <div class="modal-body" style="height: 100px;padding-top: 10%">
                    <center>
                        <input type="hidden" name="id" id="statusId" style="display: none;">
                        <span style="font-size: 16px">Are you sure to change the status?</span>
                    </center>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary btn-sm">Ok</button>
                    <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="deleteData" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <form method="post" action="<?= $deleteAction ?>">
                <div class="modal-body" style="height: 120px;padding-top: 3%">
                    <center>
                        <input type="hidden" name="id" id="deleteId" style="display: none;">
                        <span style="font-size: 16px">
                            If you want to delete this record,all associated records will be deleted permanently from the Database.
                            <br>Are you sure? 
                        </span>
                    </center>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary btn-sm">Ok</button>
                    <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="myModal" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><strong>Add Zone </strong><span id="successEntry" style="color:green"></span></h4>
            </div>
            <div class="modal-body">
                <form method="post">
                   
                    <label>Zone Name:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="zone_name_err" style="color:red"></span></label>
                    <input type="text" name="zone_name" id="zone_name" value="" class="form-control" placeholder="Zone Name" size="35" />


                     <label for="text">City<span style="color:red">*</span>&nbsp;<span id="nameError1" style="color:red"></span></label>
                    <div class="form-line">
                      <select class="form-control"  name="city_id" id="city_id">
                       <option value="">--Select City--</option>
                       <?php
                       foreach ($cities as $row_data) 
                       {
                        ?>
                        <option value="<?php echo $row_data->id; ?>"><?php echo $row_data->city_name; ?> </option>
                      <?php } ?>
                    </select>
                    
                  </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-round btn-success" onclick="saveData()">Submit</button>
                <button type="button" class="btn btn-round btn-danger" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="myModaledit" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><strong>Edit Zone </strong><span id="successEditEntry" style="color:green"></span></h4>
            </div>
            <div class="modal-body" id="getEditForm">
                <form method="post">
                    <label>Zone Name:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="edit_zone_name_err" style="color:red"></span></label>
                    <input type="text" name="zone_name" id="edit_zone_name" value="" class="form-control" placeholder="Zone name" size="35" />


                </form>
            </div>
            <div class="modal-footer">
                <input type="hidden" name="id" id="update_id">
                <button type="button" class="btn btn-round btn-success" onclick="updateData()">Submit</button>
                <button type="button" class="btn btn-round btn-danger" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function checkStatus(id) {
        $("#statusId").val(id);
        $("#deleteId").val(id);
    }

    $(document).ready(function() {
        $(".preloader").show();
    })

</script>

<?php $this->load->view('common/footer');?>

<script type="text/javascript">
    function saveData() {
         var city_id = $("#city_id").val();
        var zone_name = $("#zone_name").val().trim();
        var zone_name_pattern = /^[a-zA-Z -]+$/;

      

        if(zone_name == "") {
            $("#zone_name_err").fadeIn().html("Please enter zone name");
            setTimeout(function() {
                $("#zone_name_err").fadeOut();
            }, 4000);
            $("#zone_name").focus();
            return false;
        } else if(!zone_name_pattern.test(zone_name)) {
            $("#zone_name_err").fadeIn().html("Name can have only alphabets (@,&,*,$,#,! are not allowed)");
            setTimeout(function() {
                $("#zone_name_err").fadeOut();
            }, 4000);
            $("#zone_name_err").focus();
            return false;
        }

          if($.trim(city_id) == "")
      {
        $("#nameError1").fadeIn().html("Please select city");
        setTimeout(function(){$("#nameError1").fadeOut();},2000);
        $("#city_id").focus();
        return false;
      }

        var datastring = "zone_name=" + zone_name+"&city_id="+city_id;
        $.ajax({
            type: "post",
            url: "<?= $add_action; ?>",
            data: datastring,
            success: function(response) {
                if(response == 1) {
                    $("#zone_name_err").fadeIn().html("Zone name already exist");
                    setTimeout(function() {
                        $("#zone_name_err").fadeOut();
                    }, 8000);
                } else {
                    $(".close").click();
                    $("#success_zone_entry").fadeIn().html("<span class='label label-success'> Zone has been added successfully</span>");
                    setTimeout(function() {
                        $("#success_zone_entry").fadeOut();
                    }, 8000);
                    $("#myModal").modal("hide");
                    table.draw();
                }
            }
        });
    }
</script>

<script type="text/javascript">
    function getEditValue(rowid) {
        $("#update_id").val(rowid);
        $.ajax({
            type: "POST",
            url: "<?= site_url('Zones/getUpdateName'); ?>",
            data: {
                id: rowid
            },
            cache: false,
            success: function(result) {
                 $("#getEditForm").html(result);
                /*var obj = $.parseJSON(result);
                var zone_name = obj.zone_name;
                //alert(result);return false;
                $("#edit_zone_name").val(zone_name);*/
            }
        });
    }

    function updateData() 
    {   
        var city_id = $("#edit_city_id").val(); 
        var zone_name = $("#edit_zone_name").val().trim();
        var update_id = $("#update_id").val();
        var zone_name_pattern = /^[a-zA-Z -]+$/;

        if($.trim(city_id) == "")
        {
          $("#EdittitleError1").fadeIn().html("Please select city");
          setTimeout(function(){$("#EdittitleError").fadeOut();},2000);
          $("#edit_area_id").focus();
          return false;
        }
        if(zone_name == "") 
        {
            $("#edit_zone_name_err").fadeIn().html("Please enter zone name");
            setTimeout(function() {
                $("#edit_zone_name_err").fadeOut();
            }, 8000);
            $("#edit_zone_name").focus();
            return false;
        } else if (!zone_name_pattern.test(zone_name)) {
            $("#edit_zone_name_err").fadeIn().html("Name can have only alphabets (@,&,*,$,#,! are not allowed)");
            setTimeout(function() {
                $("#edit_zone_name_err").fadeOut();
            }, 4000);
            $("#edit_zone_name").focus();
            return false;
        }

        var datastring = "city_id="+city_id+"&zone_name=" + zone_name + "&id=" + update_id;

        $.ajax({
            type: "post",
            url: "<?= $update_action; ?>",
            data: datastring,
            success: function(response) {
                if (response == 1) {
                    $("#edit_zone_name_err").fadeIn().html("Zone name already exist");
                    setTimeout(function() {
                        $("#edit_zone_name_err").fadeOut();
                    }, 8000);
                } else {
                    $(".close").click();
                    $("#success_zone_entry").fadeIn().html("<span class='label label-success'> Zone has been updated successfully</span>");
                    setTimeout(function() {
                        $("#success_zone_entry").fadeOut();
                    }, 4000);
                    $("#myModaledit").modal("hide");
                    table.draw();
                }
            }
        });
    }

</script>
