<?php $this->load->view('common/header'); ?>
<?php $this->load->view('common/left_panel'); ?>
<?= $breadcrumbs; ?>
<div class="page-content-wrap">
    <div class="row">
        <div class="col-md-12">
            <form class="form-horizontal" method="post" action="<?= $action; ?>" enctype="multipart/form-data">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title"><strong><?= $heading; ?></strong></h3>
                        <ul class="panel-controls">
                            <li><a href="<?= $cancelbtn;?>"><span class="fa fa-arrow-left"></span></a></li>
                        </ul>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="panel-body">
                                  <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="col-md-12">Country <span class="text-danger">*</span><span class="text-danger" id="err_country_id"></span><span class="text-danger errmsg"><?= form_error('country_id'); ?></span></label>
                                                <div class="col-md-10">
                                                <select class="form-control" name="country_id" id="country_id" onchange="get_state_by_country(this.value)">
                                                        <option value="">Select Country</option>
                                                        <?php foreach($countries as $country){?>
                                                        <option value="<?= $country->id; ?>" <?php if($country->id==$country_id)echo "selected"; ?>><?= $country->country_name; ?></option>
                                                        <?php } ?>
                                                  </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="col-md-12">State <span class="text-danger">*</span><span class="text-danger" id="err_state_id"></span><span class="text-danger errmsg"><?= form_error('state_id'); ?></span></label>
                                                <div class="col-md-10">
                                                    <select class="form-control" name="state_id" id="state_id" onchange="get_district_by_state(this.value)">
                                                        <option value="">Select State</option>
                                                        <?php if($button=='Update') {  foreach ($states as $state) { ?>
                                                        <option value="<?= $state->id; ?>" <?php if($state->id==$state_id)echo "selected";; ?>><?= $state->state_name; ?></option>
                                                        <?php } } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="col-md-12">District <span class="text-danger">*</span><span class="text-danger" id="err_district_id"></span><span class="text-danger errmsg"><?= form_error('district_id'); ?></span></label>
                                                <div class="col-md-10">
                                                    <select class="form-control" name="district_id" id="district_id" onchange="get_city_by_district(this.value)">
                                                        <option value="">Select District</option>
                                                        <?php if($button=='Update') {  foreach ($districts as $district) { ?>
                                                        <option value="<?= $district->id; ?>" <?php if($district->id==$district_id)echo "selected";; ?>><?= $district->district_name; ?></option>
                                                        <?php } } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="col-md-12">City <span class="text-danger">*</span><span class="text-danger" id="err_city_id"></span><span class="text-danger errmsg"><?= form_error('city_id'); ?></span></label>
                                                <div class="col-md-10">
                                                    <select class="form-control" name="city_id" id="city_id">
                                                        <option value="">Select City</option>
                                                        <?php if($button=='Update') {  foreach ($cities as $city) { ?>
                                                        <option value="<?= $city->id; ?>" <?php if($city->id==$city_id)echo "selected";; ?>><?= $city->city_name; ?></option>
                                                        <?php } } ?>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                    
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="col-md-12">Zone Name<span class="text-danger">*</span><span class="text-danger" id="err_zone_name"></span><span class="text-danger errmsg"><?= form_error('zone_name'); ?></span></label>
                                                <div class="col-md-10">
                                                    <input type="text" class="form-control" name="zone_name" id="zone_name" placeholder="Enter Zone" value="<?= $zone_name; ?>" />
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="col-md-12">Zone Name (Marathi)<span class="text-danger"></span><span class="text-danger" id=""></span><span class="text-danger errmsg"></span></label>
                                                <div class="col-md-10">
                                                    <input type="text" class="form-control" name="zone_name_marathi" id="zone_name_marathi" placeholder="Enter zone in marathi" value="<?= $zone_name_marathi; ?>" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                    
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="col-md-12">Zone Name (Hindi) <span class="text-danger"></span><span class="text-danger" id=""></span><span class="text-danger errmsg"></span></label>
                                                <div class="col-md-10">
                                                    <input type="text" class="form-control" name="zone_name_hindi" id="zone_name_hindi" placeholder="Enter zone in hindi" value="<?= $zone_name_hindi; ?>" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="id" value="<?= $id;?>">
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer">
                        <button class="btn btn-success" type="submit" id="submit" value="<?= $button;?>" onclick="return validation();"><?= $button;?></button>
                        <a href="<?= $cancelbtn ?>" class="btn btn-danger">Cancel</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $this->load->view('common/footer'); ?>

<script>
  function validation() {
    var country_id = $("#country_id").val().trim();
    //alert(country_id); return false;
    var state_id = $("#state_id").val().trim();
    var district_id = $("#district_id").val().trim();
    var city_id = $("#city_id").val().trim();
    var zone_name = $("#zone_name").val().trim(); 

    if(country_id=='' || country_id==null)
    {
      $("#err_country_id").fadeIn().html("Please select country").css('color', "red");
      setTimeout(function(){$("#err_country_id").fadeOut();},3000)
      $("#country_id").focus();
      return false;
    }

    if(state_id=='' || state_id==null)
    {
      $("#err_state_id").fadeIn().html("Please select state").css('color', "red");
      setTimeout(function(){$("#err_state_id").fadeOut();},3000)
      $("#state_id").focus();
      return false;
    }

     if(district_id=='' || district_id==null)
    {
      $("#err_district_id").fadeIn().html("Please select district").css('color', "red");
      setTimeout(function(){$("#err_district_id").fadeOut();},3000)
      $("#district_id").focus();
      return false;
    }

    if(city_id=='' || city_id==null)
    {
      $("#err_city_id").fadeIn().html("Please select city").css('color', "red");
      setTimeout(function(){$("#err_city_id").fadeOut();},3000)
      $("#city_id").focus();
      return false;
    }

    if(zone_name == '') 
    {
      $("#err_zone_name").fadeIn().html("Please enter zone name").css('color', "red");
      setTimeout(function() {
          $("#err_zone_name").fadeOut();
      }, 3000)
      $("#zone_name").focus();
      return false;
    }
  }

  function get_state_by_country(id) { 
    var datastring = "id="+id;
    $.ajax({
      type:"post",
      url:"<?php echo site_url('Zones/getState'); ?>",
      data:datastring,
      success:function(returndata) { 
        $('#state_id').html(returndata);
      }
    });
  }

  function get_district_by_state(id) { 
    var datastring = "id="+id;
    $.ajax({
      type:"post",
      url:"<?php echo site_url('Zones/getDistrict'); ?>",
      data:datastring,
      success:function(returndata) { 
        $('#district_id').html(returndata);
      }
    });
  } 

  function get_city_by_district(id) { 
    var datastring = "id="+id;
    $.ajax({
      type:"post",
      url:"<?php echo site_url('Zones/getCity'); ?>",
      data:datastring,
      success:function(returndata) { 
        $('#city_id').html(returndata);
      }
    });
  }
</script>

<script>
  
      setTimeout(function(){$(".errmsg").fadeOut();},3000)
</script>