<?php $this->load->view('common/header'); ?>
<?php $this->load->view('common/left_panel'); ?>
<?php echo $breadcrumbs; ?>

<div class="page-content-wrap">
  <div class="row">
    <div class="col-md-12">
      <form class="form-horizontal" method="post" action="<?php echo $action; ?>" enctype="multipart/form-data">
        <div class="panel panel-default">
          <div class="panel-heading">
            <h3 class="panel-title"><strong><?php echo $heading; ?></strong></h3>
            <ul class="panel-controls">
              <li><a href="<?= $cancelbtn;?>"><span class="fa fa-arrow-left"></span></a></li>
            </ul>
          </div>
             
          <div class="panel-body">   
            <div class="col-md-12">
              <div class="col-md-6">
                <div class="form-group">
                    <label class="col-md-12">Police Station <span class="text-danger">*</span><span class="text-danger" id="police_station_id_err"></span><span class="text-danger errmsg"><?= form_error('police_station_id'); ?></span></label>
                    <div class="col-md-10">
                        <select class="form-control" name="police_station_id" id="police_station_id">
                            <option value="">Select Police Station</option>
                            <?php foreach ($policeStations as $row) { ?>
                            <option value="<?= $row->id; ?>" <?php if($row->id==$police_station_id)echo "selected";; ?>><?= $row->name; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
            </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Vehicle Type <span style="color:red;">*</span><span id="vehicle_type_err"></span><span class="text-danger errmsg"><?php echo form_error('vehicle_type'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="vehicle_type" id="vehicle_type">
                      <option value="">Select Vehicle</option>
                      <option value="Two_wheeler"<?php if('Two_wheeler' == $vehicle_type) echo "selected";?>>Two wheeler</option>
                      <option value="Four_wheeler"<?php if('Four_wheeler' == $vehicle_type) echo "selected";?>>Four wheeler</option>
                    </select>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Vehicle Number<span style="color:red;">*</span><span id="vehicle_no_err"></span><span class="text-danger errmsg"><?php echo form_error('vehicle_no'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="vehicle_no" id="vehicle_no" placeholder="MH 00 AA 0000" value="<?php echo $vehicle_no; ?>" style="text-transform: uppercase;" />
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Vehicle Name<span style="color:red;">*</span><span id="vehicle_name_err"></span><span class="text-danger errmsg"><?php echo form_error('vehicle_name'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="vehicle_name" id="vehicle_name" placeholder="Vehicle name" value="<?php echo $vehicle_name; ?>" />
                  </div>
                </div>
              </div>
               <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Vehicle Image <span style="color:red;"></span><span id="error_image" style="color:red;"></span> </label>
                  <div class="col-md-10">
                    <input type="file" class="form-control" name="vehicle_image" id="vehicle_image" title="Browse file"/>
                    <span class="">Please select image type jpg,png,jpeg </span>
                    <?php if($button!='Create'){ if(!empty($vehicle_image)) { ?>
                    <br>
                    <img src="<?php echo base_url('uploads/vehicles/'.$vehicle_image); ?>" style="width:100px;">
                    <input type="hidden" name="old_image" value="<?php echo $vehicle_image; ?>">
                    <?php }  else { ?>
                    
                    <br> <br>
                    <img src="<?php echo base_url('uploads/vehicles/profile_default.png'); ?>" style="width:100px;">
                    
                    <?php } } ?>
                  </div>
                </div>
              </div>
              <input type="hidden" name="id" value="<?php echo $id;?>">
              <input type="hidden" name="button" id="button" value="<?php echo $button;?>">
            </div>
          </div>
          <div class="panel-footer">
            <button class="btn btn-success" type="submit" id="submit" value="<?= $button;?>" onclick="return validation();"><?= $button;?></button>
            <a href="<?= $cancelbtn ?>" class="btn btn-danger">Cancel</a>
          </div>
        </div>
      </form>
    </div>
  </div>                    
</div>
<?php $this->load->view('common/footer'); ?>

<script type="text/javascript">
  function validation() 
  {
    var vehicle_type = $("#vehicle_type").val().trim();  
    var vehicle_no = $("#vehicle_no").val().trim(); 
    var vehicle_name = $("#vehicle_name").val().trim();
    var vehicle_image = $("#vehicle_image").val().trim();
    var button = $("#button").val();
     var police_station_id = $("#police_station_id").val().trim();
    
    if(police_station_id=='' || police_station_id==null)
    {
      $("#police_station_id_err").fadeIn().html("Please select station name").css('color',"red");
      setTimeout(function(){$("#police_station_id_err").fadeOut("&nbsp");},3000)
      $("#police_station_id").focus();
      return false;
    }
    if(vehicle_type=='')
    {
      $("#vehicle_type_err").fadeIn().html("Please select vehicle type").css('color',"red");
      setTimeout(function(){$("#vehicle_type_err").fadeOut("&nbsp");},3000)
      $("#vehicle_type").focus();
      return false;
    } 

    if(vehicle_no=='')
    {
      $("#vehicle_no_err").fadeIn().html("Please enter vehicle no").css('color',"red");
      setTimeout(function(){$("#vehicle_no_err").fadeOut("&nbsp");},3000)
      $("#vehicle_no").focus();
      return false;
    }

    if(vehicle_name=='')
    {
      $("#vehicle_name_err").fadeIn().html("Please enter vehicle name").css('color',"red");
      setTimeout(function(){$("#vehicle_name_err").fadeOut("&nbsp");},3000)
      $("#vehicle_name").focus();
      return false;
    } 

    if(button == 'Create') {
      if (vehicle_image == '') {
          $("#vehicle_image_err").fadeIn().html("Please select image").css('color', "red");
          setTimeout(function(){$("#vehicle_image_err").fadeOut("&nbsp");},3000)
          $("#vehicle_image").focus();
          return false;
      }
    }

    var filetype = vehicle_image.split(".");
    ext = filetype[filetype.length-1];  
    if($.trim(vehicle_image)!="")
    {     
        if(!(ext=='pdf') && !(ext=='jpg')  && !(ext=='JPG') && !(ext=='jpeg') && !(ext=='JPEG') && !(ext=='png') && !(ext=='PNG'))
        {   
            $("#vehicle_image_err").fadeIn().html("Please upload image of type jpg,png,jpeg").css("color","red");
            setTimeout(function(){$("#vehicle_image_err").fadeOut("&nbsp");},3000)
            $("#vehicle_image").focus();
            return false;
        }
    }
  }  

  function alpha_number(event)
        {
            var x = event.which || event.keyCode;
            console.log(x);
            if ((x >= 48) && (x <= 57) || (x >= 65) && (x <= 90) || x == 8 | x == 9 || x == 13)
            {
                return;
            }
            else
            {
                event.preventDefault();
            }
        }
</script>

<script>
  setTimeout(function(){$(".errmsg").fadeOut("&nbsp");},3000)
</script>