<?php $this->load->view('common/header'); ?>
<?php $this->load->view('common/left_panel'); ?>
<?= $breadcrumbs ?>
<div class="page-content-wrap">
  <div class="row">
    <div class="col-md-12">
      <div class="panel panel-default">
        <div class="panel-heading">
          <h3 class="panel-title"><strong><?= $heading ?></strong></h3>
          <h3 class="panel-title"><span class="msghide"><?= $this->session->userdata('message') <> '' ? $this->session->userdata('message') : ''; ?></span></h3>
          <h3><span id="successDistrictEntry"></span></h3>
          <ul class="panel-controls">
            <li><a href="javascript:void(0)" title="Add District" data-toggle="modal" data-target="#myModal" ><span class="fa fa-plus"></span></a></li>
          </ul>  
        </div>
        <div class="panel-body ">
          <div class="table-responsive">
            <table class="table table-bordered table-striped table-actions example_datatable ">
              <thead>
                <tr>
                  <th>Sr No.</th>
                  <th>Country Name</th>
                  <th>State Name</th>
                  <th>District Name</th>
                  <th>Status</th>
                  <th>Action</th>
                </tr>
              </thead>
            </table>
          </div>
        </div>
      </div>                                                
    </div>
  </div>
</div>
<div class="modal fade" id="myModal" role="dialog">
  <div class="modal-dialog">     
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title"><strong>Add District </strong><span id="successEntry" style="color:green"></span></h4>
      </div>
      <div class="modal-body">
        <form id="districtForm">
          
        <div class="form-group">
          <label>Country Name: <span style="color:red">*</span>&nbsp;<span id="nameError1" style="color:red"></span></label>
          <div class="form-line">
            <select class="form-control"  name="country_id" id="country_id" onchange="get_state_by_country(this.value)">
              <option value="">--Select Country--</option>
              <?php
              foreach ($countries as $row_data) 
              {
                ?>
                <option value="<?php echo $row_data->id; ?>"><?php echo $row_data->country_name; ?> </option>
              <?php } ?>
            </select>

          </div>
          <br>
          <label>State Name: <span style="color:red">*</span>&nbsp;<span id="state_idError1" style="color:red"></span></label>
          <div class="form-line">
            <select class="form-control"  name="state_id" id="state_id">
              <option value="">--Select State--</option>

            </select>
          </div>
          <br>
          <div class="form-line">
            <label>District Name: <span style="color:red">*</span>&nbsp;<span id="district_nameError" style="color:red"></span></label>
            <input class="form-control"  type="text" name="district_name" id="district_name" placeholder="District Name" value="" size="35"/> &nbsp; 

          </div>

          <div class="form-line">
            <label>District Name (Marathi):</label>
            <input class="form-control"  type="text" name="district_name_marathi" id="district_name_marathi" placeholder="District name in marathi" value="" size="35"/> &nbsp; 

          </div>

          <div class="form-line">
            <label>District Name (Hindi):</label>
            <input class="form-control"  type="text" name="district_name_hindi" id="district_name_hindi" placeholder="District name in hindi" value="" size="35"/> &nbsp; 

          </div>
        </div> 
        </form>

      </div>

      <div class="modal-footer">
        <button type="button" class="btn btn-round btn-success" id="statusSubBtn" onclick="saveData()">Submit</button>
        <button type="button" class="btn btn-round btn-danger"  data-dismiss="modal">Cancel</button>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="myModaledit" role="dialog">
  <div class="modal-dialog">     
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title"><strong>Edit District </strong><span id="successEditEntry" style="color:green"></span></h4>
      </div>
      <form method="post">
        <div class="modal-body" id="getEditForm">

        </div>
      </form>
      <div class="modal-footer">
        <input type="hidden" name="id" id="updateId">
        <button type="button" class="btn btn-round btn-success"  id="statusEdiBtn"  onclick="updateData();">Submit</button>
        <button type="button" class="btn btn-round btn-danger" data-dismiss="modal">Cancel</button>
      </div>
    </div>
  </div>
</div>
<div class="modal inmodal" id="checkStatus" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm">
    <div class="modal-content animated bounceInRight">   
      <form method="post" action="<?= $changeAction; ?>">       
        <div class="modal-body" style="height: 100px;padding-top: 10%">
          <center>
            <input type="hidden" name="id" id="statusId" style="display: none;">
            <span style="font-size: 16px">Are you sure to change the status?</span>
          </center>
        </div>
        <div class="modal-footer" >
          <button type="submit" class="btn btn-primary btn-sm">Ok</button>
          <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
          </button>
        </div>
      </form>
    </div>
  </div>
</div>  
<div class="modal fade" id="deleteData" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
  <div class="modal-dialog modal-sm">
    <div class="modal-content">   
      <form method="post" action="<?= $deleteAction; ?>">       
        <div class="modal-body" style="height: 120px;padding-top: 3%">
          <center>
            <input type="hidden" name="id" id="deleteId" style="display: none;">
            <span style="font-size: 16px"> 
              If you want to delete this record,all associated records will be deleted permanently from the Database. 
              <br>Are you sure? </span>
            </center>
          </div>
          <div class="modal-footer">

            <button type="submit" class="btn btn-primary btn-sm">Ok</button>
            <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
  <script type="text/javascript">
    var url="<?= $ajax_manage_page; ?>";
    var actioncolumn="<?= $actioncolumn; ?>";
  </script>
  <?php $this->load->view('common/footer'); ?>
  <script type="text/javascript">
    function checkStatus(id)
    {
      $("#statusId").val(id);
      $("#deleteId").val(id);
    }

    $(document).ready(function(){
      $(".preloader").show();
    })
  </script>
  <script type="text/javascript">
    function saveData()
    {
      var country_id = $("#country_id").val().trim();
      var state_id = $("#state_id").val().trim();
      var district_name = $("#district_name").val().trim();
      var district_name_marathi = $("#district_name_marathi").val().trim();
      var district_name_hindi = $("#district_name_hindi").val().trim();
      var district_name1 = /^[a-zA-Z -]+$/;

      if(country_id == "")
      {
        $("#nameError1").fadeIn().html("Please select country");
        setTimeout(function(){$("#nameError1").fadeOut();},2000);
        $("#country_id").focus();
        return false;
      }
      if(state_id == "")
      {
        $("#state_idError1").fadeIn().html("Please select state");
        setTimeout(function(){$("#state_idError1").fadeOut();},2000);
        $("#state_id").focus();
        return false;
      }
      if(district_name == "")
      {
        $("#district_nameError").fadeIn().html("Please enter district");
        setTimeout(function(){$("#district_nameError").fadeOut();},2000);
        $("#district_name").focus();
        return false;
      }

      if(!district_name1.test(district_name)){
      //alert("Nickname can have only alphabets and numbers.");
      $("#district_nameError").fadeIn().html("District can have only alphabets (@,&,*,$,#,! are not allowed)");
      setTimeout(function(){$("#district_nameError").fadeOut();},4000);
      $("#district_name").focus();
      return false;
      }

var datastring  = "country_id="+country_id+"&state_id="+state_id+"&district_name="+district_name+"&district_name_marathi="+district_name_marathi+"&district_name_hindi="+district_name_hindi;

$.ajax({
  type : "post",
  url : "<?php echo site_url('Districts/addData'); ?>",
  data : datastring,
  success : function(response)
  {
//alert(response);return false;
if(response == 1)
{
  $("#district_nameError").fadeIn().html("District already exist");
  setTimeout(function(){$("#district_nameError").fadeOut();},2000);
}
else
{
  $(".close").click(); 
  $("#successDistrictEntry").fadeIn().html("<span class='label label-success'> Districts has been added successfully</span>");
  setTimeout(function(){$("#successDistrictEntry").fadeOut();},2000);
  $("#myModal").modal("hide"); 
  // $("#country_id").val(""); 
  // $("#state_id").val(""); 
  // $("#district_name").val(""); 
  $("#districtForm")[0].reset();
  
  table.draw();
}
}
});
}
</script>
<script type="text/javascript">

  function getEditvalue(rowid)
  {     
    $("#updateId").val(rowid);
//alert(rowid);
$.ajax({
  type: "POST",
  url: "<?= site_url('Districts/getUpdateName'); ?>",
  data: {id:rowid},
  cache: false,       
  success: function(result)
  { 

    $("#getEditForm").html(result);
  }             
});
}

function updateData()
{ 
  var country_id = $("#country_id1").val().trim();  
  var state_id = $("#state_id1").val().trim();  
  var district_name = $("#district_name1").val().trim(); 
  var district_name_marathi = $("#district_name_marathi_edit").val(); 
  var district_name_hindi = $("#district_name_hindi_edit").val(); 
  var updateId = $("#updateId").val().trim();
  var district_name2 = /^[a-zA-Z -]+$/;

  if(country_id == "")
  {
    $("#EdittitleError1").fadeIn().html("Please select country");
    setTimeout(function(){$("#EdittitleError1").fadeOut();},2000);
    $("#country_id1").focus();
    return false;
  }
  if(state_id == "")
  {
    $("#EdittitleError2").fadeIn().html("Please select state");
    setTimeout(function(){$("#EdittitleError2").fadeOut();},2000);
    $("#state_id1").focus();
    return false;
  }
  if(district_name == "")
  {
    $("#EdittitleError3").fadeIn().html("Please enter name");
    setTimeout(function(){$("#EdittitleError3").fadeOut();},2000);
    $("#district_name1").focus();
    return false;
  }

  if(!district_name2.test(district_name)){
    $("#EdittitleError").fadeIn().html("Name can have only alphabets (@,&,*,$,#,! are not allowed)");
    setTimeout(function(){$("#EdittitleError").fadeOut();},4000);
    $("#titlecity_name").focus();
    return false;
  }

  var datastring  = "country_id="+country_id+"&state_id="+state_id+"&id="+updateId+"&district_name="+district_name+"&district_name_marathi="+district_name_marathi+"&district_name_hindi="+district_name_hindi;

  $.ajax({
    type : "post",
    url : "<?php echo site_url('Districts/updateData') ?>",
    data : datastring,
    success : function(response)
    {   
      if(response == 1)
      {
        $("#EdittitleError3").fadeIn().html("District already exist");
        setTimeout(function(){$("#EdittitleError3").fadeOut();},2000);
      }
      else
      {
        $(".close").click(); 
        $("#successDistrictEntry").fadeIn().html("<span class='label label-success'> District has been Updated successfully</span>");
        setTimeout(function(){$("#successDistrictEntry").fadeOut();},2000);
        $("#myModaledit").modal("hide"); 
        table.draw();
      }
    }
  });
}
</script>
<script type="text/javascript">
  function get_state_by_country(id)
  { 
    var datastring = "id="+id;
    $.ajax({
      type:"post",
      url:"<?php echo site_url("Districts/get_state"); ?>",
      data:datastring,
      success:function(returndata)
      { 
        $('#state_id').html(returndata).selectpicker('refresh');
      }
    });
  }
</script>