<?php $this->load->view('common/header'); ?>
<?php $this->load->view('common/left_panel'); ?>
<?= $breadcrumbs; ?>
<div class="page-content-wrap">
    <div class="row">
        <div class="col-md-12">
            <form class="form-horizontal" method="post" action="<?= $action; ?>" enctype="multipart/form-data">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h3 class="panel-title"><strong><?= $heading; ?></strong></h3>
                        <ul class="panel-controls">
                            <li><a href="<?= $cancelbtn;?>"><span class="fa fa-arrow-left"></span></a></li>
                        </ul>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="col-md-12">Authority <span class="text-danger">*</span> <span class="text-danger" id="parent_id_err"></span><span class="text-danger errmsg"> <?= form_error('parent_id'); ?></span></label>
                                            <div class="col-md-10">
                                                <select class="form-control" name="parent_id" id="parent_id">
                                                    <option value="">Select Authority</option>
                                                    <?php foreach($parents as $row){?>
                                                    <option value="<?= $row->id; ?>" <?php if($row->id==$parent_id)echo "selected"; ?>><?= $row->title; ?></option>
                                                    <?php } ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="col-md-12">Department Name: <span class="text-danger">*</span><span class="text-danger" id="department_nameError"></span><span class="text-danger errmsg"><?= form_error('department_name'); ?></span></label>
                                            <div class="col-md-10">
                                                <input type="text" name="department_name" id="department_name" value="<?= $department_name; ?>" class="form-control lgn" placeholder="Department Name" size="35" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="col-md-12">Department Name (Marathi):</label>
                                            <div class="col-md-10">
                                                <input type="text" name="department_name_marathi" id="department_name_marathi" value="<?= $department_name_marathi; ?>" class="form-control lgn" placeholder="Department name in marathi" size="35" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="col-md-12">Department Name (Hindi):</label>
                                            <div class="col-md-10">
                                                <input type="text" name="department_name_hindi" id="department_name_hindi" value="<?= $department_name_hindi; ?>" class="form-control lgn" placeholder="Department name in hindi" size="35" />
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="col-md-12">Description</label>
                                            <div class="col-md-10">
                                                <textarea name="description" id="description" class="form-control ckeditor" placeholder="Enter Description"><?= $description; ?></textarea>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="col-md-12">Description Marathi</label>
                                            <div class="col-md-10">
                                                <textarea name="description_marathi" id="description_marathi" class="form-control ckeditor" placeholder="Enter Description Marathi"><?= $description_marathi; ?></textarea>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label class="col-md-12">Description Hindi</label>
                                            <div class="col-md-10">
                                                <textarea name="description_hindi" id="description_hindi" class="form-control ckeditor" placeholder="Enter Description Hindi"><?= $description_hindi; ?></textarea>
                                            </div>
                                        </div>

                                    </div>

                                </div>
                            </div>
                            <input type="hidden" name="id" value="<?= $id;?>">
                        </div>
                    </div>
                    <div class="panel-footer">
                        <input type="hidden" name="" value="<?=$button?>" id="button">
                        <button class="btn btn-success" type="submit" id="submit" value="<?= $button;?>" onclick="return validation();"><?= $button;?></button>
                        <a href="<?= $cancelbtn ?>" class="btn btn-danger">Cancel</a>
                    </div>
                </div>
        </div>
        </form>
    </div>
</div>
</div>

<?php $this->load->view('common/footer'); ?>

<script src="<?php echo base_url('assets/ckeditor/ckeditor.js'); ?>" type="text/javascript"></script>

<script type="text/javascript">
    function validation() {
        var parent_id = $("#parent_id").val().trim();
        var department_name1 = /^[a-zA-Z -]+$/;
        var department_name = $("#department_name").val().trim();

        if (parent_id == '' || parent_id == null) {
            $("#parent_id_err").fadeIn().html("Please select authority").css('color', "red");
            setTimeout(function() {
                $("#parent_id_err").fadeOut();
            }, 3000)
            $("#parent_id").focus();
            return false;
        }

        if (department_name == '') {
            $("#department_nameError").fadeIn().html("Please enter department name").css('color', "red");
            setTimeout(function() {
                $("#department_nameError").fadeOut();
            }, 3000)
            $("#department_name").focus();
            return false;
        } else if (!department_name1.test(department_name)) {
            $("#department_nameError").fadeIn().html("Please Enter Valid Department Name").css('color', "red");
            setTimeout(function() {
                $("#department_nameError").fadeOut();
            }, 3000)
            $("#department_name").focus();
            return false;
        }

    }

</script>
<script>
    setTimeout(function() {
        $(".errmsg").fadeOut();
    }, 3000)

</script>
