<?php 
    $this->load->view('common/header');
    $this->load->view('common/left_panel');
?>

<!-- START BREADCRUMB -->
<?= $breadcrumbs ?>
<!-- END BREADCRUMB -->

<!-- PAGE CONTENT WRAPPER -->
<!-- START DEFAULT DATATABLE -->
<div class="page-content-wrap">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title"><strong><?php echo $heading; ?></strong></h3>
                    <h3 class="panel-title"><span class="msghide"><?= $this->session->userdata('message') <> '' ? $this->session->userdata('message') : ''; ?></span></h3>
                    <h3><span id="successCountryEntry"></span></h3>
                    <ul class="panel-controls">
                        <li><a data-target="#uploadData" style="cursor:pointer;color:black;" title="Upload Excel" data-backdrop="static" data-keyboard="false" data-toggle="modal"><span class="fa fa-file-excel-o"></span></a></li>
                        <li><a href="#" data-toggle="modal" data-target="#myModal"><span class="fa fa-plus"></span></a></li>
                    </ul>
                </div>
                <div class="panel-body">
                    <table class="table table-bordered table-striped table-actions example_datatable table-condensed">
                        <thead>
                            <tr>
                                <th>Sr no.</th>
                                <th>Article Title</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END DEFAULT DATATABLE -->

<script type="text/javascript">
    var url = "<?= $ajaxManagePage; ?>";
    var actioncolumn = "<?= $actioncolumn; ?>";
</script>

<div class="modal inmodal" id="checkStatus" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content animated bounceInRight">
            <form method="post" action="<?= $changeAction ?>">
                <div class="modal-body" style="height: 100px;padding-top: 10%">
                    <center>
                        <input type="hidden" name="id" id="statusId" style="display: none;">
                        <span style="font-size: 16px">Are you sure to change the status?</span>
                    </center>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary btn-sm">Ok</button>
                    <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="deleteData" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <form method="post" action="<?= $deleteAction ?>">
                <div class="modal-body" style="height: 120px;padding-top: 3%">
                    <center>
                        <input type="hidden" name="id" id="deleteId" style="display: none;">
                        <span style="font-size: 16px">
                            If you want to delete this record,all associated records will be deleted permanently from the Database.
                            <br>Are you sure? 
                        </span>
                    </center>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary btn-sm">Ok</button>
                    <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="myModal" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><strong>Add Article </strong><span id="successEntry" style="color:green"></span></h4>
            </div>
            <div class="modal-body">
                <form method="post">
                    <label>Title:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="titleError" style="color:red"></span></label>
                    <input type="text" name="title" id="title" value="" class="form-control" placeholder="Title" size="35" />
                    <br>
                    <label>Title (Marathi):<span style="color:red;"></span>&nbsp;&nbsp;&nbsp;<span id="" style="color:red"></span></label>

                    <input type="text" name="title_marathi" id="title_marathi" value="" class="form-control" placeholder="Title in marathi" size="35" />
                    <br>
                    <label>Title (Hindi):<span style="color:red;"></span>&nbsp;&nbsp;&nbsp;<span id="" style="color:red"></span></label>
                    <input type="text" name="title_hindi" id="title_hindi" value="" class="form-control" placeholder="Title in hindi" size="35" />
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-round btn-success" onclick="saveData()">Submit</button>
                <button type="button" class="btn btn-round btn-danger" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="myModaledit" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><strong>Edit Article</strong><span id="successEditEntry" style="color:green"></span></h4>
            </div>
            <div class="modal-body">
                <form method="post">
                    <label>Title:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="edittitleError" style="color:red"></span></label>
                    <input type="text" name="title" id="edittitle" value="" class="form-control" placeholder="Title" size="35" />
                    <br>
                    <label>Title (Marathi):&nbsp;&nbsp;&nbsp;<span id="" style="color:red"></span></label>

                    <input type="text" name="title_marathi_edit" id="title_marathi_edit" value="" class="form-control" placeholder="Title in marathi" size="35" />
                    <br>
                    <label>Title (Hindi):&nbsp;&nbsp;&nbsp;<span id="" style="color:red"></span></label>
                    <input type="text" name="title_hindi_edit" id="title_hindi_edit" value="" class="form-control" placeholder="Title in hindi" size="35" />
                </form>
            </div>
            <div class="modal-footer">
                <input type="hidden" name="id" id="updateId">
                <button type="button" class="btn btn-round btn-success" onclick="updateData()">Submit</button>
                <button type="button" class="btn btn-round btn-danger" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<!--IMport strart-->
<div class="modal inmodal" id="uploadData" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content animated bounceInRight">   
            <form method="post" action="<?= site_url('Constitution_article/import')?>" method="post" enctype="multipart/form-data" onsubmit="return checkXcel()">  
                <div class="modal-header">
                        <span style="font-size:20px">Upload Excel</span>

                    </div>     
                <div class="modal-body" style="padding-top: 3%"> 
                  <a download class="pull-left" href="<?php echo base_url(); ?>uploads/import_excel/constitution_article_sample.xlsx" style="font-size:10px">Download Sample Format</a>  <br>
                    <input type="file" name="excel_file" id="excel_file" class="form-control">
                        &nbsp;<span style="color:red" id="errorexcel_file"></span>&nbsp;
                </div>
                <div class="modal-footer">
                    <button type="button" id="dis_btn" class="btn btn-primary" onclick="return checkXcel();">Ok</button>
                    <button type="submit" id="btn_click" style="display:none" class="btn btn-primary">Ok</button>
                    <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<!--IMport strart-->

<script type="text/javascript">
    function checkStatus(id) {
        $("#statusId").val(id);
        $("#deleteId").val(id);
    }

    $(document).ready(function() {
        $(".preloader").show();
    })

</script>

<?php $this->load->view('common/footer');?>

<script type="text/javascript">
    function saveData() {
         var title = $("#title").val().trim();
         var title_marathi = $("#title_marathi").val().trim();
         var title_hindi = $("#title_hindi").val().trim();
       // var title1 = /^[a-zA-Z -]+$/;

        if(title == "") {
            $("#titleError").fadeIn().html("Please enter title");
            setTimeout(function() {
                $("#titleError").fadeOut();
            }, 3000);
            $("#title").focus();
            return false;
        } 

        // else if(!title1.test(title)) {
        //     $("#titleError").fadeIn().html("Name can have only alphabets (@,&,*,$,#,! are not allowed)");
        //     setTimeout(function() {
        //         $("#titleError").fadeOut();
        //     }, 3000);
        //     $("#title").focus();
        //     return false;
        // }

        var datastring = "title=" + title+"&title_marathi=" + title_marathi+"&title_hindi=" + title_hindi;
        $.ajax({
            type: "post",
            url: "<?= $addAction ?>",
            data: datastring,
            success: function(response) {
                if(response == 1) {
                    $("#titleError").fadeIn().html("Title name already exist");
                    setTimeout(function() {
                        $("#titleError").fadeOut();
                    }, 3000);
                } else {
                    $(".close").click();
                    $("#successCountryEntry").fadeIn().html("<span class='label label-success'> Title has been added successfully</span>");
                    setTimeout(function() {
                        $("#successCountryEntry").fadeOut();
                    }, 3000);
                    $("#myModal").modal("hide");
                    table.draw();
                }
            }
        });
    }
</script>

<script type="text/javascript">
    function getEditValue(rowid) {
        $("#updateId").val(rowid);
        $.ajax({
            type: "POST",
            url: "<?= site_url('Constitution_article/getUpdateName'); ?>",
            data: {
                id: rowid
            },
            cache: false,
            success: function(result) {
                var obj = $.parseJSON(result);
                var title = obj.title;
                var title_marathi = obj.title_marathi;
                var title_hindi = obj.title_hindi;
                //alert(result);return false;
                $("#edittitle").val(title);
                $("#title_marathi_edit").val(title_marathi);
                $("#title_hindi_edit").val(title_hindi);
            }
        });
    }

    function updateData() {
        var title = $("#edittitle").val().trim();
        var title_marathi = $("#title_marathi_edit").val().trim();
        var title_hindi = $("#title_hindi_edit").val().trim();
        var updateId = $("#updateId").val();
        var title1 = /^[a-zA-Z -]+$/;
    
            if(title == "") {
            $("#edittitleError").fadeIn().html("Please enter title");
            setTimeout(function() {
                $("#edittitleError").fadeOut();
            }, 3000);
            $("#edittitle").focus();
            return false;
        } 

        // else if (!title1.test(title)) {
        //     $("#edittitleError").fadeIn().html("Name can have only alphabets (@,&,*,$,#,! are not allowed)");
        //     setTimeout(function() {
        //         $("#edittitleError").fadeOut();
        //     }, 3000);
        //     $("#edittitle").focus();
        //     return false;
        // }

        var datastring = "title=" + title +"&title_marathi=" + title_marathi +"&title_hindi=" + title_hindi + "&id=" + updateId;

        $.ajax({
            type: "post",
            url: "<?= $updateAction; ?>",
            data: datastring,
            success: function(response) {
                if (response == 1) {
                    $("#edittitleError").fadeIn().html("Title already exist");
                    setTimeout(function() {
                        $("#edittitleError").fadeOut();
                    }, 3000);
                } else {
                    $(".close").click();
                    $("#successCountryEntry").fadeIn().html("<span class='label label-success'> Title has been updated successfully</span>");
                    setTimeout(function() {
                        $("#successCountryEntry").fadeOut();
                    }, 3000);
                    $("#myModaledit").modal("hide");
                    table.draw();
                }
            }
        });
    }

</script>
<script type="text/javascript">
function checkXcel() 
{
    var excel_file = $("#excel_file").val();
    if(excel_file=="")
    {
        $("#errorexcel_file").fadeIn().html("Please select excel file in xls or csv format");
        setTimeout(function(){$("#errorexcel_file").fadeOut();},5000);
        $("#excel_file").focus();
        return false;   
    }
    else
    {
        $("#dis_btn").attr("disabled", "disabled"); 
        $('#btn_click').click();
    }    
}

$("#excel_file").change(function() { 
   var val = $(this).val();
   
   switch(val.substring(val.lastIndexOf('.') + 1).toLowerCase()){
   case 'xls': case 'csv': case 'xlsx': 
   
   break;
   default:
   $(this).val('');
   $("#errorexcel_file").fadeIn().html("Upload file in xls or csv or xlsx format only");
          setTimeout(function(){$("#errorexcel_file").html("&nbsp;");},5000);
   break;
   }
   });
   
</script>