<?php $this->load->view('common/header'); ?>
<?php $this->load->view('common/left_panel'); ?>
<?php echo $breadcrumbs; ?>
<div class="page-content-wrap">
  <div class="row">
    <div class="col-md-12">
      <form class="form-horizontal" method="post" action="<?php echo $action; ?>" enctype="multipart/form-data">
        <div class="panel panel-default">
          <div class="panel-heading">
            <h3 class="panel-title"><strong><?php echo $heading; ?></strong></h3>
            <ul class="panel-controls">
              <li><a href="<?= $cancelbtn;?>"><span class="fa fa-arrow-left"></span></a></li>
            </ul>
          </div>
          <div class="panel-body">   
            <div class="col-md-12">
            <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">City <span style="color:red;">*</span><span id="city_id_err"></span><span style="color:red;"><?php echo form_error('city_id'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="city_id" id="city_id" onchange="get_zone_by_city(this.value)">
                      <option value="">Select City</option>
                      <?php foreach($cities as $city){?>
                        <option value="<?= $city->id; ?>" <?php if($city->id==$city_id)echo "selected";; ?>><?= $city->city_name; ?></option>
                      <?php } ?>
                    </select>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                  <div class="form-group">
                      <label class="col-md-12">Zone<span class="text-danger">*</span><span class="text-danger" id="zone_id_err"></span><span class="text-danger"><?= form_error('zone_id'); ?></span></label>
                      <div class="col-md-10">
                          <select class="form-control" name="zone_id" id="zone_id" onchange="get_area_by_zone(this.value)">
                              <option value="">Select Zone</option>
                              <?php foreach($zones as $row){?>
                              <option value="<?= $row->id; ?>" <?php if($row->id==$zone_id)echo "selected"; ?>><?= $row->zone_name ; ?></option>
                              <?php } ?>
                          </select>
                      </div>
                  </div>

              </div>

              <div class="col-md-6">
                  <div class="form-group">
                      <label class="col-md-12">Area <span class="text-danger">*</span><span class="text-danger" id="area_id_err"></span><span class="text-danger"><?= form_error('area_id'); ?></span></label>
                      <div class="col-md-10">
                          <select class="form-control" name="area_id" id="area_id" onchange="get_branch_by_area(this.value)">
                              <option value="">Select Area</option>
                              <?php foreach ($areas as $row) { ?>
                              <option value="<?= $row->id; ?>" <?php if($row->id==$area_id)echo "selected"; ?>><?= $row->area; ?></option>
                              <?php }  ?>
                          </select>
                      </div>
                  </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Branch <span class="text-danger">*</span><span class="text-danger" id="branch_id_err"></span><span class="text-danger errmsg"><?= form_error('branch_id'); ?></span></label>
                  <div class="col-md-10">
                    <select class="form-control" name="branch_id" id="branch_id">
                      <option value="">Select Branch</option>
                      <?php foreach($branches as $row){?>
                        <option value="<?= $row->id; ?>" <?php if($row->id==$branch_id)echo "selected"; ?>><?= $row->branch_name; ?></option>
                      <?php } ?>
                    </select>
                  </div> 
                </div>
              </div> 

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Corporate <span class="text-danger">*</span><span class="text-danger" id="corporate_id_err"></span><span class="text-danger errmsg"><?= form_error('corporate_id'); ?></span></label>
                  <div class="col-md-10">
                    <select class="form-control" name="corporate_id" id="corporate_id">
                      <option value="">Select Corporate</option>
                      <?php foreach($corporates as $row){?>
                        <option value="<?= $row->id; ?>" <?php if($row->id==$corporate_id)echo "selected"; ?>><?= $row->name; ?></option>
                      <?php } ?>
                    </select>

                  </div> 
                </div>
              </div>

              <input type="hidden" name="id" value="<?php echo $id;?>">
            </div>
          </div>
          <div class="panel-footer">
            <button class="btn btn-success" type="submit" id="submit" value="<?= $button;?>" onclick="return validation();"><?= $button;?></button>
            <a href="<?= $cancelbtn ?>"  class="btn btn-danger">Cancel</a>
          </div>
        </div>
      </form>
    </div>
  </div>                    
</div>
<?php $this->load->view('common/footer'); ?>

<script type="text/javascript">
  function validation()
  {
  
    
    var city_id = $("#city_id").val().trim();
    var zone_id = $("#zone_id").val().trim();
    var area_id = $("#area_id").val().trim(); 
    var branch_id = $("#branch_id").val().trim(); 
    var corporate_id = $("#corporate_id").val().trim(); 

    if(city_id=='' || city_id==null)
    {
      $("#city_id_err").fadeIn().html("Please select city").css('color',"red");
      setTimeout(function(){$("#city_id_err").fadeOut("&nbsp");},3000)
      $("#city_id").focus();
      return false;
    } 

    if(zone_id=='' || zone_id==null)
    {
      $("#zone_id_err").fadeIn().html("Please select zone").css('color',"red");
      setTimeout(function(){$("#zone_id_err").fadeOut("&nbsp");},3000)
      $("#zone_id").focus();
      return false;
    } 

      if(area_id=='' || area_id==null)
    {
      $("#area_id_err").fadeIn().html("Please select area").css('color',"red");
      setTimeout(function(){$("#area_id_err").fadeOut("&nbsp");},3000)
      $("#area_id").focus();
      return false;
    } 

    if(branch_id=='' || branch_id==null)
    {
      $("#branch_id_err").fadeIn().html("Please select branch").css('color',"red");
      setTimeout(function(){$("#branch_id_err").fadeOut("&nbsp");},3000)
      $("#branch_id").focus();
      return false;
    } 

    if(corporate_id=='' || corporate_id==null)
    {
      $("#corporate_id_err").fadeIn().html("Please select corporate").css('color',"red");
      setTimeout(function(){$("#corporate_id_err").fadeOut("&nbsp");},3000)
      $("#corporate_id").focus();
      return false;
    } 
        
  } 


    function get_zone_by_city(id) {
        //alert(id); return false;
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Complaints/getZone'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#zone_id').html(returndata);
            }
        });
    }

    function get_area_by_zone(id) {
        // alert(id); return false;
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Complaints/getArea'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#area_id').html(returndata);
            }
        });
    }

    function get_branch_by_area(id) {
        // alert(id); return false;
        get_corporate_by_area(id);
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Complaints/getBranch'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#branch_id').html(returndata);
            }
        });
    }

    function get_corporate_by_area(id) {
        // alert(id); return false;
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Complaints/getCorporate'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#corporate_id').html(returndata);
            }
        });
    }

  function only_number(event)
      {
        var x = event.which || event.keyCode;
        console.log(x);
        if((x >= 48 ) && (x <= 57 ) || x == 8 | x == 9 || x == 13 )
        {
          return;
        }else{
          event.preventDefault();
        }    
      }
</script>