<?php
if(empty($_SESSION[SESSION_NAME]['id']))
{
redirect('Welcome');
}
?>
<?php $this->load->view('common/header'); ?>
<!-- START X-NAVIGATION -->
<?php $this->load->view('common/left_panel'); ?>
<!-- START BREADCRUMB -->
<?= $breadcrumbs; ?>
<!-- END BREADCRUMB -->

<!-- PAGE CONTENT WRAPPER -->
<div class="page-content-wrap">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">                                
                  <h3 class="panel-title"><strong><?php echo $heading; ?></strong></h3>
                  
                  <ul class="panel-controls">
                    <li><a href="<?php echo site_url('Dashboard'); ?>"><span class="fa fa-arrow-left"></span></a></li>
                  </ul>

                </div>
                <div class="panel-body">
                    <?php $i=1; foreach($result as $row) { ?>
                    <div class="col-md-6">
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <div class="panel-title-box">
                                    <h3><?php echo $row->branch_name; ?></h3>
                                </div>
                            </div>
                            <div class="panel-body padding-0">
                                <div class="chart-holder" id="chart_<?php echo $i++; ?>" style="height: 200px;"></div>
                                <ul class='list-inline text-center'>
                                    <li class="list-inline-item"><span class="fa fa-square text-secondary" style="color: #777777;"></span> Total</li>
                                    <li class="list-inline-item"><span class="fa fa-square text-danger"></span> Pending</li>
                                    <li class="list-inline-item"><span class="fa fa-square text-info"></span> Approved</li>
                                    <li class="list-inline-item"><span class="fa fa-square text-success"></span> Resolved</li>
                                  
                                </ul>
                            </div>
                        </div>
                    </div>
                    <?php } ?>
                </div>    
            </div>
        </div>
    </div>
    
</div>
<?php $this->load->view('common/footer') ?>
<script type="text/javascript" src="<?=base_url(); ?>assets/js/plugins/morris/raphael-min.js"></script>
<script type="text/javascript" src="<?=base_url(); ?>assets/js/plugins/morris/morris.min.js"></script>
<script type="text/javascript" src="<?=base_url(); ?>assets/js/demo_dashboard.js"></script>

<script>
    $(document).ready(function() {
        <?php $i=1; foreach($result as $row) {
            $charts = array("y"=>$row->branch_name,"a"=>$row->total_complaints,"b"=>$row->Pending,"c"=>$row->Approved,"d"=>$row->Resolved);

          ?>

        Morris.Bar({
        element: 'chart_<?php echo $i; ?>',
        data:  [<?php echo json_encode($charts); ?>],
        xkey: 'y',
        ykeys: ['a','b','c','d'],
        labels: ['Total Complaints', 'Pending','Approved','Resolved'],
        barColors: ['#777777','#e04b4a','#1caf9a','#94b75c'],
        gridTextSize: '10px',
        hideHover: true,
        resize: true,
        gridLineColor: '#E5E5E5'
    });
    <?php $i++; } ?>
    });
</script>