<?php $this->load->view('common/header'); ?>
<?php $this->load->view('common/left_panel'); ?>
<?= $breadcrumbs; ?>
<div class="page-content-wrap">
  <div class="row">
    <div class="col-md-12">
      <form class="form-horizontal" method="post" action="<?= $action; ?>" enctype="multipart/form-data">
        <div class="panel panel-default">
          <div class="panel-heading">
            <h3 class="panel-title"><strong><?= $heading; ?></strong></h3>
            <ul class="panel-controls">
              <li><a href="<?= $cancelbtn;?>"><span class="fa fa-arrow-left"></span></a></li>
            </ul>
          </div>

          <div class="panel-body">   
            <div class="col-md-12">

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Name <span class="text-danger">*</span> <span class="text-danger" id="err_name"></span><span class="text-danger"> <?= form_error('name'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="name" id="name" placeholder="Enter name" value="<?= $name; ?>" />
                  </div>
                </div>
                <div class="form-group">
                  <label class="col-md-12">Email <span class="text-danger">*</span><span class="text-danger" id="err_email"></span><span class="text-danger"><?= form_error('email'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="email" id="email" placeholder="Enter email" value="<?= $email; ?>" />
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Mobile <span class="text-danger">*</span><span class="text-danger" id="err_mobile"></span><span class="text-danger"><?= form_error('mobile'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" name="mobile" id="mobile" class="form-control" placeholder="Enter mobile no" maxlength="10" value="<?= $mobile; ?>" onkeypress="only_number(event)"/>
                  </div> 
                </div>
                <div class="form-group">
                  <label class="col-md-12">Password <span class="text-danger">*</span><span class="text-danger" id="err_password"></span><span class="text-danger"><?= form_error('password'); ?></span></label>
                  <div class="col-md-10">
                    <input type="password" name="password" id="password" class="form-control" placeholder="Enter Password" value="<?= $password; ?>"/>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">DOB <span class="text-danger">*</span><span class="text-danger" id="err_dob"></span><span class="text-danger"><?= form_error('dob'); ?></span></label>
                  <div class="col-md-10">
                    <input type="date" name="dob" id="dob" class="form-control" value="<?= $dob; ?>"/>
                  </div> 
                </div>
                <div class="form-group">
                  <label class="col-md-12">State <span class="text-danger">*</span><span class="text-danger" id="err_state"></span><span class="text-danger"><?= form_error('state_id'); ?></span></label>
                  <div class="col-md-10">
                    <select class="form-control" name="state_id" id="state_id">
                      <option value="">Select State</option>
                      <?php if($button=='Update') {  foreach ($states as $state) { ?>
                        <option value="<?= $state->id; ?>" <?php if($state->id==$state_id)echo "selected";; ?>><?= $state->state_name; ?></option>
                      <?php } } ?>  
                    </select>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
              	<div class="form-group">
                  <label class="col-md-12">Country <span class="text-danger">*</span><span class="text-danger" id="err_country"></span><span class="text-danger"><?= form_error('country_id'); ?></span></label>
                  <div class="col-md-10">
                    <select class="form-control" name="country_id" id="country_id" onchange="get_state_by_country(this.value)">
                      <option value="">Select Country</option>
                      <?php foreach($countries as $country){?>
                        <option value="<?= $country->id; ?>" <?php if($country->id==$country_id)echo "selected";; ?>><?= $country->country_name; ?></option>
                      <?php } ?>
                    </select>
                  </div> 
                </div>
                
                <div class="form-group">
                  <label class="col-md-12">City <span class="text-danger">*</span><span class="text-danger" id="err_city"></span><span class="text-danger"><?= form_error('city'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" name="city" id="city" class="form-control" placeholder="Enter city"  value="<?= $city; ?>"/>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                
                <div class="form-group">
                  <label class="col-md-12">Address <span class="text-danger">*</span><span class="text-danger" id="err_address"></span><span class="text-danger"><?= form_error('address'); ?></span></label>
                  <div class="col-md-10">
                    <textarea name="address" id="address" class="form-control" placeholder="Enter address"><?= $address; ?></textarea>
                  </div> 
                </div>
                <div class="form-group">
                <label class="col-md-12">Image <span style="color:red;"></span><span id="error_image" style="color:red;"></span> </label>
                <div class="col-md-10">
                 <input type="file" class="form-control" name="image" id="image" title="Browse file"/>
                 <span class="">Please select image type jpg,png,jpeg </span>
                 <?php if($button!='Create'){ if(!empty($image)) {?>
                  <br>
                  <img src="<?php echo base_url('uploads/citizens/'.$image); ?>" style="width:100px;">
                  <input type="hidden" name="old_image" value="<?php echo $image; ?>">
                <?php } else { ?>
                  
                    <br> <br>
                  <img src="<?php echo base_url('uploads/citizens/profile_default.png'); ?>" style="width:100px;">
                  
                <?php } } ?>
              </div> 
            </div>
              </div>

              <div class="col-md-6">

                <div class="form-group">
                  <label class="col-md-12">Pincode <span class="text-danger">*</span><span class="text-danger" id="err_pincode"></span><span class="text-danger"><?= form_error('pincode'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" name="pincode" id="pincode" class="form-control" placeholder="Enter pincode" value="<?= $pincode; ?>" maxlength="6" onkeypress="only_number(event)"/>
                  </div> 
                </div> 
              </div>

              <input type="hidden" name="id" value="<?= $id;?>">
            </div>
          </div>

          <div class="panel-footer">
            <button class="btn btn-success" type="submit" id="submit" value="<?= $button;?>" onclick="return validation();"><?= $button;?></button>
            <a href="<?= $cancelbtn ?>"  class="btn btn-danger">Cancel</a>
          </div>
        </div>
      </form>
    </div>
  </div>                    
</div>
<?php $this->load->view('common/footer'); ?>

<script type="text/javascript">
  function validation() {
    var name = $("#name").val().trim(); 
    var pattern_name = /^[a-zA-Z ]{2,30}$/;
    var email = $('#email').val().trim(); 
    var pattern_email= /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/i;
    var mobile = $("#mobile").val().trim();
    var pattern_mobile = /^[0]?[789]\d{9}$/;
    var password = $("#password").val().trim();
    var dob = $("#dob").val().trim();
    var country_id = $("#country_id").val().trim();
    var state_id = $("#state_id").val().trim();
    var city = $("#city").val().trim();
    var address = $("#address").val().trim();
    //var gender = $("#gender").val().trim();
    var pincode = $("#pincode").val().trim();
    //var pattern_pincode = /^\d{5}$/;  

    if (name == '') 
    {
      $("#err_name").fadeIn().html("Please enter name").css('color', "red");
      setTimeout(function() {
          $("#err_name").fadeOut();
      }, 3000)
      $("#name").focus();
      return false;
    } else if (!pattern_name.test(name)) 
    {
      $("#err_name").fadeIn().html("Please enter valid name").css('color', "red");
      setTimeout(function() {
          $("#err_name").fadeOut();
      }, 3000)
      $("#name").focus();
      return false;
    } 

    if(email=='')
    {
      $("#err_email").fadeIn().html("Please enter email.").css('color', "red");
      setTimeout(function() {
        $("#err_email").fadeOut();
        }, 3000);
      $("#email").focus();
      return false;
    } else if(!pattern_email.test(email)){
      $("#err_email").fadeIn().html("Please enter valid email.");
      setTimeout(function() {
        $("#err_email").fadeOut();},3000);
      $("#email").focus();
      return false;
    }

    if(mobile=='')
    {
      $("#err_mobile").fadeIn().html("Please enter mobile no.");
      setTimeout(function(){$("#err_mobile").fadeOut();},3000)
      $("#mobile").focus();
      return false;
    } else if(!pattern_mobile.test(mobile)){
      $("#err_mobile").fadeIn().html("Please enter valid mobile no.");
      setTimeout(function(){$("#err_mobile").fadeOut();},3000);
      $("#mobile").focus();
      return false;
    }

    if(password=='')
    {
      $("#err_password").fadeIn().html("Please enter password");
      setTimeout(function(){$("#err_password").fadeOut();},3000)
      $("#password").focus();
      return false;
    }

    if(dob=='')
    {
      $("#err_dob").fadeIn().html("Please select date of birth");
      setTimeout(function(){$("#err_dob").fadeOut();},3000)
      $("#dob").focus();
      return false;
    }

    if(country_id=='' || country_id==null)
    {
      $("#err_country").fadeIn().html("Please select country");
      setTimeout(function(){$("#err_country").fadeOut();},3000)
      $("#country_id").focus();
      return false;
    }

    if(state_id=='' || state_id==null)
    {
      $("#err_state").fadeIn().html("Please select state");
      setTimeout(function(){$("#err_state").fadeOut();},3000)
      $("#state_id").focus();
      return false;
    }

    if(city=='')
    {
      $("#err_city").fadeIn().html("Please select city");
      setTimeout(function(){$("#err_city").fadeOut();},3000)
      $("#city").focus();
      return false;
    }

    if(address=='')
    {
      $("#err_address").fadeIn().html("Please enter address");
      setTimeout(function(){$("#err_address").fadeOut();},3000)
      $("#address").focus();
      return false;
    }

    if(pincode=='')
    {
      $("#err_pincode").fadeIn().html("Please enter pincode");
      setTimeout(function(){$("#err_pincode").fadeOut();},3000)
      $("#pincode").focus();
      return false;
    }
         
  }

  function get_state_by_country(id) { 
    var datastring = "id="+id;
    $.ajax({
      type:"post",
      url:"<?php echo site_url('Citizens/getState'); ?>",
      data:datastring,
      success:function(returndata) { 
        $('#state_id').html(returndata);
      }
    });
  }

  function only_number(event)
      {
        var x = event.which || event.keyCode;
        console.log(x);
        if((x >= 48 ) && (x <= 57 ) || x == 8 | x == 9 || x == 13 )
        {
          return;
        }else{
          event.preventDefault();
        }    
      }

</script>