<?php 
    $this->load->view('common/header');
    $this->load->view('common/left_panel');
?>

<!-- START BREADCRUMB -->
<?= $breadcrumbs ?>
<!-- END BREADCRUMB -->

<!-- PAGE CONTENT WRAPPER -->
<!-- START DEFAULT DATATABLE -->
<div class="page-content-wrap">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title"><strong><?php echo $heading; ?></strong></h3>
                    <h3 class="panel-title"><span class="msghide"><?= $this->session->userdata('message') <> '' ? $this->session->userdata('message') : ''; ?></span></h3>
                    <h3><span id="successCountryEntry"></span></h3>
                    <ul class="panel-controls">
                        <li><a href="#" data-toggle="modal" data-target="#myModal"><span class="fa fa-plus"></span></a></li>
                    </ul>
                </div>
                <div class="panel-body">
                    <table class="table table-bordered table-striped table-actions example_datatable table-condensed">
                        <thead>
                            <tr>
                                <th>Sr No.</th>
                                <th>Country Code</th>
                                <th>Country Name</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END DEFAULT DATATABLE -->

<script type="text/javascript">
    var url = "<?= $ajaxManagePage; ?>";
    var actioncolumn = "<?= $actioncolumn; ?>";
</script>

<div class="modal inmodal" id="checkStatus" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content animated bounceInRight">
            <form method="post" action="<?= $changeAction ?>">
                <div class="modal-body" style="height: 100px;padding-top: 10%">
                    <center>
                        <input type="hidden" name="id" id="statusId" style="display: none;">
                        <span style="font-size: 16px">Are you sure to change the status?</span>
                    </center>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary btn-sm">Ok</button>
                    <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="deleteData" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <form method="post" action="<?= $deleteAction ?>">
                <div class="modal-body" style="height: 120px;padding-top: 3%">
                    <center>
                        <input type="hidden" name="id" id="deleteId" style="display: none;">
                        <span style="font-size: 16px">
                            If you want to delete this record,all associated records will be deleted permanently from the Database.
                            <br>Are you sure? 
                        </span>
                    </center>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary btn-sm">Ok</button>
                    <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="myModal" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><strong>Add Country </strong><span id="successEntry" style="color:green"></span></h4>
            </div>
            <div class="modal-body">
                <form method="post">
                    <label>Country Code:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="countryCodeError" style="color:red"></span></label>
                    <input type="text" name="countryCode" id="countryCode" value="" class="form-control" placeholder="Country Code" size="35" />
                    <label>Country Name:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="countryNameError" style="color:red"></span></label>
                    <input type="text" name="countryName" id="countryName" value="" class="form-control" placeholder="Country Name" size="35" />
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-round btn-success" onclick="saveData()">Submit</button>
                <button type="button" class="btn btn-round btn-danger" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="myModaledit" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><strong>Edit Country </strong><span id="successEditEntry" style="color:green"></span></h4>
            </div>
            <div class="modal-body">
                <form method="post">
                    <label>Country Code:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="editCountryCodeError" style="color:red"></span></label>
                    <input type="text" name="countryCode" id="editCountryCode" value="" class="form-control" placeholder="Country Code" size="35" />
                    <label>Country Name:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="editCountryNameError" style="color:red"></span></label>
                    <input type="text" name="countryName" id="editCountryName" value="" class="form-control" placeholder="Country Name" size="35" />
                </form>
            </div>
            <div class="modal-footer">
                <input type="hidden" name="id" id="updateId">
                <button type="button" class="btn btn-round btn-success" onclick="updateData()">Submit</button>
                <button type="button" class="btn btn-round btn-danger" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    function checkStatus(id) {
        $("#statusId").val(id);
        $("#deleteId").val(id);
    }

    $(document).ready(function() {
        $(".preloader").show();
    })

</script>

<?php $this->load->view('common/footer');?>

<script type="text/javascript">
    function saveData() {
        var countryCode = $("#countryCode").val().trim();
        var countryName = $("#countryName").val().trim();
        var countryNamePattern = /^[a-zA-Z -]+$/;

        if(countryCode == "") {
            $("#countryCodeError").fadeIn().html("Please enter country code");
            setTimeout(function() {
                $("#countryCodeError").fadeOut();
            }, 3000);
            $("#countryCode").focus();
            return false;
        } else if(countryName == "") {
            $("#countryNameError").fadeIn().html("Please enter country name");
            setTimeout(function() {
                $("#countryNameError").fadeOut();
            }, 3000);
            $("#countryName").focus();
            return false;
        } else if(!countryNamePattern.test(countryName)) {
            $("#nameError").fadeIn().html("Name can have only alphabets (@,&,*,$,#,! are not allowed)");
            setTimeout(function() {
                $("#countryNameError").fadeOut();
            }, 3000);
            $("#countryName").focus();
            return false;
        }

        var datastring = "countryName=" + countryName + "&countryCode=" + countryCode;
        $.ajax({
            type: "post",
            url: "<?= $addAction ?>",
            data: datastring,
            success: function(response) {
                if(response == 1) {
                    $("#countryNameError").fadeIn().html("Country name already exist");
                    setTimeout(function() {
                        $("#countryNameError").fadeOut();
                    }, 3000);
                } else {
                    $(".close").click();
                    $("#successCountryEntry").fadeIn().html("<span class='label label-success'> Country has been added successfully</span>");
                    setTimeout(function() {
                        $("#successCountryEntry").fadeOut();
                    }, 3000);
                    $("#myModal").modal("hide");
                    table.draw();
                }
            }
        });
    }
</script>

<script type="text/javascript">
    function getEditValue(rowid) {
        $("#updateId").val(rowid);
        $.ajax({
            type: "POST",
            url: "<?= site_url('Countries/getUpdateName'); ?>",
            data: {
                id: rowid
            },
            cache: false,
            success: function(result) {
                var obj = $.parseJSON(result);

                var countryCode = obj.country_code;
                var countryName = obj.country_name;
                //alert(result);return false;
                $("#editCountryCode").val(countryCode);
                $("#editCountryName").val(countryName);
            }
        });
    }

    function updateData() {
        var countryCode = $("#editCountryCode").val().trim();
        var countryName = $("#editCountryName").val().trim();
        var updateId = $("#updateId").val();
        var countryNamePattern = /^[a-zA-Z -]+$/;

        if(countryCode == "") {
            $("#editCountryCodeError").fadeIn().html("Please enter country code");
            setTimeout(function() {
                $("#editCountryCodeError").fadeOut();
            }, 3000);
            $("#editCountryCode").focus();
            return false;
        } else if(countryName == "") {
            $("#editCountryNameError").fadeIn().html("Please enter country name");
            setTimeout(function() {
                $("#editCountryNameError").fadeOut();
            }, 3000);
            $("#editCountryName").focus();
            return false;
        } else if (!countryNamePattern.test(countryName)) {
            $("#editCountryNameError").fadeIn().html("Name can have only alphabets (@,&,*,$,#,! are not allowed)");
            setTimeout(function() {
                $("#editCountryNameError").fadeOut();
            }, 3000);
            $("#editCountryName").focus();
            return false;
        }

        var datastring = "countryCode=" + countryCode + "&id=" + updateId + "&countryName=" + countryName;

        $.ajax({
            type: "post",
            url: "<?= $updateAction; ?>",
            data: datastring,
            success: function(response) {
                if (response == 1) {
                    $("#editCountryNameError").fadeIn().html("Country name already exist");
                    setTimeout(function() {
                        $("#editCountryNameError").fadeOut();
                    }, 3000);
                } else {
                    $(".close").click();
                    $("#successCountryEntry").fadeIn().html("<span class='label label-success'> Country has been updated successfully</span>");
                    setTimeout(function() {
                        $("#successCountryEntry").fadeOut();
                    }, 3000);
                    $("#myModaledit").modal("hide");
                    table.draw();
                }
            }
        });
    }

</script>
