<?php 
    $this->load->view('common/header');
    $this->load->view('common/left_panel');
?>

<style>
  .pac-container {
    z-index: 9999;
  }
</style>

<!-- START BREADCRUMB -->
<?= $breadcrumbs ?>
<!-- END BREADCRUMB -->

<!-- PAGE CONTENT WRAPPER -->
<!-- START DEFAULT DATATABLE -->
<div class="page-content-wrap">
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title"><strong><?php echo $heading; ?></strong></h3>
                    <h3 class="panel-title"><span class="msghide"><?= $this->session->userdata('message') <> '' ? $this->session->userdata('message') : ''; ?></span></h3>
                    <h3><span id="successAreaEntry"></span></h3>
                    <ul class="panel-controls">
                        <li><a data-target="#uploadData" style="cursor:pointer;color:black;" title="Upload Excel" data-backdrop="static" data-keyboard="false" data-toggle="modal"><span class="fa fa-file-excel-o"></span></a></li>
                        <li><a href="#" data-toggle="modal" data-target="#myModal"><span class="fa fa-plus"></span></a></li>
                    </ul>
                </div>
                <div class="panel-body">
                    <table class="table table-bordered table-striped table-actions example_datatable table-condensed">
                        <thead>
                            <tr>
                                <th>Sr No.</th>
                                <th>Zone</th>
                                <th>Area</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END DEFAULT DATATABLE -->

<script type="text/javascript">
    var url = "<?= $ajax_manage_page; ?>";
    var actioncolumn = "<?= $actioncolumn; ?>";
</script>

<div class="modal inmodal" id="checkStatus" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content animated bounceInRight">
            <form method="post" action="<?php echo site_url('Areas/changeStatus'); ?>">
                <div class="modal-body" style="height: 100px;padding-top: 10%">
                    <center>
                        <input type="hidden" name="id" id="statusId" style="display: none;">
                        <span style="font-size: 16px">Are you sure to change the status?</span>
                    </center>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary btn-sm">Ok</button>
                    <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="deleteData" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <form method="post" action="<?php echo site_url('Areas/delete'); ?>">
                <div class="modal-body" style="height: 120px;padding-top: 3%">
                    <center>
                        <input type="hidden" name="id" id="deleteId" style="display: none;">
                        <span style="font-size: 16px">
                            If you want to delete this record,all associated records will be deleted permanently from the Database.
                            <br>Are you sure? 
                        </span>
                    </center>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary btn-sm">Ok</button>
                    <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="myModal" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><strong>Add Area </strong><span id="successEntry" style="color:green"></span></h4>
            </div>
            <div class="modal-body">
                <form method="post">
                    <label>Zone:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="zoneError" style="color:red"></span></label>
                    <select class="form-control" name="zone_id" id="zone_id">
                      <option value="">Select Zone</option>
                      <?php foreach($zones as $row) { ?>
                        <option value="<?= $row->id; ?>"><?= $row->zone_name; ?></option>
                      <?php } ?>
                    </select>
                    <br>
                    <label>Area:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="areaError" style="color:red"></span></label>
                    <input type="text" name="area" id="area" value="" class="form-control" placeholder="Enter area"/>
                    <br>

                    <label>Area (Marathi):<span style="color:red;"></span>&nbsp;&nbsp;&nbsp;<span id="" style="color:red"></span></label>
                    <input type="text" name="area_marathi" id="area_marathi" value="" class="form-control" placeholder="Enter area in marathi"/>
                    <br>

                    <label>Area (Hindi):<span style="color:red;"></span>&nbsp;&nbsp;&nbsp;<span id="" style="color:red"></span></label>
                    <input type="text" name="area_hindi" id="area_hindi" value="" class="form-control" placeholder="Enter area in hindi"/>
                    <br>
                    <!-- <textarea name="area" id="area" class="form-control" placeholder="Enter area"></textarea> -->
                    <input type="hidden" name="lat" id="lat">
                    <input type="hidden" name="lon" id="lon">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-round btn-success" onclick="saveData()">Submit</button>
                <button type="button" class="btn btn-round btn-danger" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="myModaledit" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><strong>Edit Area </strong><span id="successEditEntry" style="color:green"></span></h4>
            </div>
            <div class="modal-body">
                <!-- <form method="post">

                    <label>Zone:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="editZoneError" style="color:red"></span></label>
                    <select class="form-control" name="edit_zone_id" id="edit_zone_id">
                      <option value="">Select Zone</option>
                      <?php foreach($areas as $row) { ?>
                        <option value="<?= $row->id; ?>"><?= $row->zone_name; ?></option>
                      <?php } ?>
                    </select>

                    <label>Area:<span style="color:red;">*</span>&nbsp;&nbsp;&nbsp;<span id="editAreaError" style="color:red"></span></label>
                    <input type="text" name="editArea" id="editArea" value="" class="form-control" placeholder="Enter Area" />
                    <input type="hidden" name="lat_edit" id="lat_edit">
                    <input type="hidden" name="lon_edit" id="lon_edit">
                </form> -->
                <form method="post">
                    <div class="modal-body" id="getEditForm">
                      
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <input type="hidden" name="id" id="updateId">
                <button type="button" class="btn btn-round btn-success" onclick="updateData()">Submit</button>
                <button type="button" class="btn btn-round btn-danger" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<!--IMport strart-->
<div class="modal inmodal" id="uploadData" data-modal-color="lightblue" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm">
        <div class="modal-content animated bounceInRight">   
            <form method="post" action="<?= site_url('Areas/import')?>" method="post" enctype="multipart/form-data" onsubmit="return checkXcel()">  
                <div class="modal-header">
                        <span style="font-size:20px">Upload Excel</span>

                    </div>     
                <div class="modal-body" style="padding-top: 3%"> 
                  <a download class="pull-left" href="<?php echo base_url(); ?>uploads/import_excel/area_sample.xlsx" style="font-size:10px">Download Sample Format</a>  <br>
                    <input type="file" name="excel_file" id="excel_file" class="form-control">
                        &nbsp;<span style="color:red" id="errorexcel_file"></span>&nbsp;
                </div>
                <div class="modal-footer">
                    <button type="button" id="dis_btn" class="btn btn-primary" onclick="return checkXcel();">Ok</button>
                    <button type="submit" id="btn_click" style="display:none" class="btn btn-primary">Ok</button>
                    <button type="button" class="btn btn-white" data-dismiss="modal">Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<!--IMport strart-->


<script type="text/javascript">
    function checkStatus(id) {
        $("#statusId").val(id);
        $("#deleteId").val(id);
    }

    $(document).ready(function() {
        $(".preloader").show();
    })

</script>

<?php $this->load->view('common/footer');?>

<script type="text/javascript">
    function saveData() {
        var zone_id = $("#zone_id").val().trim();
        var area = $("#area").val().trim();
        var area_marathi = $("#area_marathi").val().trim();
        var area_hindi = $("#area_hindi").val().trim();
        var lat = $("#lat").val();
        var lon = $("#lon").val();

        if(zone_id=='' || zone_id==null) {
            $("#zoneError").fadeIn().html("Please select zone");
            setTimeout(function() {
                $("#zoneError").fadeOut();
            }, 3000);
            $("#zone_id").focus();
            return false;
        }

        if(area == "") {
            $("#areaError").fadeIn().html("Please enter area");
            setTimeout(function() {
                $("#areaError").fadeOut();
            }, 3000);
            $("#area").focus();
            return false;
        }

        var datastring = "zone_id=" + zone_id +"&area=" + area +"&area_marathi=" + area_marathi +"&area_hindi=" + area_hindi +"&lat="+lat+"&lon="+lon;;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Areas/addData') ;?>",
            data: datastring,
            success: function(response) {
                if(response == 1) {
                    $("#areaError").fadeIn().html("Area already exist");
                    setTimeout(function() {
                        $("#areaError").fadeOut();
                    }, 3000);
                } else {
                    $(".close").click();
                    $("#successAreaEntry").fadeIn().html("<span class='label label-success'> Area has been added successfully</span>");
                    setTimeout(function() {
                        $("#successAreaEntry").fadeOut();
                    }, 3000);
                    $("#myModal").modal("hide");
                    table.draw();
                }
            }
        });
    }
</script>

<script type="text/javascript">
    function getEditValue(rowid) {
        $("#updateId").val(rowid);
        $.ajax({
            type: "POST",
            url: "<?= site_url('Areas/getUpdateName'); ?>",
            data: {
                id: rowid
            },
            cache: false,
            success: function(result) {
                // var obj = $.parseJSON(result);
                // var area = obj.area;
                // //alert(result);return false;
                // $("#editArea").val(area);
                // $("#edit_zone_id").val(zone_name);

                $("#getEditForm").html(result);
            }
        });
    }

    function updateData() {
        var zone_id = $("#edit_zone_id").val().trim();
        var area = $("#editArea").val().trim();
        var area_marathi = $("#area_marathi_edit").val().trim();
        var area_hindi = $("#area_hindi_edit").val().trim();
        var lat = $("#lat_edit").val();
        var lon = $("#lon_edit").val();
        var updateId = $("#updateId").val();
        //var professionNamePattern = /^[a-zA-Z -]+$/;

        if(zone_id=='' || zone_id==null) {
            $("#EdittitleError1").fadeIn().html("Please select zone");
            setTimeout(function() {
                $("#EdittitleError1").fadeOut();
            }, 3000);
            $("#zone_id").focus();
            return false;
        }

        if(area == "") {
            $("#editAreaError").fadeIn().html("Please enter area");
            setTimeout(function() {
                $("#editAreaError").fadeOut();
            }, 3000);
            $("#editArea").focus();
            return false;
        }

        var datastring = "area="+area+"&area_marathi="+area_marathi+"&area_hindi="+area_hindi+"&zone_id="+zone_id+"&id="+updateId+"&lat="+lat+"&lon="+lon;

        $.ajax({
            type: "post",
            url: "<?php echo site_url('Areas/updateData'); ?>",
            data: datastring,
            success: function(response) {
                if (response == 1) {
                    $("#editAreaError").fadeIn().html("Area already exist");
                    setTimeout(function() {
                        $("#editAreaError").fadeOut();
                    }, 3000);
                } else {
                    $(".close").click();
                    $("#successAreaEntry").fadeIn().html("<span class='label label-success'> Area has been updated successfully</span>");
                    setTimeout(function() {
                        $("#successAreaEntry").fadeOut();
                    }, 3000);
                    $("#myModaledit").modal("hide");
                    table.draw();
                }
            }
        });
    }

</script>

<script async defer src="https://maps.googleapis.com/maps/api/js?v=3&key=AIzaSyAvHHoPKPwRFui0undeEUrz00-8w6qFtik&libraries=places&callback=initialize"
  type="text/javascript">
</script>

<script>

  /* for google locations autocomplete */
  function initialize() 
  {
  //alert('hie'); return false;
  var input = document.getElementById('area');
  autocomplete = new google.maps.places.Autocomplete(input);
  google.maps.event.addListener(autocomplete, 'place_changed', function() 
  {
    var place = autocomplete.getPlace();
     // alert (); 
     var lat = place.geometry.location.lat();
     var lng = place.geometry.location.lng();
     $("#lat").val(lat);
     $("#lon").val(lng);
     initMap();
     if (!place.geometry) {
            //try a basic geocode
            searchlocation(place.name);
            return;
          }



        });
    // Set initial restrict to the greater list of countries.
    autocomplete.setComponentRestrictions(
      {'country': ['in']});

    function setupClickListener(id, countries) {
      var radioButton = document.getElementById(id);
      radioButton.addEventListener('click', function() {
        autocomplete.setComponentRestrictions({'country': countries});
      });
    }

  }
  initialize();
  function initMap() 
  {
    var lat = parseFloat(document.getElementById('lat').value);
    var lng = parseFloat(document.getElementById('lon').value);

    var map = new google.maps.Map(document.getElementById('map'), {
      center: {
        lat: lat,
        lng: lng
      },
      zoom: 13,
      mapTypeId: 'roadmap'
    });
    var latlng = new google.maps.LatLng(lat,lng);
    var marker = new google.maps.Marker({
      map: map,
      position: latlng,
      draggable: true,
      
    });

    google.maps.event.addListener(marker, 'dragend', function (event) {
      document.getElementById("lat").value = this.getPosition().lat();
      document.getElementById("lon").value = this.getPosition().lng();
      getAddress();
    });
  }
  function getAddress()
  {
   var lat=$("#lat").val();
   var lon=$("#lon").val();

   $.ajax({
    type:"post",
    cache:false,
    url:"<?php echo site_url(); ?>/Areas/getAddress",
    data:{lat:lat,lon:lon},
    beforeSend:function(){},
    success:function(returndata)
    {   
      var obj=jQuery.parseJSON(returndata);
      $("#area").val(obj.address);
    }
  });
 }
</script>


<script type="text/javascript">
function checkXcel() 
{
    var excel_file = $("#excel_file").val();
    if(excel_file=="")
    {
        $("#errorexcel_file").fadeIn().html("Please select excel file in xls or csv format");
        setTimeout(function(){$("#errorexcel_file").fadeOut();},5000);
        $("#excel_file").focus();
        return false;   
    }
    else
    {
        $("#dis_btn").attr("disabled", "disabled"); 
        $('#btn_click').click();
    }    
}

$("#excel_file").change(function() { 
   var val = $(this).val();
   
   switch(val.substring(val.lastIndexOf('.') + 1).toLowerCase()){
   case 'xls': case 'csv': case 'xlsx': 
   
   break;
   default:
   $(this).val('');
   $("#errorexcel_file").fadeIn().html("Upload file in xls or csv or xlsx format only");
          setTimeout(function(){$("#errorexcel_file").html("&nbsp;");},5000);
   break;
   }
   });
   
</script>