<?php $this->load->view('common/header'); ?>
<?php $this->load->view('common/left_panel'); ?>
<?php echo $breadcrumbs; ?>
<div class="page-content-wrap">
  <div class="row">
    <div class="col-md-12">
      <form class="form-horizontal" method="post" action="<?php echo $action; ?>" enctype="multipart/form-data">
        <div class="panel panel-default">
          <div class="panel-heading">
            <h3 class="panel-title"><strong><?php echo $heading; ?></strong></h3>
            <ul class="panel-controls">
              <li><a href="<?= $cancelbtn;?>"><span class="fa fa-arrow-left"></span></a></li>
            </ul>
          </div>
          <div class="panel-body">   
            <div class="col-md-12">
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">State <span style="color:red;">*</span><span id="state_id_err"></span><span class="text-danger errmsg"><?php echo form_error('state_id'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="state_id" id="state_id" onchange="get_district_by_state(this.value)">
                      <option value="">Select State</option>
                      <?php foreach ($states as $state) { ?>
                      <option value="<?= $state->id; ?>" <?php if($state->id==$state_id)echo "selected";; ?>><?= $state->state_name; ?></option>
                      <?php } ?>
                    </select>
                  </div>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">District <span style="color:red;">*</span><span id="district_id_err"></span><span class="text-danger errmsg"><?php echo form_error('district_id'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="district_id" id="district_id" onchange="get_city_by_district(this.value)">
                      <option value="">Select District</option>
                      <?php if($button=='Update') {  foreach ($districts as $district) { ?>
                      <option value="<?= $district->id; ?>" <?php if($district->id==$district_id)echo "selected";; ?>><?= $district->district_name; ?></option>
                      <?php } } ?>
                    </select>
                  </div>
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">City <span style="color:red;">*</span><span id="city_id_err"></span><span class="text-danger errmsg"><?php echo form_error('city_id'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="city_id" id="city_id" onchange="get_police_station_by_city(this.value)">
                      <option value="">Select City</option>
                      <?php if($button=='Update') {  foreach ($cities as $city) { ?>
                      <option value="<?= $city->id; ?>" <?php if($city->id==$city_id)echo "selected";; ?>><?= $city->city_name; ?></option>
                      <?php } } ?>
                    </select>
                  </div>
                </div>
              </div>
             
              <div class="col-md-6">
                <div class="form-group">
                    <label class="col-md-12">Police Station <span class="text-danger">*</span><span class="text-danger" id="police_station_id_err"></span><span class="text-danger errmsg"><?= form_error('police_station_id'); ?></span></label>
                    <div class="col-md-10">
                        <select class="form-control" name="police_station_id" id="police_station_id" onchange="get_police_list(this.value)">
                            <option value="">Select Police Station</option>
                            <?php if($button=='Update') { foreach ($policeStations as $row) { ?>
                            <option value="<?= $row->id; ?>" <?php if($row->id==$police_station_id)echo "selected";; ?>><?= $row->name; ?></option>
                            <?php } }?>
                        </select>
                    </div>
                </div>
             </div>

             <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">From Date <span style="color:red;">*</span><span id="from_date_err"></span><span class="text-danger errmsg"><?php echo form_error('from_date'); ?></span> </label>
                  <div class="col-md-10">
                    <input type="text" id="from_date" name="from_date" class="form-control"  placeholder="Enter From Date" value="<?php echo $from_date; ?>" autocomplete="off">
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">To Date <span style="color:red;">*</span><span id="to_date_err"></span><span class="text-danger errmsg"><?php echo form_error('to_date'); ?></span> </label>
                  <div class="col-md-10">
                    <input type="text" id="to_date" name="to_date" class="form-control"  placeholder="Enter To Date" value="<?php echo $to_date; ?>" autocomplete="off">
                  </div> 
                </div>
              </div>

              <div class="col-md-12">
                <div class="form-group">
                  <label class="col-md-12">Assign Petrolnings</label>
                  <div class="col-md-11">
                    <table class="table table-striped table-bordered table-hover table-condensed" id="newpdfurlrow" >
                      <thead>
                        <tr bgcolor="#dcdcdc">
                          <th>Select Vehicles</th>
                          <th>Address</th>
                          <th>Select Police</th>
                          <th class="text-center">
                            <button title="Add row" type="button" onclick="addrow_feedback()" class="btn bg-green waves-effect"><b><i class="fa fa-plus"></i></b></button>
                          </th>
                         
                         </tr>
                      </thead>
                      <tbody id="clonetable_feedback">
                        <tr class="rows viewpolicelist"></tr>
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>
              <input type="hidden" name="id"  value="<?php echo $id;?>">
              <input type="hidden" name="update_id" id="up_id" value="<?php echo $update_id;?>">
            </div>
          </div>
          <div class="panel-footer">
            <button class="btn btn-success" type="submit" id="submit" value="<?= $button;?>" onclick="return validation();"><?= $button;?></button>
            <a href="<?= $cancelbtn ?>"  class="btn btn-danger">Cancel</a>
          </div>
        </div>
      </form>
    </div>
  </div>                    
</div>
<?php $this->load->view('common/footer'); ?>

<script type="text/javascript">
  window.onload = function(){ 
   //alert('hi');return false;  
     var police_station_id = $("#police_station_id").val();
     var id = $("#up_id").val();
     var flag = "Update";
     if(police_station_id!=''){
     //alert(police_station_id);return false;
      get_police_list(police_station_id,flag,id);
     }
  }
  function validation() 
  {
    //alert('hiee'); return false;
    var state_id = $("#state_id").val().trim();
    var district_id = $("#district_id").val().trim();
    var city_id = $("#city_id").val().trim();
    var police_station_id = $("#police_station_id").val();  
    var from_date = $("#from_date").val().trim(); 
    var to_date = $("#to_date").val().trim();
    
    if(state_id=='' || state_id==null)
    {
      $("#state_id_err").fadeIn().html("Please select state").css('color',"red");
      setTimeout(function(){$("#state_id_err").fadeOut("&nbsp");},3000)
      $("#state_id").focus();return false;
    }
    if (district_id == '' || district_id == null) 
    {
        $("#district_id_err").fadeIn().html("Please select district").css('color', "red");
        setTimeout(function(){$("#district_id_err").fadeOut();},3000)
        $("#district_id").focus();return false;
    }
    if(city_id=='' || city_id==null)
    {
      $("#city_id_err").fadeIn().html("Please select city name").css('color',"red");
      setTimeout(function(){$("#city_id_err").fadeOut("&nbsp");},3000)
      $("#city_id").focus();return false;
    } 
    
    if(police_station_id=='' || police_station_id==null)
    {
      $("#police_station_id_err").fadeIn().html("Please select station").css('color',"red");
      setTimeout(function(){$("#police_station_id_err").fadeOut("&nbsp");},3000)
      $("#police_station_id").focus();return false;
    } 
    if(from_date=='' || from_date==null)
    {
      $("#from_date_err").fadeIn().html("Required").css('color',"red");
      setTimeout(function(){$("#from_date_err").fadeOut("&nbsp");},3000)
      $("#from_date").focus();
      return false;
    } 
    if(to_date=='' || to_date==null)
    {
      $("#to_date_err").fadeIn().html("Required").css('color',"red");
      setTimeout(function(){$("#to_date_err").fadeOut("&nbsp");},3000)
      $("#to_date").focus();
      return false;
    }
  }  

  function get_state_by_country(id)
  {
    var datastring = "id="+id;
        $.ajax({
        type:"post",
        url:"<?php echo site_url('GpsPetrollings/getState'); ?>",
        data:datastring,
        success:function(returndata) {
          $('#state_id').html(returndata);
        }
    });
}

function get_district_by_state(id) {
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('GpsPetrollings/getDistrict'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#district_id').html(returndata);
            }
        });
    }

function get_city_by_district(id) {
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('GpsPetrollings/getCity'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#city_id').html(returndata);
            }
        });
    }

function get_police_station_by_city(id)
{
  var datastring = "id=" + id;
  $.ajax({
        type: "post",
        url: "<?php echo site_url('GpsPetrollings/getpolicestation'); ?>",
        data: datastring,
        success: function(returndata) {
            $('#police_station_id').html(returndata);
        }
    });
}

function get_police_list(id,flag="",up_id="")
{          
   var datastring = "id=" + id+"&button="+flag+"&update_id="+up_id;
  $.ajax({
        type: "post",
        url: "<?php echo site_url('GpsPetrollings/getpolicedetails');?>",
        data: datastring,
        success: function(returndata) { 
          //alert(returndata);return false;
            $('.viewpolicelist').html(returndata);
        }
    });
}

  function only_number(event)
      {
        var x = event.which || event.keyCode;
        console.log(x);
        if((x >= 48 ) && (x <= 57 ) || x == 8 | x == 9 || x == 13 )
        {
          return;
        }else{
          event.preventDefault();
        }    
      }
</script>

<script type="text/javascript">
    /*function addrow_feedback()
   {
     var y=document.getElementById('clonetable_feedback');
     var new_row = y.rows[0].cloneNode(true);
     var len = y.rows.length;
     new_number=Math.round(Math.exp(Math.random()*Math.log(10000000-0+1)))+0;
     var inp1 = new_row.cells[0].getElementsByTagName('select')[0];
     inp1.value = '';
     inp1.id = 'vehicle_id'+'address'+'police_id'+(len+1);
     var submit_btn =$('#submit_btn').val();
     if (submit_btn=="Update") 
     {
       var inp3 = new_row.cells[1].getElementsByTagName('video_url')[0]+new_row.cells[2].getElementsByTagName('from_date')[0]+new_row.cells[3].getElementsByTagName('to_date')[0];      
       inp3.src = '';
     }
     y.appendChild(new_row);      
     }*/

function addrow_feedback() {
        var y = document.getElementById('clonetable_feedback');
        var new_row = y.rows[0].cloneNode(true);
        var len = y.rows.length;
        var inp1 = new_row.cells[0].getElementsByTagName('select')[0];
        inp1.value = '';
        inp1.id = 'vehicle_id' + 'address' + 'police_id' + (len + 1);
        var submit_btn = $('#submit_btn').val();
        if (submit_btn == "Update") {
            var inp3 = new_row.cells[1].getElementsByTagName('vehicle_id')[0] + new_row.cells[2].getElementsByTagName('address')[0] + new_row.cells[3].getElementsByTagName('police_id')[0];
            inp3.src = '';
        }
        y.appendChild(new_row);
        assignName();
    }

    function assignName()
    {
        var keys = 0;
        $('.viewpolicelist').each(function(){

            var a = $(this).find(':nth-child(3)').children('select');
            a.attr('name', 'police_id['+keys+'][]');

            keys = parseInt(keys) + 1;
        });
    }

 //delete adde row 
 function deleteRow_feedback(row)
 {
   var y=document.getElementById('newpdfurlrow');
   var len = y.rows.length;   
   if(len>2)
   {
     var i= (len-1);
     document.getElementById('clonetable_feedback').deleteRow(row);
   }
 } 
</script>

<script>
  setTimeout(function(){$(".errmsg").fadeOut("&nbsp");},3000)
</script>