<?php $this->load->view('common/header'); ?>
<?php $this->load->view('common/left_panel'); ?>
<?php echo $breadcrumbs; ?>
<div class="page-content-wrap">
  <div class="row">
    <div class="col-md-12">
      <form class="form-horizontal" method="post" action="<?php echo $action; ?>" enctype="multipart/form-data">
        <div class="panel panel-default">
          <div class="panel-heading">
            <h3 class="panel-title"><strong><?php echo $heading; ?></strong></h3>
            <ul class="panel-controls">
              <li><a href="<?= $cancelbtn;?>"><span class="fa fa-arrow-left"></span></a></li>
            </ul>
          </div>
          <div class="panel-body">   
            <div class="col-md-12">
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12"> Name <span style="color:red;">*</span><span id="name_err"></span><span class="text-danger errmsg"><?php echo form_error('name'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="name" id="name" placeholder="Enter corporate name" value="<?php echo $name; ?>" />
                  </div> 
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12"> Name (Marathi)</label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="name_marathi" id="name_marathi" placeholder="Enter corporate name in marathi" value="<?php echo $name_marathi; ?>" />
                  </div> 
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12"> Name (Hindi)<span class="text-danger errmsg"></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="name_hindi" id="name_hindi" placeholder="Enter corporate name in hindi" value="<?php echo $name_hindi; ?>" />
                  </div> 
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Email <span style="color:red;">*</span><span id="email_err"></span><span class="text-danger errmsg"><?php echo form_error('email'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="email" id="email" placeholder="Enter email" value="<?php echo $email; ?>" />
                  </div> 
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Mobile <span style="color:red;">*</span><span id="mobile_err"></span><span class="text-danger errmsg"><?php echo form_error('mobile'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="mobile" id="mobile" placeholder="Enter mobile no" value="<?php echo $mobile; ?>" maxlength='10' onkeypress="only_number(event)"/>
                  </div> 
                </div>
              </div>
              
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Country <span style="color:red;">*</span><span id="country_id_err"></span><span class="text-danger errmsg"><?php echo form_error('country_id'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="country_id" id="country_id" onchange="get_state_by_country(this.value)">
                      <option value="">Select country</option>
                      <?php foreach($countries as $country){?>
                        <option value="<?= $country->id; ?>" <?php if($country->id==$country_id)echo "selected";; ?>><?= $country->country_name; ?></option>
                      <?php } ?>
                    </select>
                  </div> 
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">State <span style="color:red;">*</span><span id="state_id_err"></span><span class="text-danger errmsg"><?php echo form_error('state_id'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="state_id" id="state_id" onchange="get_district_by_state(this.value)">
                      <option value="">Select State</option>
                      <?php foreach ($states as $state) { ?>
                        <option value="<?= $state->id; ?>" <?php if($state->id==$state_id)echo "selected";; ?>><?= $state->state_name; ?></option>
                      <?php } ?>  
                    </select>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                    <label class="col-md-12">District <span class="text-danger">*</span><span class="text-danger" id="err_district_id"></span><span class="text-danger errmsg"><?= form_error('district_id'); ?></span></label>
                    <div class="col-md-10">
                        <select class="form-control" name="district_id" id="district_id" onchange="get_city_by_district(this.value)">
                            <option value="">Select District</option>
                            <?php foreach ($districts as $row) { ?>
                            <option value="<?= $row->id; ?>" <?php if($row->id==$district_id)echo "selected";; ?>><?= $row->district_name; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">City <span style="color:red;">*</span><span id="city_id_err"></span><span class="text-danger errmsg"><?php echo form_error('city_id'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="city_id" id="city_id" onchange="get_zone_by_city(this.value)">
                      <option value="">Select City</option>
                      <?php foreach($cities as $city){?>
                        <option value="<?= $city->id; ?>" <?php if($city->id==$city_id)echo "selected";; ?>><?= $city->city_name; ?></option>
                      <?php } ?>
                    </select>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                  <div class="form-group">
                      <label class="col-md-12">Zone<span class="text-danger">*</span><span class="text-danger" id="zone_id_err"></span><span class="text-danger errmsg"><?= form_error('zone_id'); ?></span></label>
                      <div class="col-md-10">
                          <select class="form-control" name="zone_id" id="zone_id" onchange="get_area_by_zone(this.value)">
                              <option value="">Select Zone</option>
                              <?php foreach($zones as $row){?>
                              <option value="<?= $row->id; ?>" <?php if($row->id==$zone_id)echo "selected"; ?>><?= $row->zone_name ; ?></option>
                              <?php } ?>
                          </select>
                      </div>
                  </div>

              </div>

              <div class="col-md-6">
                  <div class="form-group">
                      <label class="col-md-12">Area <span class="text-danger">*</span><span class="text-danger" id="area_id_err"></span><span class="text-danger errmsg"><?= form_error('area_id'); ?></span></label>
                      <div class="col-md-10">
                          <select class="form-control" name="area_id" id="area_id">
                              <option value="">Select Area</option>
                              <?php foreach ($areas as $row) { ?>
                              <option value="<?= $row->id; ?>" <?php if($row->id==$area_id)echo "selected"; ?>><?= $row->area; ?></option>
                              <?php }  ?>
                          </select>
                      </div>
                  </div>
              </div>
              

             
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12"> Role <span style="color:red;">*</span><span id="role_err"></span><span class="text-danger errmsg"><?php echo form_error('role'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="role" id="role" onchange="get_mla(this.value)">
                    <option value="">Select Role </option>
                      <option value="Collector"<?php if('Collector' == $role) echo "selected";?>>Collector</option>
                      <option value="MLA"<?php if('MLA' == $role) echo "selected";?>>MLA</option>
                      <option value="Ward Member"<?php if('Ward Member' == $role) echo "selected";?>>Ward Member</option>
                      <option value="Employees"<?php if('Employees' == $role) echo "selected";?>>Department Employee</option>
                    </select>
                  </div> 
                </div>
              </div>
              
              <div class="col-md-6" style='display:none;' id="mla">
                <div class="form-group">
                  <label class="col-md-12"> MLA <span style="color:red;">*</span><span id="corporate_id_err"></span><span class="text-danger errmsg"><?php echo form_error('corporate_id'); ?></span> </label>
                  <div class="col-md-10"> 
                    <select class="form-control" name="corporate_id" id="corporate_id">
                      <option value="">Select MLA </option>
                      <?php foreach ($corporates as $row) { ?>
                      <option value="<?= $row->id; ?>" <?php if($row->id==$corporate_id)echo "selected"; ?>><?= $row->name; ?></option>
                      <?php }  ?>
                    </select>
                  </div> 
                </div>
              </div>

              <div class="col-md-6" style='display:none;' id="department">
                <div class="form-group">
                  <label class="col-md-12"> Department <span style="color:red;">*</span><span id="department_id_err"></span><span class="text-danger errmsg"><?php echo form_error('department_id'); ?></span> </label>
                  <div class="col-md-10"> 
                    <select class="form-control" name="department_id" id="department_id" onchange="get_branch_by_dept(this.value)">
                      <option value="">Select Department </option>
                      <?php foreach ($departments as $row) { ?>
                      <option value="<?= $row->id; ?>" <?php if($row->id==$department_id)echo "selected"; ?>><?= $row->department_name; ?></option>
                      <?php }  ?>
                    </select>
                  </div> 
                </div>
              </div>
              <div class="col-md-6" style='display:none;' id="branch">
                <div class="form-group">
                  <label class="col-md-12"> Branch <span style="color:red;">*</span><span id="branch_id_err"></span><span class="text-danger errmsg"><?php echo form_error('branch_id'); ?></span> </label>
                  <div class="col-md-10"> 
                    <select class="form-control" name="branch_id" id="branch_id">
                      <option value="">Select Branch </option>
                      <?php foreach ($branches as $row) { ?>
                      <option value="<?= $row->id; ?>" <?php if($row->id==$branch_id)echo "selected"; ?>><?= $row->branch_name; ?></option>
                      <?php }  ?>
                    </select>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Pincode <span style="color:red;"></span><span id="pincode_err"></span><span class="text-danger errmsg"><?php echo form_error('pincode'); ?></span> </label>
                  <div class="col-md-10">
                    <input type="text" id="pincode" name="pincode" class="form-control"  placeholder="Enter pincode" value="<?php echo $pincode; ?>" maxlength="6" onkeypress="only_number(event)">
                  </div> 
                </div>
              </div>
               <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Address <span style="color:red;"></span><span id="address_err"></span><span class="text-danger errmsg"><?php echo form_error('address'); ?></span> </label>
                  <div class="col-md-10">
                    <textarea name="address" id="address" placeholder="Enter address" class="form-control" ><?= $address;?></textarea>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Address (Marathi)<span class="text-danger errmsg"></label>
                  <div class="col-md-10">
                    <textarea name="address_marathi" id="address_marathi" placeholder="Enter address in marathi" class="form-control" ><?= $address_marathi;?></textarea>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Address (Hindi)<span class="text-danger errmsg"></span> </label>
                  <div class="col-md-10">
                    <textarea name="address_hindi" id="address_hindi" placeholder="Enter address in hindi" class="form-control" ><?= $address_hindi;?></textarea>
                  </div> 
                </div>
              </div>
              <div class="col-md-6">
                  <div class="form-group">
                      <label class="col-md-12">Allow To Accept Complaints <span class="text-danger"></span><span class="text-danger" id="is_check"></span><span class="text-danger"><?= form_error('is_check'); ?></span></label>
                      <?php if($button=='Create') { ?>
                      <div class="col-md-10">
                          <input type="radio" name="is_check" value="Yes" <?php if($is_check =='Yes') echo 'checked';?>> Yes
                          <input checked type="radio" name="is_check" value="No" <?php if($is_check =='No') echo 'checked';?>> No
                      </div>
                    <?php } else { ?>
                      <div class="col-md-10">
                          <input type="radio" name="is_check" value="Yes" <?php if($is_check =='Yes') echo 'checked';?>> Yes
                          <input type="radio" name="is_check" value="No" <?php if($is_check =='No') echo 'checked';?>> No
                      </div>
                    <?php } ?>
                  </div>
              </div>


              <div class="col-md-6">
               <div class="form-group">
                <label class="col-md-12">Image <span style="color:red;"></span><span id="error_image" style="color:red;"></span> </label>
                <div class="col-md-10">
                 <input type="file" class="form-control" name="image" id="image" title="Browse file"/>
                 <span class="">Please select image type jpg,png,jpeg </span>
                 <?php if($button!='Create'){ if(!empty($image)) {?>
                  <br>
                  <img src="<?php echo base_url('uploads/corporates/'.$image); ?>" style="width:100px;">
                  <input type="hidden" name="old_image" value="<?php echo $image; ?>">
                <?php } }?>
              </div> 
            </div> 
              </div>
             
              
              <input type="hidden" name="id" value="<?php echo $id;?>">
            </div>
          </div>
          <div class="panel-footer">
            <button class="btn btn-success" type="submit" id="submit" value="<?= $button;?>" onclick="return validation();"><?= $button;?></button>
            <a href="<?= $cancelbtn ?>"  class="btn btn-danger">Cancel</a>
          </div>
        </div>
      </form>
    </div>
  </div>                    
</div>
<?php $this->load->view('common/footer'); ?>

<script type="text/javascript">
  function validation() {
    var name = $("#name").val().trim(); 
    var pattern_name = /^[a-zA-Z ]{2,30}$/;
    var email = $("#email").val().trim(); 
    var pattern_email= /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/i;
    var mobile = $("#mobile").val().trim(); 
    var pattern_mobile = /^[0]?[789]\d{9}$/;
    var country_id = $("#country_id").val().trim();
    var state_id = $("#state_id").val().trim();  
    var district_id = $("#district_id").val().trim();
    var city_id = $("#city_id").val().trim();
    var zone_id = $("#zone_id").val().trim();
    var area_id = $("#area_id").val().trim(); 
    var role = $("#role").val().trim(); 
    var corporate_id = $("#corporate_id").val().trim(); 
    var department_id = $("#department_id").val().trim(); 
    var branch_id = $("#branch_id").val().trim(); 
    //var address = $("#address").val().trim(); 
    //var pincode = $("#pincode").val().trim(); 

    if(name=='')
    {
      $("#name_err").fadeIn().html("Please enter name").css('color',"red");
      setTimeout(function(){$("#name_err").fadeOut("&nbsp");},3000)
      $("#name").focus();
      return false;
    } 
    else if (!pattern_name.test(name)) 
    {
      $("#name_err").fadeIn().html("Please enter valid name").css('color', "red");
      setTimeout(function() {
          $("#name_err").fadeOut();
      }, 3000)
      $("#name").focus();
      return false;
    } 

    if(email=='')
    {
      $("#email_err").fadeIn().html("Please enter email").css('color',"red");
      setTimeout(function(){$("#email_err").fadeOut("&nbsp");},3000)
      $("#email").focus();
      return false;
    } 
    else if (!pattern_email.test(email)) 
    {
      $("#email_err").fadeIn().html("Please enter valid email").css('color', "red");
      setTimeout(function() {
          $("#email_err").fadeOut();
      }, 3000)
      $("#email").focus();
      return false;
    } 

    if(mobile=='')
    {
      $("#mobile_err").fadeIn().html("Please enter mobile no").css('color',"red");
      setTimeout(function(){$("#mobile_err").fadeOut("&nbsp");},3000)
      $("#mobile").focus();
      return false;
    } 
    else if (!pattern_mobile.test(mobile)) 
    {
      $("#mobile_err").fadeIn().html("Please enter valid mobile").css('color', "red");
      setTimeout(function() {
          $("#mobile_err").fadeOut();
      }, 3000)
      $("#mobile").focus();
      return false;
    } 

    if(country_id=='' || country_id==null)
    {
      $("#country_id_err").fadeIn().html("Please enter country").css('color',"red");
      setTimeout(function(){$("#country_id_err").fadeOut("&nbsp");},3000)
      $("#country_id").focus();
      return false;
    } 

    if(state_id=='' || state_id==null)
    {
      $("#state_id_err").fadeIn().html("Please select state").css('color',"red");
      setTimeout(function(){$("#state_id_err").fadeOut("&nbsp");},3000)
      $("#state_id").focus();
      return false;
    } 

    if (district_id == '' || district_id == null) 
    {
        $("#err_district_id").fadeIn().html("Please select district").css('color', "red");
        setTimeout(function() {
            $("#err_district_id").fadeOut();
        }, 3000)
        $("#district_id").focus();
        return false;
    }

    if(city_id=='' || city_id==null)
    {
      $("#city_id_err").fadeIn().html("Please select city name").css('color',"red");
      setTimeout(function(){$("#city_id_err").fadeOut("&nbsp");},3000)
      $("#city_id").focus();
      return false;
    } 

    if(zone_id=='' || zone_id==null)
    {
      $("#zone_id_err").fadeIn().html("Please select zone").css('color',"red");
      setTimeout(function(){$("#zone_id_err").fadeOut("&nbsp");},3000)
      $("#zone_id").focus();
      return false;
    } 

    if(area_id=='' || area_id==null)
    {
      $("#area_id_err").fadeIn().html("Please select city name").css('color',"red");
      setTimeout(function(){$("#area_id_err").fadeOut("&nbsp");},3000)
      $("#area_id").focus();
      return false;
    }  

    if(role=='' || role==null)
    {
      $("#role_err").fadeIn().html("Please select role").css('color',"red");
      setTimeout(function(){$("#role_err").fadeOut("&nbsp");},3000)
      $("#role").focus();
      return false;
    }

    if(role=='Ward Member')
    {

      if(corporate_id=='' || corporate_id==null)
      {
        $("#corporate_id_err").fadeIn().html("Please select mla").css('color',"red");
        setTimeout(function(){$("#corporate_id_err").fadeOut("&nbsp");},3000)
        $("#corporate_id").focus();
        return false;
      }

    }

    if(role=='Employees')
    {

      if(department_id=='' || department_id==null)
      {
        $("#department_id_err").fadeIn().html("Please select department").css('color',"red");
        setTimeout(function(){$("#department_id_err").fadeOut("&nbsp");},3000)
        $("#department_id").focus();
        return false;
      }

      if(branch_id=='' || branch_id==null)
      {
        $("#branch_id_err").fadeIn().html("Please select branch").css('color',"red");
        setTimeout(function(){$("#branch_id_err").fadeOut("&nbsp");},3000)
        $("#branch_id").focus();
        return false;
      }

    }

    // if(pincode=='')
    // {
    //   $("#pincode_err").fadeIn().html("Please enter pincode").css('color',"red");
    //   setTimeout(function(){$("#pincode_err").fadeOut("&nbsp");},3000)
    //   $("#pincode").focus();
    //   return false;
    // }

    // if(address=='')
    // {
    //   $("#address_err").fadeIn().html("Please enter address").css('color',"red");
    //   setTimeout(function(){$("#address_err").fadeOut("&nbsp");},3000)
    //   $("#address").focus();
    //   return false;
    // }   

  }


 function get_state_by_country(id) {
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Corporates/getState'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#state_id').html(returndata);
            }
        });
    }

    function get_district_by_state(id) {
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Corporates/getDistrict'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#district_id').html(returndata);
            }
        });
    }


    function get_city_by_district(id) {
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Corporates/getCity'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#city_id').html(returndata);
            }
        });
    }



    function get_zone_by_city(id) {
        //alert(id); return false;
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Corporates/getZone'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#zone_id').html(returndata);
            }
        });
    }

    function get_area_by_zone(id) {
        // alert(id); return false;
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Corporates/getArea'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#area_id').html(returndata);
            }
        });
    }


    function get_mla(id) {
        //if(id=='Ward Member'){

        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Corporates/getMLA'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#corporate_id').html(returndata);
            }
        });

        //}
    }

    function get_branch_by_dept(id) {
        // alert(id); return false;
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Corporates/getBranch'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#branch_id').html(returndata);
            }
        });
    }


  function only_number(event)
      {
        var x = event.which || event.keyCode;
        console.log(x);
        if((x >= 48 ) && (x <= 57 ) || x == 8 | x == 9 || x == 13 )
        {
          return;
        }else{
          event.preventDefault();
        }    
      }
</script>

<script>
 $(document).ready(function(){

    getData();

    $('#role').on('change', function() {
      getData();
    });


function getData() {
  var role = $("#role").val().trim(); 
  
  if ( role == 'Ward Member')
      {
        $("#mla").show();
        $("#department").hide();
        $("#branch").hide();
      }
      else if(role == 'Employees')
      {
        $("#department").show();
        $("#branch").show();
        $("#mla").hide();
      }
      else
      {
        $("#mla").hide();
        $("#department").hide();
        $("#branch").hide();
      }
}

});
</script>

<script>
  setTimeout(function(){$(".errmsg").fadeOut("&nbsp");},3000)
</script>