<?php $this->load->view('common/header'); ?>
<?php $this->load->view('common/left_panel'); ?>
<?php echo $breadcrumbs; ?>
<div class="page-content-wrap">
  <div class="row">
    <div class="col-md-12">
      <form class="form-horizontal" method="post" action="<?php echo $action; ?>" enctype="multipart/form-data">
        <div class="panel panel-default">
          <div class="panel-heading">
            <h3 class="panel-title"><strong><?php echo $heading; ?></strong></h3>
            <ul class="panel-controls">
              <li><a href="<?= $cancelbtn;?>"><span class="fa fa-arrow-left"></span></a></li>
            </ul>
          </div>
          <div class="panel-body">   
            <div class="col-md-12">
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Country <span style="color:red;">*</span><span id="country_id_err"></span><span style="color:red;"><?php echo form_error('country_id'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="country_id" id="country_id" onchange="get_state_by_country(this.value)">
                      <option value="">Select Country</option>
                      <?php foreach($countries as $country){?>
                        <option value="<?= $country->id; ?>" <?php if($country->id==$country_id)echo "selected";; ?>><?= $country->country_name; ?></option>
                      <?php } ?>
                    </select>
                  </div> 
                </div>
                <div class="form-group">
                  <label class="col-md-12">District <span style="color:red;">*</span><span id="district_id_err"></span><span style="color:red;"><?php echo form_error('district_id'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="district_id" id="district_id">
                      <option value="">Select District</option>
                      <?php if($button=='Update') {  foreach ($districts as $district) { ?>
                        <option value="<?= $district->id; ?>" <?php if($district->id==$district_id)echo "selected";; ?>><?= $district->district_name; ?></option>
                      <?php } } ?> 
                    </select>
                  </div> 
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">State <span style="color:red;">*</span><span id="state_id_err"></span><span class="text-danger errmsg"><?php echo form_error('state_id'); ?></span> </label>
                  <div class="col-md-10">
                    <select class="form-control" name="state_id" id="state_id" onchange="get_district_by_state(this.value)">
                      <option value="">Select state</option>
                      <?php if($button=='Update') {  foreach ($states as $state) { ?>
                        <option value="<?= $state->id; ?>" <?php if($state->id==$state_id)echo "selected";; ?>><?= $state->state_name; ?></option>
                      <?php } } ?>  
                    </select>
                  </div> 
                </div>
                <div class="form-group">
                  <label class="col-md-12">City Name <span style="color:red;">*</span><span id="city_name_err"></span><span class="text-danger errmsg"><?php echo form_error('city_name'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="city_name" id="city_name" placeholder="Enter City Name" value="<?php echo $city_name; ?>" />
                  </div> 
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">City Name (Marathi)</label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="city_name_marathi" id="city_name_marathi" placeholder="Enter city name in marathi" value="<?php echo $city_name_marathi; ?>" />
                  </div> 
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">City Name (Hindi)</label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="city_name_hindi" id="city_name_hindi" placeholder="Enter city name in hindi" value="<?php echo $city_name_hindi; ?>" />
                  </div> 
                </div>
              </div>
              <input type="hidden" name="id" value="<?php echo $id;?>">
            </div>
          </div>
          <div class="panel-footer">
            <button class="btn btn-success" type="submit" id="submit" value="<?= $button;?>" onclick="return validation();"><?= $button;?></button>
            <a href="<?= $cancelbtn ?>"  class="btn btn-danger">Cancel</a>
          </div>
        </div>
      </form>
    </div>
  </div>                    
</div>
<?php $this->load->view('common/footer'); ?>
<script type="text/javascript">
  function validation()
  {
    var country_id = $("#country_id").val().trim(); 
    var state_id = $("#state_id").val().trim(); 
    var district_id = $("#district_id").val().trim(); 
    var city_name = $("#city_name").val().trim();

    if(country_id=='')
    {
      $("#country_id_err").fadeIn().html("Please select country").css('color',"red");
      setTimeout(function(){$("#country_id_err").fadeOut("&nbsp");},3000)
      $("#country_id").focus();
      return false;
    } 
    if(state_id=='')
    {
      $("#state_id_err").fadeIn().html("Please select state").css('color',"red");
      setTimeout(function(){$("#state_id_err").fadeOut("&nbsp");},3000)
      $("#state_id").focus();
      return false;
    } 
    if(district_id=='')
    {
      $("#district_id_err").fadeIn().html("Please select district").css('color',"red");
      setTimeout(function(){$("#district_id_err").fadeOut("&nbsp");},3000)
      $("#district_id").focus();
      return false;
    }  
    if(city_name=='')
    {
      $("#city_name_err").fadeIn().html("Please enter city").css('color',"red");
      setTimeout(function(){$("#city_name_err").fadeOut("&nbsp");},3000)
      $("#city_name").focus();
      return false;
    }         
  }
  function get_state_by_country(id)
  { 
    var datastring = "id="+id;
    $.ajax({
      type:"post",
      url:"<?php echo site_url('Cities/getState'); ?>",
      data:datastring,
      success:function(returndata)
      { 
        $('#state_id').html(returndata).selectpicker('refresh');
      }
    });
  }
  function get_district_by_state(id)
  { 
    var datastring = "id="+id;
    $.ajax({
      type:"post",
      url:"<?php echo site_url('Cities/getDistrict'); ?>",
      data:datastring,
      success:function(returndata)
      { 
        $('#district_id').html(returndata).selectpicker('refresh');
      }
    });
  }
</script>

<script>
      setTimeout(function(){$(".errmsg").fadeOut();},3000)
</script>