<?php $this->load->view('common/header'); ?>
<?php $this->load->view('common/left_panel'); ?>
<style>
  .pac-container {
    z-index: 9999;
  }
</style>

<?= $breadcrumbs; ?>
<div class="page-content-wrap">
  <div class="row">
    <div class="col-md-12">
      <form class="form-horizontal" method="post" action="<?= $action; ?>" enctype="multipart/form-data">
        <div class="panel panel-default">
          <div class="panel-heading">
            <h3 class="panel-title"><strong><?= $heading; ?></strong></h3>
            <ul class="panel-controls">
              <li><a href="<?= $cancelbtn;?>"><span class="fa fa-arrow-left"></span></a></li>
            </ul>
          </div>

          <div class="panel-body">   
            <div class="col-md-12">

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Department <span class="text-danger">*</span><span class="text-danger" id="department_nameError"></span><span class="text-danger errmsg"><?= form_error('department_id'); ?></span></label>
                  <div class="col-md-10">
                    <select class="form-control" name="department_id" id="department_id">
                      <option value="">Select Department</option>
                      <?php foreach($departments as $dept){?>
                        <option value="<?= $dept->id; ?>" <?php if($dept->id==$department_id)echo "selected";; ?>><?= $dept->department_name; ?></option>
                      <?php } ?>
                    </select>
                  </div> 
                </div>
              </div>
              <div class="col-md-6">

                <div class="form-group">
                  <label class="col-md-12">Branch Name <span class="text-danger">*</span> <span class="text-danger" id="err_branch_name"></span><span class="text-danger errmsg"> <?= form_error('branch_name'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="branch_name" id="branch_name" placeholder="Enter branch name" value="<?= $branch_name; ?>" />
                  </div>
                </div>

              </div>

              <div class="col-md-6">

                <div class="form-group">
                  <label class="col-md-12">Branch Name (Marathi)<span class="text-danger"></span> <span class="text-danger" id=""></span><span class="text-danger errmsg"></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="branch_name_marathi" id="branch_name_marathi" placeholder="Enter branch name in marathi" value="<?= $branch_name_marathi; ?>" />
                  </div>
                </div>

              </div>

              <div class="col-md-6">

                <div class="form-group">
                  <label class="col-md-12">Branch Name (Hindi)<span class="text-danger"></span> <span class="text-danger" id=""></span><span class="text-danger errmsg"></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="branch_name_hindi" id="branch_name_hindi" placeholder="Enter branch name in hindi" value="<?= $branch_name_hindi; ?>" />
                  </div>
                </div>

              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Zone <span class="text-danger">*</span><span class="text-danger" id="zone_id_err"></span><span class="text-danger errmsg"><?= form_error('zone_id'); ?></span></label>
                  <div class="col-md-10">
                    <select class="form-control" name="zone_id" id="zone_id" onchange="get_area_by_zone(this.value)">
                      <option value="">Select Zone</option>
                      <?php foreach($zones as $row){?>
                        <option value="<?= $row->id; ?>" <?php if($row->id==$zone_id)echo "selected";; ?>><?= $row->zone_name; ?></option>
                      <?php } ?>
                    </select>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Area <span class="text-danger">*</span><span class="text-danger" id="area_id_err"></span><span class="text-danger errmsg"><?= form_error('area_id'); ?></span></label>
                  <div class="col-md-10">
                    <select class="form-control" name="area_id" id="area_id">
                      <option value="">Select Area</option>
                      <?php foreach($areas as $row){?>
                        <option value="<?= $row->id; ?>" <?php if($row->id==$area_id)echo "selected";; ?>><?= $row->area; ?></option>
                      <?php } ?>
                    </select>
                  </div> 
                </div>
              </div>

                <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Address <span class="text-danger">*</span><span class="text-danger" id="err_address"></span><span class="text-danger errmsg"><?= form_error('address'); ?></span></label>
                  <div class="col-md-10">
                    <textarea name="address" id="address" class="form-control" placeholder="Enter address"><?php echo $address?></textarea>
                    <input type="hidden" name="lat" id="lat">
                    <input type="hidden" name="lon" id="lon">
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Address (Marathi)<span class="text-danger"></span><span class="text-danger" id=""></span></label>
                  <div class="col-md-10">
                    <textarea name="address_marathi" id="address_marathi" class="form-control" placeholder="Enter address in marathi"><?php echo $address_marathi?></textarea>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Address (Hindi)<span class="text-danger"></span><span class="text-danger" id=""></span><span class="text-danger errmsg"></label>
                  <div class="col-md-10">
                    <textarea name="address_hindi" id="address_hindi" class="form-control" placeholder="Enter address in hindi"><?php echo $address_hindi?></textarea>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Description <span class="text-danger">*</span><span class="text-danger" id="err_description"></span><span class="text-danger errmsg"><?= form_error('description'); ?></span></label>
                  <div class="col-md-10">
                    <textarea name="description" id="description" class="form-control" placeholder="Enter description"><?php echo $description?></textarea>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Description (Marathi)</label>
                  <div class="col-md-10">
                    <textarea name="description_marathi" id="description_marathi" class="form-control" placeholder="Enter description in marathi"><?php echo $description_marathi?></textarea>
                  </div> 
                </div>
              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Description (Hindi)</label>
                  <div class="col-md-10">
                    <textarea name="description_hindi" id="description_hindi" class="form-control" placeholder="Enter description in hindi"><?php echo $description_hindi?></textarea>
                  </div> 
                </div>
              </div>

               <div class="col-md-6">
                   <div class="form-group">
                    <label class="col-md-12">Image <span style="color:red;"></span><span id="error_image" style="color:red;"></span> </label>
                    <div class="col-md-10">
                     <input type="file" class="form-control" name="image" id="image" title="Browse file"/>
                     <span class="">Please select image type jpg,png,jpeg </span>
                     <?php if($button!='Create'){ if(!empty($image)) {?>
                      <br>
                      <img src="<?php echo base_url('uploads/branches/'.$image); ?>" style="width:100px;">
                      <input type="hidden" name="old_image" value="<?php echo $image; ?>">
                    <?php } }?>
                  </div> 
                </div> 
              </div>

              <input type="hidden" name="id" value="<?= $id;?>">
            </div>
          </div>

          <div class="panel-footer">
            <button class="btn btn-success" type="submit" id="submit" value="<?= $button;?>" onclick="return saveData();"><?= $button;?></button>
            <a href="<?= $cancelbtn ?>"  class="btn btn-danger">Cancel</a>
          </div>
        </div>
      </form>
    </div>
  </div>                    
</div>
<?php $this->load->view('common/footer'); ?>

<script type="text/javascript">

  function saveData()
  {
    var department_id = $("#department_id").val();
    //var branch_emp_id = $("#branch_emp_id").val();
    var description = $("#description").val();
    var branch_name = $("#branch_name").val().trim();
    var branch_name_marathi = $("#branch_name_marathi").val().trim();
    var branch_name_hindi = $("#branch_name_hindi").val().trim();
    var zone_id = $("#zone_id").val().trim();
    var area_id = $("#area_id").val().trim();
    var pattern_branch_name = /^[a-zA-Z ]{2,30}$/;
    var address = $("#address").val().trim();
    var address_marathi = $("#address_marathi").val().trim();
    var address_hindi = $("#address_hindi").val().trim();
    var lat = $("#lat").val();
    var lon = $("#lon").val();
    
    if(department_id=='' || department_id==null)
    {
      $("#department_nameError").fadeIn().html("Please select department name");
      setTimeout(function(){$("#department_nameError").fadeOut();},4000);
      $("#department_name").focus();
      return false;
    }

    if(branch_name == "")
    {
      $("#err_branch_name").fadeIn().html("Please enter branch name");
      setTimeout(function(){$("#err_branch_name").fadeOut();},4000);
      $("#branch_name").focus();
      return false;
    }
    else if (!pattern_branch_name.test(branch_name)) 
    {
      $("#err_branch_name").fadeIn().html("Please enter branch name").css('color', "red");
      setTimeout(function() {
          $("#err_branch_name").fadeOut();
      }, 3000)
      $("#branch_name").focus();
      return false;
    } 
      
    if(zone_id == "" || zone_id==null)
    {
      $("#zone_id_err").fadeIn().html("Please select zone");
      setTimeout(function(){$("#zone_id_err").fadeOut();},4000);
      $("#zone_id").focus();
      return false;
    }  

    if(area_id == "" || area_id==null)
    {
      $("#area_id_err").fadeIn().html("Please select area");
      setTimeout(function(){$("#area_id_err").fadeOut();},4000);
      $("#area_id").focus();
      return false;
    }  

    if(address == "")
    {
      $("#err_address").fadeIn().html("Please enter address");
      setTimeout(function(){$("#err_address").fadeOut();},4000);
      $("#address").focus();
      return false;
    }

    if(description == "")
    {
      $("#err_description").fadeIn().html("Please enter description");
      setTimeout(function(){$("#err_description").fadeOut();},4000);
      $("#description").focus();
      return false;
    }
  }

  function get_area_by_zone(id) {
        var datastring = "id=" + id;
        $.ajax({
            type: "post",
            url: "<?php echo site_url('Branches/getArea'); ?>",
            data: datastring,
            success: function(returndata) {
                $('#area_id').html(returndata);
            }
        });
    }
</script>

<script async defer src="https://maps.googleapis.com/maps/api/js?v=3&key=AIzaSyAvHHoPKPwRFui0undeEUrz00-8w6qFtik&libraries=places&callback=initialize"
  type="text/javascript">
</script>

<script>

  /* for google locations autocomplete */
  function initialize() 
  {
  //alert('hie'); return false;
  var input = document.getElementById('address');
  autocomplete = new google.maps.places.Autocomplete(input);
  google.maps.event.addListener(autocomplete, 'place_changed', function() 
  {
    var place = autocomplete.getPlace();
     // alert (); 
     var lat = place.geometry.location.lat();
     var lng = place.geometry.location.lng();
     $("#lat").val(lat);
     $("#lon").val(lng);
     initMap();
     if (!place.geometry) {
            //try a basic geocode
            searchlocation(place.name);
            return;
          }



        });
    // Set initial restrict to the greater list of countries.
    autocomplete.setComponentRestrictions(
      {'country': ['in']});

    function setupClickListener(id, countries) {
      var radioButton = document.getElementById(id);
      radioButton.addEventListener('click', function() {
        autocomplete.setComponentRestrictions({'country': countries});
      });
    }

  }
  initialize();
  function initMap() 
  {
    var lat = parseFloat(document.getElementById('lat').value);
    var lng = parseFloat(document.getElementById('lon').value);

    var map = new google.maps.Map(document.getElementById('map'), {
      center: {
        lat: lat,
        lng: lng
      },
      zoom: 13,
      mapTypeId: 'roadmap'
    });
    var latlng = new google.maps.LatLng(lat,lng);
    var marker = new google.maps.Marker({
      map: map,
      position: latlng,
      draggable: true,
      
    });

    google.maps.event.addListener(marker, 'dragend', function (event) {
      document.getElementById("lat").value = this.getPosition().lat();
      document.getElementById("lon").value = this.getPosition().lng();
      getAddress();
    });
  }
  function getAddress()
  {
   var lat=$("#lat").val();
   var lon=$("#lon").val();

   $.ajax({
    type:"post",
    cache:false,
    url:"<?php echo site_url(); ?>/Branches/getAddress",
    data:{lat:lat,lon:lon},
    beforeSend:function(){},
    success:function(returndata)
    {   
      var obj=jQuery.parseJSON(returndata);
      $("#address").val(obj.address);
    }
  });
 }
</script>

<script>
  setTimeout(function(){$(".errmsg").fadeOut();},2000);
</script>