<?php $this->load->view('common/header'); ?>
<?php $this->load->view('common/left_panel'); ?>
<style>
  .pac-container {
    z-index: 9999;
  }
</style>

<?= $breadcrumbs; ?>
<div class="page-content-wrap">
  <div class="row">
    <div class="col-md-12">
      <form class="form-horizontal" method="post" action="<?= $action; ?>" enctype="multipart/form-data">
        <div class="panel panel-default">
          <div class="panel-heading">
            <h3 class="panel-title"><strong><?= $heading; ?></strong></h3>
            <ul class="panel-controls">
              <li><a href="<?= $cancelbtn;?>"><span class="fa fa-arrow-left"></span></a></li>
            </ul>
          </div>

          <div class="panel-body">   
            <div class="col-md-12">

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Department <span class="text-danger">*</span><span class="text-danger" id="department_nameError"></span><span class="text-danger errmsg"><?= form_error('department_id'); ?></span></label>
                  <div class="col-md-10">
                    <select class="form-control" name="department_id" id="department_id">
                      <option value="">Select Department</option>
                      <?php foreach($departments as $dept){?>
                        <option value="<?= $dept->id; ?>" <?php if($dept->id==$department_id)echo "selected";; ?>><?= $dept->department_name; ?></option>
                      <?php } ?>
                    </select>
                  </div> 
                </div>
              </div>
              <div class="col-md-6">

                <div class="form-group">
                  <label class="col-md-12">Branch Name <span class="text-danger">*</span> <span class="text-danger" id="err_branch_name"></span><span class="text-danger errmsg"> <?= form_error('branch_name'); ?></span></label>
                  <div class="col-md-10">
                    <input type="text" class="form-control" name="branch_name" id="branch_name" placeholder="Enter branch name" value="<?= $branch_name; ?>" />
                  </div>
                </div>

              </div>

              <div class="col-md-6">
                <div class="form-group">
                  <label class="col-md-12">Branch Head <span class="text-danger">*</span><span class="text-danger" id="branch_emp_id_err"></span><span class="text-danger errmsg"><?= form_error('branch_emp_id'); ?></span></label>
                  <div class="col-md-10">
                    <select class="form-control" name="branch_emp_id" id="branch_emp_id">
                      <option value="">Select Branch Head</option>
                      <?php foreach($corporates as $row){?>
                        <option value="<?= $row->id; ?>" <?php if($row->id==$branch_emp_id)echo "selected"; ?>><?= $row->name; ?></option>
                      <?php } ?>
                    </select>
                  </div> 
                </div>
              </div>

              <input type="hidden" name="id" value="<?= $id;?>">
            </div>
          </div>

          <div class="panel-footer">
            <button class="btn btn-success" type="submit" id="submit" value="<?= $button;?>" onclick="return saveData();"><?= $button;?></button>
            <a href="<?= $cancelbtn ?>"  class="btn btn-danger">Cancel</a>
          </div>
        </div>
      </form>
    </div>
  </div>                    
</div>
<?php $this->load->view('common/footer'); ?>

<script type="text/javascript">

  function saveData()
  {
    var department_id = $("#department_id").val();
    var branch_name = $("#branch_name").val().trim();
    var branch_emp_id = $("#branch_emp_id").val();
    // alert(branch_emp_id); return false;
    var pattern_branch_name = /^[a-zA-Z ]{2,30}$/;
    
    if(department_id=='' || department_id==null)
    {
      $("#department_nameError").fadeIn().html("Please select department name");
      setTimeout(function(){$("#department_nameError").fadeOut();},4000);
      $("#department_name").focus();
      return false;
    }

    if(branch_name == "")
    {
      $("#err_branch_name").fadeIn().html("Please enter branch name");
      setTimeout(function(){$("#err_branch_name").fadeOut();},4000);
      $("#branch_name").focus();
      return false;
    }
    else if (!pattern_branch_name.test(branch_name)) 
    {
      $("#err_branch_name").fadeIn().html("Please enter branch name").css('color', "red");
      setTimeout(function() {
          $("#err_branch_name").fadeOut();
      }, 3000)
      $("#branch_name").focus();
      return false;
    } 

    if(branch_emp_id == "" || branch_emp_id==null)
    {
      $("#branch_emp_id_err").fadeIn().html("Please select branch head");
      setTimeout(function(){$("#branch_emp_id_err").fadeOut();},4000);
      $("#branch_emp_id").focus();
      return false;
    }  
  }
</script>

<script async defer src="https://maps.googleapis.com/maps/api/js?v=3&key=AIzaSyAvHHoPKPwRFui0undeEUrz00-8w6qFtik&libraries=places&callback=initialize"
  type="text/javascript">
</script>

<script>
  setTimeout(function(){$(".errmsg").fadeOut();},2000);
</script>