<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Roles_and_responsibilities_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    var $column_order = array(null,'mr.title','crm.responsibility',null,null); //set column field database for datatable orderable
    var $column_search = array('mr.title','crm.responsibility'); //set column field database for datatable searchable
    var $order = array('rr.id' => 'DESC'); // default order
 
    private function _get_datatables_query()
    {
        $this->db->select("rr.*, crm.responsibility, mr.title");
        $this->db->from("roles_and_responsibilities rr");
        $this->db->join("mst_roles mr", "rr.role_id=mr.id",'INNER');
        $this->db->join("corporate_responsibilities_mapping crm", "crm.roles_respo_id=rr.id",'INNER');
        $this->db->where("rr.is_delete='No'");
        $this->db->group_by('rr.id'); 
 
        $i = 0;

        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (mr.title LIKE '%".$show_string."%' ";
            $cond.=" OR crm.responsibility LIKE '%".$show_string."%' ) ";
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
        $this->db->select("rr.*, crm.responsibility, mr.title");
        $this->db->from("roles_and_responsibilities rr");
        $this->db->join("mst_roles mr", "rr.role_id=mr.id",'INNER');
        $this->db->join("corporate_responsibilities_mapping crm", "crm.roles_respo_id=rr.id",'INNER');
        $this->db->where("rr.is_delete='No'");
        $this->db->group_by('rr.id'); 
        return $this->db->count_all_results();
    }

    function getDistinctData() 
    {
        $this->db->distinct();

        $this->db->select('role');

        $this->db->where('status="Active" and is_delete="No"'); 

        $query = $this->db->get('corporates');

        return $query->result();

    }

    function viewRolesAndResponsibility($cond)
    {    

        /*$this->db->select("rr.*, crm.responsibility");
        $this->db->from("roles_and_responsibilities rr");
        $this->db->join("corporate_responsibilities_mapping crm", "crm.roles_respo_id=rr.id",'left');
        $this->db->where("rr.$cond && rr.is_delete='No'");
        return $this->db->get()->result();*/

        $this->db->select("rr.*, crm.responsibility");
        $this->db->from("roles_and_responsibilities rr");
        $this->db->join("corporate_responsibilities_mapping crm", "crm.roles_respo_id=rr.id",'left');
        $this->db->where("rr.is_delete='No' and rr.id='".$cond."'");
        // $this->db->group_by('rr.id'); 
        return $this->db->get()->result();
    }

    public function getResponsibilities($cond){
        $this->db->select("crm.*, rr.role_id");
        $this->db->from("corporate_responsibilities_mapping crm");       
        $this->db->join("roles_and_responsibilities rr","rr.id=crm.roles_respo_id","left");
        $this->db->where("crm.is_delete='No' and crm.roles_respo_id='".$cond."'");
        $query = $this->db->get();
        return $query->result();
        
    }
     
}