<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Police_Station_Head_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    var $column_order = array(null,'mpha.higher_authority_name','mps.name','hps.station_head_name','c.country_name','s.state_name','d.district_name','city.city_name',null,null,null,null); //set column field database for datatable orderable
    var $column_search = array('mpha.higher_authority_name','mps.name','hps.station_head_name','c.country_name','s.state_name','d.district_name','city.city_name','hps.address','hps.pincode'); //set column field database for datatable searchable
    var $order = array('hps.id' => 'DESC'); // default order
 
    private function _get_datatables_query()
    {
       
            $this->db->select("hps.*,mpha.higher_authority_name,mps.name,c.country_name, s.state_name, d.district_name, city.city_name");
            $this->db->from("head_of_police_stations hps");
             $this->db->join("mst_countries c", 'hps.country_id = c.id', 'left');
               $this->db->join("mst_states s", 'hps.state_id = s.id', 'left');
               $this->db->join("mst_districts d", 'hps.district_id = d.id', 'left');
               $this->db->join("mst_cities city", 'hps.city_id = city.id', 'left');
            $this->db->join("mst_police_higher_authorities mpha",'mpha.id=hps.higher_authority_id','left');
            $this->db->join("mst_police_stations mps",'mps.id=hps.police_station_id','left');
            $this->db->where("hps.is_delete='No'");
        
       
 
        $i = 0;

        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (mps.name LIKE '%".$show_string."%' ";
            $cond.=" OR mpha.higher_authority_name LIKE '%".$show_string."%' ";
            $cond.=" OR hps.name LIKE '%".$show_string."%' ";
            $cond.=" OR hps.email LIKE '%".$show_string."%' ";
            $cond.=" OR hps.mobile LIKE '%".$show_string."%' ";
            $cond.=" OR hps.station_head_name LIKE '%".$show_string."%' ";
            $cond.=" OR hps.address LIKE '%".$show_string."%' ";
            $cond.=" OR hps.pincode LIKE '%".$show_string."%' ";
             $cond.=" OR c.country_name LIKE '%".$show_string."%' ";
            $cond.=" OR s.state_name LIKE '%".$show_string."%' ";
            $cond.=" OR d.district_name LIKE '%".$show_string."%' ";
            $cond.=" OR city.city_name LIKE '%".$show_string."%' ) ";     
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
              $this->db->select("hps.*,mpha.higher_authority_name,mps.name,c.country_name, s.state_name, d.district_name, city.city_name");
            $this->db->from("head_of_police_stations hps");
             $this->db->join("mst_countries c", 'hps.country_id = c.id', 'left');
               $this->db->join("mst_states s", 'hps.state_id = s.id', 'left');
               $this->db->join("mst_districts d", 'hps.district_id = d.id', 'left');
               $this->db->join("mst_cities city", 'hps.city_id = city.id', 'left');
            $this->db->join("mst_police_higher_authorities mpha",'mpha.id=hps.higher_authority_id','left');
            $this->db->join("mst_police_stations mps",'mps.id=hps.police_station_id','left');
            $this->db->where("hps.is_delete='No'");
        
            return $this->db->count_all_results();
    }

      function viewDetails($cond)
    {    
          $this->db->select("hps.*,mpha.higher_authority_name,mps.name,c.country_name, s.state_name, d.district_name, city.city_name");
            $this->db->from("head_of_police_stations hps");
             $this->db->join("mst_countries c", 'hps.country_id = c.id', 'left');
               $this->db->join("mst_states s", 'hps.state_id = s.id', 'left');
               $this->db->join("mst_districts d", 'hps.district_id = d.id', 'left');
               $this->db->join("mst_cities city", 'hps.city_id = city.id', 'left');
            $this->db->join("mst_police_higher_authorities mpha",'mpha.id=hps.higher_authority_id','left');
            $this->db->join("mst_police_stations mps",'mps.id=hps.police_station_id','left');
            $this->db->where("hps.is_delete='No'");
        $this->db->where("hps.$cond && hps.is_delete='No'");
        return $this->db->get()->row();
    }
    
   



     
}