<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Crud_model extends CI_Model
{
  function __construct()
    {
        parent::__construct();
    }
  

  public function GetData($table,$field='',$condition='',$group='',$order='',$limit='',$result='')
    {
        if($field != '')
        $this->db->select($field);
        if($condition != '')
        $this->db->where($condition);
        if($order != '')
        $this->db->order_by($order);
        if($limit != '')
        $this->db->limit($limit);
        if($group != '')
        $this->db->group_by($group);
        if($result != '')
        {
            $return =  $this->db->get($table)->row();
        }else{
            $return =  $this->db->get($table)->result();
        }
        return $return;
    }

    public function GetDataArr($table,$field='',$condition='',$group='',$order='',$limit='',$result='')
    {
        if($field != '')
        $this->db->select($field);
        if($condition != '')
        $this->db->where($condition);
        if($order != '')
        $this->db->order_by($order);
        if($limit != '')
        $this->db->limit($limit);
        if($group != '')
        $this->db->group_by($group);
        if($result != '')
        {
            $return =  $this->db->get($table)->row_array();
        }else{
            $return =  $this->db->get($table)->result_array();
        }
        return $return;
    }

  public function SaveData($table,$data,$condition='')
    {
      $DataArray = array();
        if(!empty($data))
        {
          if($condition == '')
          {
            $data['created']=date("Y-m-d H:i:s");
          }
          else
          {
             $data['modified']=date("Y-m-d H:i:s");
          }
           
        }
        $table_fields = $this->db->list_fields($table);
        foreach($data as $field=>$value)
        {
            if(in_array($field,$table_fields))
            {
                $DataArray[$field]= $value;
            }
        }
       
        if($condition != '')
      {
        $this->db->where($condition);
        $this->db->update($table, $DataArray);
      }else{
        $this->db->insert($table, $DataArray);
      }
    }

    public function DeleteData($table,$condition='',$limit='')
    {
       if($condition != '')
        $this->db->where($condition);
        if($limit != '')
        $this->db->limit($limit);
        $this->db->delete($table);
    }

   public function getCity()
   {
          $this->db->select('s.*,c.city_name');
          $this->db->from('shops s');
          $this->db->join('cities c','s.city_id=c.id','INNER');
          //$this->db->where($con);
            $this->db->group_by('city_name');
          $query = $this->db->get();
           return $query->result(); 
   }
    public function get_locationfind($con,$latitude,$longitude,$hav)
    {
        
        $this->db->select("s.*,ROUND(( 3959 * acos( cos( radians('".$latitude."') ) * cos( radians( s.latitude ) ) * cos( radians(s.longitude )- radians('".$longitude."') ) + sin( radians('".$latitude."') ) * sin( radians( s.latitude ) ) ) ),2) as distance ");
        $this->db->from('shops s'); 
        $this->db->where($con);
        $this->db->having($hav);
        $this->db->limit("4");
        $query = $this->db->get();
        return $query->result(); 
    }
    public function getIpCity($con)
    {
        $this->db->select('ic.*,c.city_name');
        $this->db->from('ip_cities ic');
        $this->db->join('cities c','ic.city_id=c.id','left');
          $this->db->where($con);
        $query = $this->db->get();
        return $query->row(); 

    }
     public function topsearchCity($con)
   {
          $this->db->select('s.*,c.city_name');
          $this->db->from('shops s');
          $this->db->join('cities c','s.city_id=c.id','INNER');
          $this->db->where($con);
            $this->db->group_by('s.city_id');
          $query = $this->db->get();
           return $query->result(); 
   }

   public function getScheduleData($con)
   {
          $this->db->select('service_packages.*,master_categories.title as cat_name,master_services.name as ser_name,master_services.service_description as ser_desc');
          $this->db->from('service_packages');
          $this->db->join('master_services','master_services.id=service_packages.service_id','left');
          $this->db->join('master_services','master_services.id=service_packages.service_id','left');
          $this->db->where($con);
          $query = $this->db->get();
          return $query->row(); 
   }

   function GetDataCatSubcat($con)
   {
          $this->db->select('sub_categories.sub_cat_title,categories.title');
          $this->db->from('sub_categories');
          $this->db->join('categories','categories.id=sub_categories.category_id','left');
          $this->db->where($con);
          $this->db->order_by('sub_cat_title asc');
          $query = $this->db->get();
          return $query->result(); 
   }

   function GetAssets($cond)
   {
      $this->db->select('assets.*,mst_asset_types.type');
      $this->db->from('assets');
      $this->db->join('mst_asset_types','mst_asset_types.id=assets.asset_type_id','left');
      $this->db->where($cond);
      $this->db->order_by('id desc');
      $this->db->limit('5');
      $query = $this->db->get();
      return $query->result(); 
   }

   function GetBranchAssets($cond)
   {
      $this->db->select('abm.asset_id,abm.asset_quantity ,assets.*,mst_asset_types.type');
      $this->db->from('asset_branch_mappings as abm');
      $this->db->join('assets','assets.id=abm.asset_id','left');
      $this->db->join('mst_asset_types','mst_asset_types.id=assets.asset_type_id','left');
      $this->db->where($cond);
      $this->db->order_by('id desc');
      $this->db->limit('5');
      $query = $this->db->get();
      return $query->result(); 
   }

   function GetRoleAccess($cond)
   {
      $this->db->select('rm.module_name,r.menu_name,r.value');
      $this->db->from('ra_role_access ra');
      $this->db->join('ra_modules rm','rm.id=ra.ra_module_id','left');
      $this->db->join('ra_menus r','r.id=ra.ra_menu_id','left');
      $this->db->where($cond);
      $query = $this->db->get();
      return $query->result(); 
   }

   function Getassets_maintenance($con)
   {
      $this->db->select('assets_maintenance.*,mst_asset_types.type,asset_details.barcode_number,assets.asset_name,assets.photo');
      $this->db->from('assets_maintenance');
      $this->db->join('mst_asset_types','mst_asset_types.id=assets_maintenance.asset_type_id','left');
      $this->db->join('asset_details','asset_details.id=assets_maintenance.asset_details_id','left');
      $this->db->join('assets','assets.id=assets_maintenance.assets_id','left');
      $this->db->where($con);
      $this->db->order_by('id desc');
      $this->db->limit('5');
      $query = $this->db->get();
      return $query->result(); 
   }



    /*Get DashBord Asset Typewise Purchase Amount*/
    function getAssettypewiseCount($asset_type_id,$finyear){

        $this->db->select('pod.asset_type_id,group_concat(pod.id) as poids,sum(po.total_amount) as totalpurchaseAmount,(select sum(quantity) as totqty from purchase_order_details where asset_type_id = pod.asset_type_id and status="Received") as totalQty');
        $this->db->where("pod.asset_type_id='".$asset_type_id."' and po.status='Received' and po.financial_year_id='".$finyear."'");
        $this->db->join('purchase_orders po','po.id=pod.purchase_order_id','left');
        $this->db->group_by('pod.asset_type_id','pod.purchase_order_id');
        return $this->db->get('purchase_order_details pod')->row();
    }
    /*Get DashBord Asset Typewise Purchase Amount*/

    
   function getRolePermissions($cond)
   {
      $this->db->select('ra.*,rm.module_name,rm.id as ra_module_id,r.menu_name,r.value,rm.id');
      $this->db->from('ra_role_access ra');
      $this->db->join('ra_modules rm','rm.id=ra.ra_module_id','left');
      $this->db->join('ra_menus r','r.id=ra.ra_menu_id','left');
      $this->db->group_by('rm.module_name');
      $this->db->where($cond);
      $this->db->order_by('rm.id asc');
      $query = $this->db->get();
      return $query->result(); 
   }
   function getRolePermissionSubMenu($cond)
   {
      $this->db->select('ra.*,r.menu_name,r.value,rm.module_name,r.id');
      $this->db->from('ra_role_access ra');
      $this->db->join('ra_modules rm','rm.id=ra.ra_module_id','left');
      $this->db->join('ra_menus r','r.id=ra.ra_menu_id','left');
      $this->db->where($cond);
      $this->db->order_by('r.id asc');
      $query = $this->db->get();
      return $query->result(); 
   }

   /*Get DashBord Asset Typewise Purchase Amount*/
    public function aseets_request($con)
    {
       $this->db->select('ar.* ');
          $this->db->from('assets_request_details ard');
          $this->db->join('assets_requests ar','ard.asset_request_id=ar.id','left');
          $this->db->where($con);
          $this->db->group_by('ar.request_no');
         $query = $this->db->get();
          return $query->result(); 
    }
    public function branch_title()
    {
        $this->db->select('b.branch_title');
        $this->db->from('asset_branch_mappings_details ard');
        $this->db->join('branches b','ard.branch_id=b.id','left');
      //  $this->db->where($con);
        $query = $this->db->get();
        return $query->row(); 
    }

     function GetAssetsSearchBarcodeDetails($cond)
   {
      $this->db->select('c.title,sc.sub_cat_title,at.type,b.brand_name,a.id');
      $this->db->from('assets a');
      $this->db->join('categories c','c.id=a.category_id','left');
      $this->db->join('sub_categories sc','sc.id=a.subcategory_id','left');
      $this->db->join('mst_asset_types at','at.id=a.asset_type_id','left');
      $this->db->join('brands b','b.id=a.brand_id','left');
      $this->db->join('unit_types u','u.id=a.unit_id','left');
      $this->db->where($cond);
      $query = $this->db->get();
      return $query->row(); 
   }
    function GetSchedulingRemainder($cond)
   {
      $this->db->select('ams.*,mst_asset_types.type as asset_type,assets.asset_name,vendors.name,ams.schedule_frequency,assets.photo');
      $this->db->from('assets_maintenance_schedule ams');
      $this->db->join('assets', 'assets.id=ams.asset_id', 'left'); 
      $this->db->join('mst_asset_types', 'mst_asset_types.id=assets.asset_type_id', 'left'); 
     // $this->db->join('asset_details','asset_details.id=ams.asset_detail_id','left');
      $this->db->join('vendors','vendors.id=ams.vendor_id','left');
      $this->db->where($cond);
      $this->db->order_by("ams.id desc");
      $query = $this->db->get();
      return $query->result(); 
   }

   function getComplaintsData() {

      $this->db->select("c.*, n.message, n.type, n.is_read, n.id_type");
      $this->db->from("notifications n"); 
      $this->db->join("complaints c", "n.id_type=c.id", "INNER"); 
      $this->db->where("n.is_read='No'");
      $this->db->order_by("n.id DESC");
      $query = $this->db->get();
      return $query->result();

   }

   function getBranchesByDept() {

      $this->db->select("*");
      $this->db->from("mst_department_branches b"); 
      $this->db->join("mst_departments d", "d.id=b.department_id", "LEFT");
      $query = $this->db->get();
      return $query->result();

   }

   function getDeptComplaintStatus() {

      $this->db->select("department_name,
                COUNT(c.id) as total_complaints,
                COUNT(IF(complaint_status = 'Pending', 1, NULL)) 'Pending',
                COUNT(IF(complaint_status = 'Approved', 1, NULL)) 'Approved',
                COUNT(IF(complaint_status = 'Resolved', 1, NULL)) 'Resolved'");
      $this->db->from("complaints c"); 
      $this->db->join("mst_departments d", "d.id=c.department_id", "INNER");
      $this->db->group_by('department_id');
      $query = $this->db->get();
      return $query->result();
   }

   function getAuthorityComplaintDetails() {

      $this->db->select("mdp.id, mdp.title,
                COUNT(c.id) as total_complaints,
                COUNT(IF(complaint_status = 'Pending', 1, NULL)) 'Pending',
                COUNT(IF(complaint_status = 'Approved', 1, NULL)) 'Approved',
                COUNT(IF(complaint_status = 'Resolved', 1, NULL)) 'Resolved'");
      $this->db->from("complaints c"); 
      $this->db->join("mst_departments d", "d.id=c.department_id", "INNER");
      $this->db->join("mst_departments_parent mdp", "mdp.id=d.parent_id", "INNER");
      $this->db->group_by('d.parent_id');
      $query = $this->db->get();
      return $query->result();
   }


    public function getCriminalsData($con) {

      $this->db->select("c.*, mps.name as police_station_name");
      $this->db->from("criminals c"); 
      $this->db->join("mst_police_stations mps", "mps.id=c.police_station_id", "LEFT");          
      $this->db->where('c.is_delete="No" and c.status="Active"');
      $this->db->where($con);
      $query = $this->db->get();
      return $query->result();

   }

   public function getCamerasData($con) {

      $this->db->select("mc.*, mps.name as police_station_name");
      $this->db->from("mst_cameras mc"); 
      $this->db->join("mst_police_stations mps", "mps.id=mc.police_station_id", "LEFT");      
      $this->db->where('mc.is_delete="No" and mc.status="Active"');
      $this->db->where($con);
      $query = $this->db->get();
      return $query->result();

   }

   public function getSensitiveAreasData($con) {

      $this->db->select("sa.*, mps.name as police_station_name");
      $this->db->from("sensitive_areas sa"); 
      $this->db->join("mst_police_stations mps", "mps.id=sa.police_station_id", "LEFT");
      $this->db->where('sa.is_delete="No" and sa.status="Active"');
      $this->db->where($con);
      $query = $this->db->get();
      return $query->result();

   }

   public function getBpatraksData($con){

      $this->db->select("b.*, mps.name as police_station_name");
      $this->db->from("bpatrak b"); 
      $this->db->join("mst_police_stations mps", "mps.id=b.police_station_id", "LEFT");
      // $this->db->where('mps.is_delete="No" and mps.status="Active"');
      $this->db->where($con);
      $query = $this->db->get();
      return $query->result();

   }

}

?>
