<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Corporates_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    var $column_order = array(null,'corp.name','c.country_name','s.state_name','mc.city_name','corp.address','corp.pincode','corp.role',null,null,null,null); //set column field database for datatable orderable
    var $column_search = array('corp.name','corp.email','corp.mobile','c.country_name','s.state_name','mc.city_name','corp.address','corp.pincode','corp.role'); //set column field database for datatable searchable
    var $order = array('corp.id' => 'DESC'); // default order
 
    private function _get_datatables_query($flag)
    {
        if($flag != "") 
        {

            $this->db->select("corp.*, c.country_name, s.state_name, mc.city_name");
            $this->db->from("corporates corp");
            $this->db->join("mst_countries c", 'corp.country_id = c.id', 'left');
            $this->db->join("mst_states s", 'corp.state_id = s.id', 'left');
            $this->db->join("mst_cities mc", 'mc.id = corp.city_id', 'left');
            $this->db->where("corp.is_delete='No' and role='".$flag."'");
        }
        else
        {
            $this->db->select("corp.*, c.country_name, s.state_name, mc.city_name");
            $this->db->from("corporates corp");
            $this->db->join("mst_countries c", 'corp.country_id = c.id', 'left');
            $this->db->join("mst_states s", 'corp.state_id = s.id', 'left');
            $this->db->join("mst_cities mc", 'mc.id = corp.city_id', 'left');
            $this->db->where("corp.is_delete='No'");
        }
 
        $i = 0;

        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (corp.name LIKE '%".$show_string."%' ";
            $cond.=" OR corp.email LIKE '%".$show_string."%' ";
            $cond.=" OR corp.mobile LIKE '%".$show_string."%' ";
            $cond.=" OR c.country_name LIKE '%".$show_string."%' ";
            $cond.=" OR s.state_name LIKE '%".$show_string."%' ";
            $cond.=" OR corp.address LIKE '%".$show_string."%' ";
            $cond.=" OR mc.city_name LIKE '%".$show_string."%' ";
            $cond.=" OR corp.pincode LIKE '%".$show_string."%' ";
            $cond.=" OR corp.role LIKE '%".$show_string."%' ) ";      
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($flag)
    {
        $this->_get_datatables_query($flag);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($flag)
    {
        $this->_get_datatables_query($flag);
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all($flag)
    {
       if($flag != "") 
        {

            $this->db->select("corp.*, c.country_name, s.state_name, mc.city_name");
            $this->db->from("corporates corp");
            $this->db->join("mst_countries c", 'corp.country_id = c.id', 'left');
            $this->db->join("mst_states s", 'corp.state_id = s.id', 'left');
            $this->db->join("mst_cities mc", 'mc.id = corp.city_id', 'left');
            $this->db->where("corp.is_delete='No' and role='".$flag."'");
        }
        else
        {
            $this->db->select("corp.*, c.country_name, s.state_name, mc.city_name");
            $this->db->from("corporates corp");
            $this->db->join("mst_countries c", 'corp.country_id = c.id', 'left');
            $this->db->join("mst_states s", 'corp.state_id = s.id', 'left');
            $this->db->join("mst_cities mc", 'mc.id = corp.city_id', 'left');
            $this->db->where("corp.is_delete='No'");
        }
        return $this->db->count_all_results();
    }
    
    function viewCorporateDetails($cond)
    {    
        $this->db->select("corp.*, c.country_name, s.state_name, city.city_name, d.district_name, a.area, z.zone_name, ci.name as citizen_name");
        $this->db->from("corporates corp");
        $this->db->join("mst_countries c", 'c.id=corp.country_id', 'left');
        $this->db->join("mst_states s", 's.id=corp.state_id', 'left');
        $this->db->join("mst_districts d", 'd.id=corp.district_id', 'left');
         $this->db->join("mst_cities city", 'city.id=corp.city_id', 'left');
         $this->db->join("mst_zones z", 'z.id=corp.zone_id', 'left');
         $this->db->join("mst_areas a", 'a.id=corp.area_id', 'left');
         $this->db->join("appointments app", 'app.corporate_id=corp.id', 'left');
         $this->db->join("citizens ci", 'ci.id=app.citizen_id', 'left');
        $this->db->where("corp.$cond && corp.is_delete='No'");
        return $this->db->get()->row();
    }

    function getCitizenAppointmentName($cond2)
    {    
    
        $this->db->select("app.*, c.name");
        $this->db->from("appointments app");
        $this->db->join("citizens c", 'c.id=app.citizen_id', 'left');
        $this->db->where("app.$cond2");
        return $this->db->get()->result();
    }

    function getComplaintDetails($cond2)
    {    
    
        $this->db->select("comp.*, corp.name as corporate_name, c.name as citizen_name");
        $this->db->from("complaints comp");
        $this->db->join("citizens c", 'c.id=comp.citizen_id', 'left');
        $this->db->join("corporates corp", 'corp.id=comp.corporate_id', 'left');
        $this->db->where("comp.$cond2");
        return $this->db->get()->result();
    }


     
}