<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Branches_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    //$table = 'b';
    var $column_order = array(null,'b.branch_name','dept.department_name','a.area','b.address','z.zone_name',null,null); //set column field database for datatable orderable
    var $column_search = array('b.branch_name','dept.department_name','a.area','b.address'); //set column field database for datatable searchable
    var $order = array('b.id' => 'DESC'); // default order
 
    private function _get_datatables_query()
    {
       $this->db->select("b.*, dept.department_name, z.zone_name, a.area");
       $this->db->from("mst_department_branches b");
       $this->db->join("mst_departments dept", 'dept.id = b.department_id', 'left');
       $this->db->join("mst_zones z", 'z.id = b.zone_id', 'left');
       $this->db->join("mst_areas a", 'a.id = b.area_id', 'left');
       $this->db->where("b.is_delete='No'");
 
        $i = 0;
    

        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (b.branch_name LIKE '%".$show_string."%' ";
            $cond.=" OR b.address LIKE '%".$show_string."%' ";   
            $cond.=" OR a.area LIKE '%".$show_string."%' ";   
            $cond.=" OR z.zone_name LIKE '%".$show_string."%' ";   
            $cond.=" OR dept.department_name LIKE '%".$show_string."%' ) ";   
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
       $this->db->select("b.*, dept.department_name, z.zone_name, a.area");
       $this->db->from("mst_department_branches b");
       $this->db->join("mst_departments dept", 'dept.id = b.department_id', 'left');
       $this->db->join("mst_zones z", 'z.id = b.zone_id', 'left');
       $this->db->join("mst_areas a", 'a.id = b.area_id', 'left');
       $this->db->where("b.is_delete='No'");
       return $this->db->count_all_results();
    }

    //SELECT All ROW DATA BY CONDITION WITH DYNAMIC TABLE NAME
    public function getAllData($tablename,$condition='',$order='')
    {
        if($condition !='')
        $this->db->where($condition);
        if($order !='')     
        $this->db->order_by($order);        
        return $this->db->get($tablename)->result();
    }

    function viewCompDetails($cond)
    {    
       // $this->db->select("comp.*,dep.department_name,dep.address,ci.name,ci.email,ci.mobile");
       // $this->db->from("complaints comp");
       // $this->db->join("mst_departments dep", 'dep.id = comp.dept_id', 'inner');
       // $this->db->join("bs ci", 'ci.id = comp.b_id', 'inner');
       // $this->db->where("comp.$cond && comp.is_delete='No'");
       //  $query = $this->db->get();
       //  return $query->row();

        $this->db->select("b.*, dept.department_name");
        $this->db->from("mst_department_branches b");
        $this->db->join("mst_departments dept", 'dept.id = b.department_id', 'inner');
        $this->db->where("b.$cond && b.is_delete='No'");
        return $this->db->get()->row();
    }

    function branchEmpHead() {
        $this->db->select("*");
       $this->db->from("corporates");
       $this->db->where('corporates.id NOT IN (SELECT branch_emp_id FROM mst_department_branches) and role="Employees"');
       return $this->db->get()->result();
    }

    function branchDetails($cond) {
        $this->db->select("b.*, d.department_name, z.zone_name, a.area");
        $this->db->from("mst_department_branches b");
        $this->db->join("mst_departments d", 'd.id = b.department_id', 'left');
        $this->db->join("mst_zones z", 'z.id = b.zone_id', 'left');
        $this->db->join("mst_areas a", 'a.id = b.area_id', 'left');
        $this->db->where("b.$cond && b.is_delete='No'");
        return $this->db->get()->row();
    }

    /*public function getNotAssignedHead()
    {
        $this->db->select('b.*');
        $this->db->from('mst_department_branches b');
        $this->db->where('b.branch_emp_id NOT IN (SELECT branch_id FROM corporates)');
        return $this->db->get()->result();
    }*/

    public function getNotAssignedHead()
    {
        $this->db->select('c.id,c.name');
        $this->db->from('corporates c');
        $this->db->where('role="Employees" AND is_delete="No" AND c.id NOT IN (SELECT branch_emp_id FROM mst_department_branches)');
        return $this->db->get()->result();
    }
    
    public function getDeptBranch($cond) 
    {
        $this->db->select("b.id, b.branch_name,
                COUNT(c.id) as total_complaints,
                COUNT(IF(complaint_status = 'Pending', 1, NULL)) 'Pending',
                COUNT(IF(complaint_status = 'Approved', 1, NULL)) 'Approved',
                COUNT(IF(complaint_status = 'Resolved', 1, NULL)) 'Resolved'");
        $this->db->from('mst_department_branches b');
        $this->db->join("mst_departments d", "d.id=b.department_id", "INNER");
        $this->db->join("complaints c", "c.branch_id=b.id", "INNER");
        $this->db->where("b.is_delete='No' and b.department_id='".$cond."'");
        $this->db->group_by('b.id');
        return $this->db->get()->result();
    }
     
}