<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Assigned_station_task_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    var $column_order = array(null,'pa.name','p.police_name',null,null,null,null); //set column field database for datatable orderable
    var $column_search = array('pa.name','p.police_name'); //set column field database for datatable searchable
    var $order = array('pam.id' => 'DESC'); // default order
 
    private function _get_datatables_query()
    {
       
            $this->db->select("psam.*,p.police_name,pa.name");
            $this->db->from("police_station_activity_map psam");
            $this->db->join("police_activity_map pam",'psam.id=pam.police_station_activity_map_id','left');          
            $this->db->join("police_activities pa",'pa.id=psam.activity_id','left');       
             $this->db->join("mst_police p",'p.id=pam.police_id','left'); 
             $this->db->group_by("psam.activity_id"); 
            $this->db->where("pam.is_delete='No'");
        
       
 
        $i = 0;

        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (pa.name LIKE '%".$show_string."%' ";
           
            $cond.=" OR p.police_name LIKE '%".$show_string."%') ";      
             
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
           
          $this->db->select("pam.*,p.police_name,pa.name");
            $this->db->from("police_activity_map pam");
            $this->db->join("police_station_activity_map psam",'psam.id=pam.police_station_activity_map_id','left');          
            $this->db->join("police_activities pa",'pa.id=psam.activity_id','left');       
             $this->db->join("mst_police p",'p.id=pam.police_id','left'); 
            $this->db->where("pam.is_delete='No'");
        
            return $this->db->count_all_results();
    }

   
    function GetActivityDetails($cond)
    {
        $this->db->select('psam.*,pa.*');
        $this->db->from('police_station_activity_map psam');
        $this->db->join('police_activities pa',"psam.activity_id=pa.id",'left');
       

        $this->db->where($cond);
        return $this->db->get()->result();
    }

    function viewPolicetaskDetails($cond)
    {    
        $this->db->select('psam.*,psam.id as psamId,a.id as areaId,a.area,z.id as zoneId,z.zone_name,mps.id as psId,mps.name as psname,mps.address as psaddress,hps.id,p.police_name');
        $this->db->from('police_station_activity_map psam');
        $this->db->join("mst_areas a", 'a.id=psam.area_id','left');
        $this->db->join("mst_zones z",'z.id=psam.zone_id','left');
        $this->db->join("mst_police p",'p.police_station_id=psam.police_station_id','left');
        $this->db->join("mst_police_stations mps", 'mps.id=psam.police_station_id','left');
        $this->db->join("police_activities pa",'pa.id=psam.activity_id', 'left');
        $this->db->join("mst_police_higher_authorities mpha", 'mpha.id=psam.higher_authority_id', 'left');
        $this->db->join("head_of_police_stations hps", 'hps.id=psam.police_station_head_id', 'left');
        $this->db->where($cond);
        return $this->db->get()->row();
    }
    function viewPoliceactivityDetails($cond)
    {    
        $this->db->select('psam.*,pa.name as paname');
        $this->db->from('police_station_activity_map psam');       
        $this->db->join("police_activities pa",'pa.id=psam.activity_id', 'left');
         $this->db->where("psam.id NOT IN (SELECT police_station_activity_map_id FROM police_task_completion)");      
        $this->db->where($cond);
        return $this->db->get()->result();
    }

    public function GetPoliceActivityMapData($cond){
        $this->db->select('pam.*,p.police_name');
        $this->db->from('police_activity_map pam');       
        $this->db->join("mst_police p",'p.id=pam.police_id', 'left');      
        $this->db->where($cond);
        return $this->db->get()->result();
    }

   /* $this->db->select("admins.*, c.country_name, s.state_name, d.district_name, city.city_name,mz.zone_name,msa.area");
       $this->db->from("mst_police_stations admins");
       $this->db->join("mst_countries c", 'admins.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'admins.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'admins.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'admins.city_id = city.id', 'left');
       $this->db->join("mst_zones mz", 'mz.id = admins.zone_id', 'left');
       $this->db->join("mst_areas msa", 'msa.id = admins.area_id', 'left');
       $this->db->where("admins.is_delete='No'");
     */
}