<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Zones_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*-------------------------GETTTING CITIES DATA SERVER SIDE MODEL CODE----------------*/
     var $column_order = array(null,'c.city_name','ct.country_name','st.state_name','d.district_name','z.zone_name',null,null); //set column field database for datatable orderable
     var $column_search = array('c.city_name','ct.country_name','st.state_name','d.district_name','z.zone_name'); //set column field database for datatable searchable
     var $order = array('z.id' => 'DESC'); // default order 
     private function _get_datatables_query()
     {

        $this->db->select('z.*,ct.country_name,st.state_name,d.district_name,c.city_name');
        $this->db->from('mst_zones z');
        $this->db->join('mst_countries ct', 'ct.id=z.country_id', 'left'); 
        $this->db->join('mst_states st', 'st.id=z.state_id', 'left');
        $this->db->join('mst_districts d', 'd.id=z.district_id', 'left');
        $this->db->join('mst_cities c', 'c.id=z.city_id', 'left');
        $this->db->where('z.is_delete="No"');
    
        $i = 0;
      
        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (ct.country_name LIKE '%".$show_string."%' ";
            $cond.=" OR st.state_name LIKE '%".$show_string."%' ";
            $cond.=" OR d.district_name LIKE '%".$show_string."%' ";
            $cond.=" OR z.zone_name LIKE '%".$show_string."%' ";
            $cond.=" OR c.city_name LIKE '%".$show_string."%' ) ";          
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }

    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
 
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
  
    public function count_all()
    {
        $this->db->select('z.*,ct.country_name,st.state_name,d.district_name,c.city_name');
        $this->db->from('mst_zones z');
        $this->db->join('mst_countries ct', 'ct.id=z.country_id', 'left'); 
        $this->db->join('mst_states st', 'st.id=z.state_id', 'left');
        $this->db->join('mst_districts d', 'd.id=z.district_id', 'left');
        $this->db->join('mst_cities c', 'c.id=z.city_id', 'left');
        $this->db->where('z.is_delete="No"');
        return $this->db->count_all_results();
    }
}
?>