<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Sensitive_Areas_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    //$table = 'departments_head';
    var $column_order = array(null,'sa.qrcode','s.state_name', 'd.district_name', 'city.city_name',null,null,null); //set column field database for datatable orderable
    var $column_search = array('sa.qrcode','s.state_name', 'd.district_name', 'city.city_name'); //set column field database for datatable searchable
    var $order = array('sa.id' => 'Desc'); // default order
 
    private function _get_datatables_query()
    {
       $this->db->select("sa.*,c.country_name, s.state_name, d.district_name, city.city_name");
       $this->db->from("sensitive_areas sa");
       $this->db->join("mst_police_stations mps",'mps.id=sa.police_station_id','left');
       $this->db->join("mst_countries c", 'sa.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'sa.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'sa.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'sa.city_id = city.id', 'left');
       $this->db->Where("sa.is_delete='No'");
 
        $i = 0;
     
        foreach ($this->column_search as $item) // loop column
        {
            if($_POST['search']['value']) // if datatable send POST for search
            {
                 
                if($i===0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                }
                else
                {
                    $this->db->or_like($item, $_POST['search']['value']);
                }
 
                if(count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
       $this->db->select("sa.*,c.country_name, s.state_name, d.district_name, city.city_name");
       $this->db->from("sensitive_areas sa");
       $this->db->join("mst_police_stations mps",'mps.id=sa.police_station_id','left');
       $this->db->join("mst_countries c", 'sa.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'sa.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'sa.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'sa.city_id = city.id', 'left');
      $this->db->Where("sa.is_delete='No'");
       return $this->db->count_all_results();
    }

    public function viewDetailsQRcode($cond)
    {
       $this->db->select("sa.*,mps.name,c.country_name, s.state_name, d.district_name, city.city_name");
       $this->db->from("sensitive_areas sa");
       $this->db->join("mst_police_stations mps",'mps.id=sa.police_station_id','left');
       $this->db->join("mst_countries c", 'sa.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'sa.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'sa.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'sa.city_id = city.id', 'left');
       $this->db->Where("sa.is_delete='No'");
       $this->db->where($cond);   
       return $this->db->get()->row();
    }
     

     
}