<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Selfie_data_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    //$table = 'departments_head';
    var $column_order = array(null,'ps.name','p.police_name', 'sa.address', 'ptc.created','ptci.image','p.buckal_number','ptc.current_location',null,null,null); //set column field database for datatable orderable
    var $column_search = array('ps.name','p.police_name', 'sa.address', 'ptc.created','ptci.image','p.buckal_number','ptc.current_location'); //set column field database for datatable searchable
    var $order = array('ptc.id' => 'Desc'); // default order
 
    private function _get_datatables_query($cond)
    {
       $this->db->select("ps.name as ps_name,p.police_name as p_name,sa.address as location,ptc.created,ptci.image,p.buckal_number,ptc.current_location");
       $this->db->from("police_task_completion ptc");
       $this->db->join("sensitive_areas sa",'sa.id=ptc.sensitive_areas_id and is_delete="No" and status="Active"','left');
       $this->db->join("police_task_completion_images ptci", 'ptci.sensitive_areas_id = sa.id and ptc.created=ptci.created', 'left');      
       $this->db->join("mst_police_stations ps", 'ps.id = sa.police_station_id', 'left');      
       $this->db->join("mst_police p", 'p.id = ptc.police_id', 'left');      
       $this->db->where("ptc.police_station_activity_map_id='0'");      
       $this->db->where($cond);      
       $this->db->group_by("ptc.id");      
       
 
        $i = 0;
     
        foreach ($this->column_search as $item) // loop column
        {
            if($_POST['search']['value']) // if datatable send POST for search
            {
                 
                if($i===0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                }
                else
                {
                    $this->db->or_like($item, $_POST['search']['value']);
                }
 
                if(count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($cond)
    {
        $this->_get_datatables_query($cond);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($cond)
    {
        $this->_get_datatables_query($cond);
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all($cond)
    {
       $this->db->select("ps.name as ps_name,p.police_name as p_name,sa.address as location,ptc.created,ptci.image,p.buckal_number,ptc.current_location");
       $this->db->from("police_task_completion ptc");
       $this->db->join("sensitive_areas sa",'sa.id=ptc.sensitive_areas_id and is_delete="No" and status="Active"','left');
       $this->db->join("police_task_completion_images ptci", 'ptci.sensitive_areas_id = sa.id', 'left');      
       $this->db->join("mst_police_stations ps", 'ps.id = sa.police_station_id', 'left');      
       $this->db->join("mst_police p", 'p.id = ptc.police_id', 'left');
       $this->db->where("ptc.police_station_activity_map_id='0'"); 
       $this->db->where($cond); 
        $this->db->group_by("ptc.id");      
       
       return $this->db->count_all_results();
    }

   
     public function SelfieDataToExcel($cond){
      $this->db->select("ps.name as ps_name,p.police_name as p_name,sa.address as location,ptc.created,ptci.image,p.buckal_number,ptc.current_location");
       $this->db->from("police_task_completion ptc");
       $this->db->join("sensitive_areas sa",'sa.id=ptc.sensitive_areas_id and is_delete="No" and status="Active"','left');
       $this->db->join("police_task_completion_images ptci", 'ptci.sensitive_areas_id = sa.id', 'left');      
       $this->db->join("mst_police_stations ps", 'ps.id = sa.police_station_id', 'left');      
       $this->db->join("mst_police p", 'p.id = ptc.police_id', 'left');
       $this->db->where($cond); 
       $this->db->where("ptc.police_station_activity_map_id='0'"); 
        $this->db->group_by("ptc.id");
        $query = $this->db->get();
        return $query->result();
     }

     
}