<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Polices_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    var $column_order = array(null,'police_station_name','admins.police_name','admins.buckal_number','designation_type',null,'admins.email','admins.mobile','admins.gender','admins.status',null); //set column field database for datatable orderable
    var $column_search = array('police_station_name','admins.police_name','admins.buckal_number','designation_type','admins.email','admins.mobile','admins.gender','admins.status'); //set column field database for datatable searchable
    var $order = array('admins.id' => 'Desc'); // default order
 
    private function _get_datatables_query($cond)
    {
       $this->db->select("admins.*,mpd.designation_name, mps.name as police_station_name");
       $this->db->from("mst_police admins");
        $this->db->join("mst_police_stations mps", 'admins.police_station_id = mps.id', 'left');
         $this->db->join("mst_police_designations mpd", 'admins.designation_id = mpd.id', 'left');
       $this->db->where("admins.is_delete='No'");
         $this->db->where($cond);

 
        $i = 0;

        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (admins.police_name LIKE '%".$show_string."%' ";
            $cond.=" OR admins.email LIKE '%".$show_string."%' ";
            $cond.=" OR admins.mobile LIKE '%".$show_string."%' ";          
            $cond.=" OR admins.status LIKE '%".$show_string."%' ";          
            $cond.=" OR designation_type LIKE '%".$show_string."%' ";
            $cond.=" OR admins.buckal_number LIKE '%".$show_string."%'";          
            $cond.=" OR admins.gender LIKE '%".$show_string."%')";          
            
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($cond)
    {
        $this->_get_datatables_query($cond);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($cond)
    {
        $this->_get_datatables_query($cond);
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all($cond)
    {
       $this->db->select("admins.id");
       $this->db->from("mst_police admins");
       $this->db->join("mst_police_designations mpd", 'admins.designation_id = mpd.id', 'left');
       $this->db->where("admins.is_delete='No' ");
         $this->db->where($cond);

        return $this->db->count_all_results();
    }

    // 9-1-2021
    /*function getHigherAuthoritiesDetails($cond)
    {
       $this->db->select("admins.*, c.country_name, s.state_name, d.district_name, city.city_name,mpd.designation_name");
       $this->db->from("mst_police admins");
         $this->db->join("mst_police_designations mpd", 'admins.designation_id = mpd.id', 'left');
       $this->db->join("mst_countries c", 'admins.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'admins.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'admins.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'admins.city_id = city.id', 'left'); 
       $this->db->where("admins.is_delete='No' ");
 
        $this->db->where($cond);   
       return $this->db->get()->row();
    }*/

    function getHigherAuthoritiesDetails($cond)
    {
       $this->db->select("admins.*, c.country_name, s.state_name, d.district_name, city.city_name,mpd.designation_name, mps.name as police_station_name");
       $this->db->from("mst_police admins");
         $this->db->join("mst_police_stations mps", 'admins.police_station_id = mps.id', 'left');
         $this->db->join("mst_police_designations mpd", 'admins.designation_id = mpd.id', 'left');
       $this->db->join("mst_countries c", 'admins.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'admins.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'admins.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'admins.city_id = city.id', 'left'); 
       $this->db->where("admins.is_delete='No' ");
 
        $this->db->where($cond);   
       return $this->db->get()->row();
    }
    public function taskDetails($cond)
    {
        $this->db->select("ptc.*,pa.name as activity_name, ps.name as ps_name,p.police_name as p_name,psam.address as location,psam.from_date,psam.to_date,psam.description");
        $this->db->from("police_task_completion ptc");
        $this->db->join("police_station_activity_map psam",'psam.id=ptc.police_station_activity_map_id and is_delete="No" and status="Active"','left');      
        $this->db->join("police_activities pa",'pa.id=psam.activity_id and pa.is_delete="No" and pa.status="Active"','left');      
        $this->db->join("mst_police_stations ps", 'ps.id = psam.police_station_id', 'left');      
        $this->db->join("mst_police p", 'p.id = ptc.police_id', 'left');
        $this->db->where("ptc.sensitive_areas_id='0'");
        $this->db->where("ptc.police_id='".$cond."'");
        $this->db->group_by("ptc.id");
        return $this->db->get()->result();
    }
     
}