<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Police_higher_authorities_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    var $column_order = array(null,'admins.higher_authority_name','admins.email','admins.mobile','admins.address','admins.pincode','admins.status','c.country_name','s.state_name','d.district_name', 'city.city_name','mpd.designation_name',null,null); //set column field database for datatable orderable
    var $column_search = array('admins.higher_authority_name','admins.email','admins.mobile','admins.address','admins.status','admins.pincode','c.country_name','s.state_name','d.district_name','city.city_name','mpd.designation_name'); //set column field database for datatable searchable
    var $order = array('admins.id' => 'Desc'); // default order
 
    private function _get_datatables_query()
    {
       $this->db->select("admins.*, c.country_name, s.state_name, d.district_name, city.city_name,mpd.designation_name");
       $this->db->from("mst_police_higher_authorities admins");
         $this->db->join("mst_police_designations mpd", 'admins.designation_id = mpd.id', 'left');
       $this->db->join("mst_countries c", 'admins.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'admins.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'admins.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'admins.city_id = city.id', 'left');      
       $this->db->where("admins.is_delete='No'");

 
        $i = 0;

        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" ( admins.higher_authority_name LIKE '%".$show_string."%' ";
            $cond.=" OR admins.email LIKE '%".$show_string."%' ";
            $cond.=" OR admins.mobile LIKE '%".$show_string."%' ";          
            $cond.=" OR admins.status LIKE '%".$show_string."%' ";          
            $cond.=" OR mpd.designation_name LIKE '%".$show_string."%' ";
            $cond.=" OR c.country_name LIKE '%".$show_string."%' ";
            $cond.=" OR s.state_name LIKE '%".$show_string."%' ";
            $cond.=" OR d.district_name LIKE '%".$show_string."%' ";
            $cond.=" OR admins.address LIKE '%".$show_string."%'";          
            $cond.=" OR admins.pincode LIKE '%".$show_string."%'";          
            $cond.=" OR city.city_name LIKE '%".$show_string."%')";          
            
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
       $this->db->select("admins.*, c.country_name, s.state_name, d.district_name, city.city_name,mpd.designation_name");
       $this->db->from("mst_police_higher_authorities admins");
       $this->db->join("mst_police_designations mpd", 'admins.designation_id = mpd.id', 'left');
       $this->db->join("mst_countries c", 'admins.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'admins.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'admins.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'admins.city_id = city.id', 'left');     
       $this->db->where("admins.is_delete='No' ");
 
        return $this->db->count_all_results();
    }

    function getHigherAuthoritiesDetails($cond)
    {
       $this->db->select("admins.*, c.country_name, s.state_name, d.district_name, city.city_name,mpd.designation_name");
       $this->db->from("mst_police_higher_authorities admins");
         $this->db->join("mst_police_designations mpd", 'admins.designation_id = mpd.id', 'left');
       $this->db->join("mst_countries c", 'admins.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'admins.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'admins.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'admins.city_id = city.id', 'left'); 
       $this->db->where("admins.is_delete='No' ");
 
        $this->db->where($cond);   
       return $this->db->get()->row();
    }
     
}