<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class GpsPetrollings_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    var $column_order = array(null,'mps.name','mv.vehicle_no','mv.vehicle_name','mv.vehicle_type',null,null); //set column field database for datatable orderable
    var $column_search = array('mps.name','mv.vehicle_no','mv.vehicle_name','mv.vehicle_type'); //set column field database for datatable searchable
    var $order = array('gp.id' => 'Desc'); // default order
 
    private function _get_datatables_query($cond)
    {
       $this->db->select("gp.*,mps.name,mv.vehicle_no,mv.vehicle_name,mv.vehicle_type,ppm.address,ppm.id as map_id");
       $this->db->from("gps_petrollings gp");
       $this->db->join("mst_police_stations mps",'mps.id=gp.police_station_id','left');      
       $this->db->join("police_petrollings_map ppm", 'ppm.petrolling_id = gp.id', 'left');
       $this->db->join("mst_vehicles mv",'mv.id=ppm.vehicle_id','left');      
       $this->db->where($cond);      
        $i = 0;

        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($cond)
    {
        $this->_get_datatables_query($cond);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($cond)
    {
        $this->_get_datatables_query($cond);
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all($cond)
    {
       $this->db->select("gp.*,mps.name,mv.vehicle_no,mv.vehicle_name,mv.vehicle_type,ppm.address");
       $this->db->from("gps_petrollings gp");
       $this->db->join("mst_police_stations mps",'mps.id=gp.police_station_id','left');      
       $this->db->join("police_petrollings_map ppm", 'ppm.petrolling_id = gp.id','left');     
       $this->db->join("mst_vehicles mv",'mv.id=ppm.vehicle_id','left');
       $this->db->where($cond);      
 
        return $this->db->count_all_results();
    }

    function getHigherAuthoritiesDetails($cond)
    {
       $this->db->select("admins.*, c.country_name, s.state_name, d.district_name, city.city_name,mpd.designation_name");
       $this->db->from("mst_police admins");
         $this->db->join("mst_police_designations mpd", 'admins.designation_id = mpd.id', 'left');
       $this->db->join("mst_countries c", 'admins.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'admins.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'admins.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'admins.city_id = city.id', 'left'); 
       $this->db->where("admins.is_delete='No' ");
 
        $this->db->where($cond);   
       return $this->db->get()->row();
    }

     public function getdetailspolicepetrollings($con='')
    {
        $this->db->select('mp.id,mp.police_name');
        $this->db->from('mst_police mp');
        $this->db->join('police_petrollings_for_polices_map ppfm',"mp.id=ppfm.police_id","LEFT");
        $this->db->join('gps_petrollings gp',"gp.id=ppfm.petrolling_id","LEFT");
        if(!empty($con))
        {
          $this->db->where($con);
        }
        $query = $this->db->get();
        return $query->result();
    }

     public function getpetrollingDetails($con)
    {
        $this->db->select('gp.*,ppm.*,mv.*,ppfm.*');
        $this->db->from('gps_petrollings gp');
        $this->db->join('police_petrollings_map ppm',"ppm.petrolling_id=gp.id","LEFT");
        $this->db->join('police_petrollings_for_polices_map ppfm',"ppfm.petrolling_id=gp.id","LEFT");
        $this->db->join('mst_vehicles mv',"ppm.vehicle_id=mv.id","LEFT");
       if(!empty($con))
        {
          $this->db->where($con);
        }
        $query = $this->db->get();
        return $query->row();
    }

   /* public function getmapdata($con)
    {
        $this->db->select('pm.address,v.*,mv.*,ppfm.*');
        $this->db->from('police_petrollings_map pm');
        $this->db->join('mst_vehicles v',"v.id=pm.vehicle_id","LEFT");
        $this->db->join('police_petrollings_for_polices_map ppfm',"ppfm.petrolling_id=gp.id","LEFT");
        $this->db->join('mst_vehicles mv',"ppm.vehicle_id=mv.id","LEFT");
       if(!empty($con))
        {
          $this->db->where($con);
        }
        $query = $this->db->get();
        return $query->row();

    }*/
     
}