<?php
//print_r($this->uri->segments(2));
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Dashboard_model extends CI_Model
{
    public $table = 'purchase_received_detail_barcode prd';
    var $column_order = array(null,'at.asset_name','p.order_number','p.purchase_date',null,'prd.barcode_number','prd.quantity'); //set column field database for datatable orderable
    var $column_search = array('at.asset_name','p.order_number','prd.barcode_number','p.purchase_date','prd.quantity'); //set column field database for datatable searchable 
    var $order = array('p.id' => 'desc'); 
    function __construct()
    {
        parent::__construct();
    }
    
     private function _get_datatables_query($con='')
    {
        
        $this->db->select('prd.barcode_image,prd.barcode_number,prd.quantity,at.asset_name,p.order_number,p.purchase_date');
        $this->db->join('assets at','at.id=prd.asset_id','left');
        $this->db->join('purchase_orders p','p.id=prd.purchase_order_id','left');
        $this->db->where($con);
        
        $this->db->from($this->table);
        $i = 0;
        if($_POST['search']['value']) // if datatable send POST for search
            {
                $explode_string = explode(' ', $_POST['search']['value']);
                foreach ($explode_string as $show_string) 
                {  
                    $cond  = " ";
                    $cond.=" ( prd.barcode_number LIKE '%".trim($show_string)."%' ";
                    $cond.=" OR prd.quantity LIKE '%".trim($show_string)."%' ";
                    $cond.=" OR at.asset_name LIKE '%".trim($show_string)."%' ";
                    $cond.=" OR p.order_number  LIKE '%".trim($show_string)."%' ";
                    $cond.=" OR p.purchase_date LIKE '%".trim($show_string)."%') ";
                    $this->db->where($cond);
                }
            }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        } 
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($con='')
    {
        $this->_get_datatables_query($con);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
 
    function count_filtered($con='')
    {
        $this->_get_datatables_query($con);
        $query = $this->db->get();
        return $query->num_rows();
    }
    public function count_all($con='')
    {
        $this->db->from($this->table);
        $this->db->where($con);
        return $this->db->count_all_results();
    }
    public function getMedias($page)
    { 
        $offset = $page; 
        $limit = 7; 
        $sql = "select * from medias Where status = 'Active' order by id desc limit $offset ,$limit"; 
        $result = $this->db->query($sql)->result();
         return $result;
    }

    function getAllData($tablename,$condition='',$order='',$limit='')
    {
        if($condition !='')
        $this->db->where($condition);
        if($order !='')     
        $this->db->order_by($order);
        if($limit !='')     
        $this->db->limit($limit);       
        return $this->db->get($tablename)->result();
    }
    
public function GetData($table,$field='',$condition='',$group='',$order='',$limit='10',$result='')
    {
        if($field != '')
        $this->db->select($field);
        if($condition != '')
        $this->db->where($condition);
        if($order != '')
        $this->db->order_by($order);
        if($limit != '')
        $this->db->limit($limit);
        if($group != '')
        $this->db->group_by($group);
        if($result != '')
        {
            $return =  $this->db->get($table)->row();
        }else{
            $return =  $this->db->get($table)->result();
        }
        return $return;
    }
    public function GetOrders()
    {
        $this->db->select('orders.*,customers.name');
        $this->db->from('orders');
        $this->db->join('customers', 'customers.id=orders.customer_id','left'); 
        $this->db->order_by("orders.id desc");
        $this->db->limit('10');
       
        $query = $this->db->get();
        return $query->result();
    }
    public function GetProducts()
    {
        $this->db->select('products.*,reviews_and_ratings.rating');
        $this->db->from('products');
        $this->db->join('reviews_and_ratings', 'reviews_and_ratings.id=products.customer_id','left'); 
        $this->db->order_by("products.id desc");
        $query = $this->db->get();
        return $query->result();
    }
     public function Getcustomer()
    {
        $this->db->query('SELECT * FROM customers
                        WHERE   modified BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE()');
       
    } 

    public function get_total_sale($con='')
    {
        $this->db->select('SUM(final_amount) AS amount');
        $this->db->from('orders');
        if(!empty($con))
        $this->db->where($con);
        return $this->db->get()->result();
    }

    function get_todays_sale($con='')
    {
        $this->db->select('SUM(final_amount) AS amount');
        $this->db->from('orders');
        if(!empty($con))
        $this->db->where($con);
        return $this->db->get()->result();
    }

    function get_weeklely_piechart_data($con)
    {
        $this->db->select('SUM(orders.final_amount) AS amount');
        $this->db->from('logs');
        $this->db->join('orders','orders.id=logs.order_id','left');
        $this->db->where($con);
        $this->db->group_by('date_format(logs.created,"%Y-%m-%d")');
        return $this->db->get()->row();
    }

    function monthly_piechart_data($con)
    {
        $this->db->select('SUM(orders.final_amount) AS amount');
        $this->db->from('logs');
        $this->db->join('orders','orders.id=logs.order_id','left');
        $this->db->where($con);
        $this->db->group_by('date_format(logs.created,"%Y-%m-%d")');
        return $this->db->get()->row();
    }

    function yearly_piechart_data($con)
    {
        $this->db->select('SUM(orders.final_amount) AS amount');
        $this->db->from('logs');
        $this->db->join('orders','orders.id=logs.order_id','left');
        $this->db->where($con);
        return $this->db->get()->row();
    }

    function GetTotalAmount($con='')
    {
        $this->db->select('SUM(final_amount) AS amount');
        if(!empty($con))
        $this->db->where($con);
        return $this->db->get('orders')->row();
    }

    function Get_most_view()
    {
        $this->db->select('p.title,p.price,p.status,p.id,count(pv.product_id) as count_product,m.small_url');
        $this->db->join('product_view_logs pv','pv.product_id=p.id','left');
        $this->db->join('medias m','p.media_id=m.id','left');
        $this->db->group_by('p.title');
        $this->db->order_by('count_product desc');
        $this->db->limit('10');
        return $this->db->get('products p')->result();
    }

    function Get_returnData($con)
    {
        /*$this->db->select('st.*,at.asset_name,if(st.branch_id!=0,b.branch_title,"-") as branch');
        $this->db->join('assets at','at.id=st.asset_id','left');
        $this->db->join('branches b','b.id=st.branch_id','left');
        $this->db->where($con);
        return $this->db->get('stock_logs st')->result();*/
        $this->db->select('pb.*,at.asset_name');
        $this->db->join('assets at','at.id=pb.asset_id','left');
        $this->db->where($con);
        return $this->db->get('purchase_return_replace_details pb')->result();
    }
    function Getbarcodedata($con)
    {
        $this->db->select('prd.barcode_image,prd.barcode_number,prd.quantity,at.asset_name,p.order_number,p.purchase_date');
        $this->db->join('assets at','at.id=prd.asset_id','left');
        $this->db->join('purchase_orders p','p.id=prd.purchase_order_id','left');
        $this->db->where($con);
        return $this->db->get('purchase_received_detail_barcode prd')->result();
    }


}