<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Criminals_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    var $column_order = array(null,'mps.name','crm.criminal_name','crm.mobile','crm.address','crm.crime','crm.crime_date','crm.crime_place','crm.status',null); //set column field database for datatable orderable

    var $column_search = array('mps.name','crm.criminal_name','crm.mobile','crm.address','crm.crime','crm.crime_date','crm.crime_place','crm.status'); //set column field database for datatable searchable

    var $order = array('crm.id' => 'DESC'); // default order
 
    private function _get_datatables_query($cond)
    {
      $this->db->select("crm.*,mps.name,cr.crime_name");
      $this->db->from("criminals crm");
      $this->db->join("mst_police_stations mps", 'crm.police_station_id = mps.id', 'left');
      $this->db->join("mst_crimes cr", 'crm.crime = cr.id', 'left');
      $this->db->where("crm.is_delete='No'");
      $this->db->where($cond);
 
      $i = 0;
     
      
      if($_POST['search']['value']) // if datatable send POST for search
      {
          $explode_string = explode(' ', $_POST['search']['value']);

          foreach ($explode_string as $show_string) {
          $cond  = " ";
          $cond.=" (mps.name LIKE '%".$show_string."%' ";
          $cond.=" OR crm.criminal_name LIKE '%".$show_string."%' ";
          $cond.=" OR crm.mobile LIKE '%".$show_string."%' ";   
          $cond.=" OR crm.address LIKE '%".$show_string."%' ";   
          $cond.=" OR cr.crime_name LIKE '%".$show_string."%' ";   
          $cond.=" OR crm.crime_date LIKE '%".$show_string."%' ";   
          $cond.=" OR crm.crime_place LIKE '%".$show_string."%' ";   
          $cond.=" OR crm.status LIKE '%".$show_string."%' ) ";   
       
          $this->db->where($cond);
          }
      }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($cond)
    {
        $this->_get_datatables_query($cond);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($cond)
    {
        $this->_get_datatables_query($cond);
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all($cond)
    {
      $this->db->select("crm.*, c.country_name, s.state_name, d.district_name, mc.city_name, mps.name,cr.crime_name");
      $this->db->from("criminals crm");
      $this->db->join("mst_countries c", 'crm.country_id = c.id', 'left');
      $this->db->join("mst_states s", 'crm.state_id = s.id', 'left');
      $this->db->join("mst_districts d", 'crm.district_id = d.id', 'left');
      $this->db->join("mst_cities mc", 'crm.city_id = mc.id', 'left');
      $this->db->join("mst_police_stations mps", 'crm.police_station_id = mps.id', 'left');
      $this->db->join("mst_crimes cr", 'crm.crime = cr.id', 'left');
      $this->db->where("crm.is_delete='No'");
      $this->db->where($cond);
      return $this->db->count_all_results();
    }

    //SELECT All ROW DATA BY CONDITION WITH DYNAMIC TABLE NAME
    public function getAllData($tablename,$condition='',$order='')
    {
        if($condition !='')
        $this->db->where($condition);
        if($order !='')     
        $this->db->order_by($order);        
        return $this->db->get($tablename)->result();
    }

    function viewCriminalDetails($cond)
    {    
 
      $this->db->select("crm.*, c.country_name, s.state_name, d.district_name, mc.city_name, mps.name as police_station_name,cr.crime_name");
      $this->db->from("criminals crm");
      $this->db->join("mst_countries c", 'crm.country_id = c.id', 'left');
      $this->db->join("mst_states s", 'crm.state_id = s.id', 'left');
      $this->db->join("mst_districts d", 'crm.district_id = d.id', 'left');
      $this->db->join("mst_cities mc", 'crm.city_id = mc.id', 'left');
      $this->db->join("mst_police_stations mps", 'crm.police_station_id = mps.id', 'left');
      $this->db->join("mst_crimes cr", 'crm.crime = cr.id', 'left');
      $this->db->where("crm.is_delete='No' AND crm.id='".$cond."'");
      return $this->db->get()->row();
    }
    
    public function exportcriminalsData() {

      $this->db->select("crm.*, c.country_name, s.state_name, d.district_name, mc.city_name, mps.name as police_station_name,cr.crime_name");
      $this->db->from("criminals crm");
      $this->db->join("mst_countries c", 'crm.country_id = c.id', 'left');
      $this->db->join("mst_states s", 'crm.state_id = s.id', 'left');
      $this->db->join("mst_districts d", 'crm.district_id = d.id', 'left');
      $this->db->join("mst_cities mc", 'crm.city_id = mc.id', 'left');
      $this->db->join("mst_police_stations mps", 'crm.police_station_id = mps.id', 'left');
      $this->db->join("mst_crimes cr", 'crm.crime = cr.id', 'left');
      $this->db->where("crm.is_delete='No'");
       return $this->db->get()->result();
     }
     
}