<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Criminal_verification_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    var $column_order = array(null,'mps.name','mp.police_name','cv.recent_image'); //set column field database for datatable orderable

    var $column_search = array(null,'mps.name','mp.police_name','cv.recent_image'); //set column field database for datatable searchable

    var $order = array('cv.id' => 'DESC'); // default order
 
    private function _get_datatables_query($cond)
    {
      $this->db->select("cv.*,mps.name,mp.police_name,cv.recent_image");
      $this->db->from("criminal_visit cv");
      $this->db->join("criminals crm",'cv.criminal_id = crm.id','left');
      $this->db->join("mst_police_stations mps", 'cv.police_station_id = mps.id', 'left');
      $this->db->join("mst_police mp", 'cv.police_id = mp.id', 'left');
      $this->db->where("cv.is_delete='No'");
      $this->db->where($cond);
 
      $i = 0;
     
      
      if($_POST['search']['value']) // if datatable send POST for search
      {
          $explode_string = explode(' ', $_POST['search']['value']);

          foreach ($explode_string as $show_string) {
          $cond  = " ";
          $cond.=" (mps.name LIKE '%".$show_string."%' ";
          $cond.=" OR cv.criminal_name LIKE '%".$show_string."%' ) ";
       
          $this->db->where($cond);
          }
      }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($cond)
    {
        $this->_get_datatables_query($cond);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($cond)
    {
        $this->_get_datatables_query($cond);
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all($cond)
    {
      $this->db->select("cv.id");
      $this->db->from("criminal_visit cv");
      $this->db->join("criminals crm",'cv.criminal_id = crm.id','left');
      $this->db->join("mst_police_stations mps", 'cv.police_station_id = mps.id', 'left');
      $this->db->join("mst_police mp", 'cv.police_id = mp.id', 'left');
      $this->db->where("cv.is_delete='No'");
      $this->db->where($cond);
      return $this->db->count_all_results();
    }

    //SELECT All ROW DATA BY CONDITION WITH DYNAMIC TABLE NAME
    public function getAllData($tablename,$condition='',$order='')
    {
        if($condition !='')
        $this->db->where($condition);
        if($order !='')     
        $this->db->order_by($order);        
        return $this->db->get($tablename)->result();
    }

    function criminalverification($cond)
    {    
      $this->db->select("cv.*,mps.name,mp.police_name,cv.previous_image");
      $this->db->from("criminal_visit cv");
      $this->db->join("criminals crm",'cv.criminal_id = crm.id','left');
      $this->db->join("mst_police_stations mps", 'cv.police_station_id = mps.id', 'left');
      $this->db->join("mst_police mp", 'cv.police_id = mp.id', 'left');
      $this->db->where("cv.is_delete='No'");
      $this->db->where($cond);
 
      $this->db->where("cv.is_delete='No' AND cv.id='".$cond."'");
      return $this->db->get()->row();
    }
  
     
}