<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Criminal_analysis_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    //$table = 'departments_head';
    var $column_order = array(null,'ps.name','c.criminal_name', 'c.address', 'cc.crime_date','crime.crime_name','cc.section',null); //set column field database for datatable orderable
    var $column_search = array('ps.name','c.criminal_name', 'c.address', 'cc.crime_date','crime.crime_name','cc.section'); //set column field database for datatable searchable
    var $order = array('cc.id' => 'Desc'); // default order
 
    private function _get_datatables_query($cond)
    {
       $this->db->select("c.id,cc.crime_place,cc.section,c.criminal_name as c_name,crime.crime_name,city.city_name as city_name,ps.name as ps_name,c.address as address,cc.crime_date");
       $this->db->from("criminal_crimes cc");
       $this->db->join("criminals c",'c.id=cc.criminal_id and c.is_delete="No" and c.status="Active"','left');          
       $this->db->join("mst_police_stations ps", 'ps.id = cc.police_station_id', 'left');
       $this->db->join("mst_cities city", 'city.id = cc.city_id', 'left');
       $this->db->join("mst_districts disticts", 'disticts.id = cc.district_id', 'left');
        $this->db->join("mst_crimes crime", 'crime.id = cc.crime_id', 'left');      
             
             
       $this->db->where($cond);      
       $this->db->group_by("cc.id");      
 
        $i = 0;
     
        foreach ($this->column_search as $item) // loop column
        {
            if($_POST['search']['value']) // if datatable send POST for search
            {
                 
                if($i===0) // first loop
                {
                    $this->db->group_start(); // open bracket. query Where with OR clause better with bracket. because maybe can combine with other WHERE with AND.
                    $this->db->like($item, $_POST['search']['value']);
                }
                else
                {
                    $this->db->or_like($item, $_POST['search']['value']);
                }
 
                if(count($this->column_search) - 1 == $i) //last loop
                    $this->db->group_end(); //close bracket
            }
            $i++;
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables($cond)
    {
        $this->_get_datatables_query($cond);
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered($cond)
    {
        $this->_get_datatables_query($cond);
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all($cond)
    {
       $this->db->select("cc.id");
       $this->db->from("criminal_crimes cc");
       $this->db->join("criminals c",'c.id=cc.criminal_id and c.is_delete="No" and c.status="Active"','left');
       $this->db->where($cond); 
        $this->db->group_by("cc.id");      
       
       return $this->db->count_all_results();
    }

   
     public function SelfieDataToExcel($cond){
       $this->db->select("cc.id,cc.crime_place,cc.section,c.criminal_name as c_name,crime.crime_name,city.city_name as city_name,ps.name as ps_name,c.address as address,cc.created,");
       $this->db->from("criminal_crimes cc");
       $this->db->join("criminals c",'c.id=cc.criminal_id and c.is_delete="No" and c.status="Active"','left');          
       $this->db->join("mst_police_stations ps", 'ps.id = cc.police_station_id', 'left');
       $this->db->join("mst_cities city", 'city.id = cc.city_id', 'left');
        $this->db->join("mst_crimes crime", 'crime.id = cc.crime_id', 'left');   
       $this->db->where($cond); 
       $this->db->group_by("cc.id");
        $query = $this->db->get();
        return $query->result();
     }

     
}