<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Constitution_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    //$table = 'citizens';
    var $column_order = array(null,'ca.title','constitution_article_details.article_title',null,null,null); //set column field database for datatable orderable
    var $column_search = array('ca.title','constitution_article_details.article_title','constitution_article_details.description'); //set column field database for datatable searchable
    var $order = array('constitution_article_details.id' => 'DESC'); // default order
 
    private function _get_datatables_query()
    {
       $this->db->select("constitution_article_details.*,ca.title");
       $this->db->from("constitution_article_details");
        $this->db->join("constitution_articles ca", 'constitution_article_details.article_id = ca.id', 'inner');
       $this->db->where("constitution_article_details.is_delete='No'");
 
        $i = 0;
     
        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (constitution_article_details.article_title LIKE '%".$show_string."%' "; 
            $cond.=" OR ca.title LIKE '%".$show_string."%' ";   
            $cond.=" OR constitution_article_details.description LIKE '%".$show_string."%' ) ";   
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
      $this->db->select("constitution_article_details.*,ca.article_title");
       $this->db->from("constitution_article_details");
        $this->db->join("constitution_articles ca", 'constitution_article_details.article_id = ca.id', 'inner');
       $this->db->where("constitution_article_details.is_delete='No'");
       return $this->db->count_all_results();
    }

    //SELECT All ROW DATA BY CONDITION WITH DYNAMIC TABLE NAME
    public function getAllData($tablename,$condition='',$order='')
    {
        if($condition !='')
        $this->db->where($condition);
        if($order !='')     
        $this->db->order_by($order);        
        return $this->db->get($tablename)->result();
    }
 
     
}