<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Citizens_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    var $column_order = array(null,'citizen.name','citizen.email','citizen.mobile','c.country_name','s.state_name','mc.city_name','d.district_name',null,null); //set column field database for datatable orderable

    var $column_search = array('citizen.name','citizen.email','citizen.mobile','c.country_name','s.state_name','citizen.city_name','d.district_name'); //set column field database for datatable searchable

    var $order = array('citizen.id' => 'DESC'); // default order
 
    private function _get_datatables_query()
    {
      $this->db->select("citizen.*, c.country_name, s.state_name, mc.city_name, d.district_name,mz.zone_name");
      $this->db->from("citizens citizen");
      $this->db->join("mst_countries c", 'citizen.country_id = c.id', 'left');
      $this->db->join("mst_states s", 'citizen.state_id = s.id', 'left');
      $this->db->join("mst_cities mc", 'citizen.city_id = mc.id', 'left');
      $this->db->join("mst_districts d", 'd.id = citizen.district_id', 'left');
      $this->db->join("mst_zones mz", 'mz.id = citizen.zone_id', 'left');
      $this->db->join("mst_areas msa", 'msa.id = citizen.area_id', 'left');
      $this->db->where("citizen.is_delete='No'");
 
      $i = 0;
     
      
      if($_POST['search']['value']) // if datatable send POST for search
      {
          $explode_string = explode(' ', $_POST['search']['value']);

          foreach ($explode_string as $show_string) {
          $cond  = " ";
          $cond.=" (citizen.name LIKE '%".$show_string."%' ";
          $cond.=" OR citizen.email LIKE '%".$show_string."%' ";   
          $cond.=" OR citizen.mobile LIKE '%".$show_string."%' ";   
          $cond.=" OR c.country_name LIKE '%".$show_string."%' ";   
          $cond.=" OR s.state_name LIKE '%".$show_string."%' ";   
          $cond.=" OR d.district_name LIKE '%".$show_string."%' ";   
          $cond.=" OR mc.city_name LIKE '%".$show_string."%' ";   
          $cond.=" OR mz.zone_name LIKE '%".$show_string."%' ) "; 
       
          $this->db->where($cond);
          }
      }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
      $this->db->select("citizen.*, c.country_name, s.state_name, mc.city_name,d.district_name,mz.zone_name,msa.area");
      $this->db->from("citizens citizen");
      $this->db->join("mst_countries c", 'citizen.country_id = c.id', 'left');
      $this->db->join("mst_states s", 'citizen.state_id = s.id', 'left');
      $this->db->join("mst_cities mc", 'citizen.city_id = mc.id', 'left');
      $this->db->join("mst_districts d", 'd.id = citizen.district_id', 'left');
      $this->db->join("mst_zones mz", 'mz.id = citizen.zone_id', 'left');
      //$this->db->join("mst_areas msa", 'msa.id = citizen.area_id', 'left');
      $this->db->where("citizen.is_delete='No'");
      return $this->db->count_all_results();
    }

    //SELECT All ROW DATA BY CONDITION WITH DYNAMIC TABLE NAME
    public function getAllData($tablename,$condition='',$order='')
    {
        if($condition !='')
        $this->db->where($condition);
        if($order !='')     
        $this->db->order_by($order);        
        return $this->db->get($tablename)->result();
    }

    function viewCompDetails($cond)
    {    
 
      $this->db->select("citizen.*, c.country_name, s.state_name,mf.profession,mc.city_name, d.district_name,mz.zone_name,msa.area,cf.feedback as feedback,cf.image as feedback_image,comp.comp_code,comp.title,comp.description");
      $this->db->from("citizens citizen");
      $this->db->join("complaint_feedbacks cf", 'cf.id = citizen.id', 'left');
      $this->db->join("complaints comp", 'comp.citizen_id = citizen.id', 'left');
      $this->db->join("mst_countries c", 'citizen.country_id = c.id', 'left');
      $this->db->join("mst_states s", 'citizen.state_id = s.id', 'left');
      $this->db->join("mst_cities mc", 'citizen.city_id = mc.id', 'left');
      $this->db->join("mst_districts d", 'd.id = citizen.district_id', 'left');
      $this->db->join("mst_zones mz", 'mz.id = citizen.zone_id', 'left');
      $this->db->join("mst_professions mf", 'citizen.profession_id = mf.id', 'left');
      $this->db->join("mst_areas msa", 'msa.id = citizen.area_id', 'left');
      $this->db->where("citizen.$cond && citizen.is_delete='No'");
      return $this->db->get()->row();
    }
    
    
     
}