<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Sub_admin_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    var $column_order = array(null,'admins.name','admins.email','admins.mobile','admins.address','admins.status','c.country_name','s.state_name','d.district_name', 'city.city_name',null,null); //set column field database for datatable orderable
    var $column_search = array('admins.name','admins.email','admins.mobile','admins.address','admins.status','c.country_name','admins.city','s.state_name','d.district_name', 'city.city_name'); //set column field database for datatable searchable
    var $order = array('admins.id' => 'Desc'); // default order
 
    private function _get_datatables_query()
    {
       $this->db->select("admins.*, c.country_name, s.state_name, d.district_name, city.city_name");
       $this->db->from("admins");
       $this->db->join("mst_countries c", 'admins.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'admins.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'admins.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'admins.city_id = city.id', 'left');
       $this->db->where("admins.is_delete='No' and admins.user_type!='admin'");
 
        $i = 0;

        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (admins.name LIKE '%".$show_string."%' ";
            $cond.=" OR admins.email LIKE '%".$show_string."%' ";
            $cond.=" OR admins.mobile LIKE '%".$show_string."%' ";
            $cond.=" OR admins.address LIKE '%".$show_string."%' ";
            $cond.=" OR c.country_name LIKE '%".$show_string."%' ";
            $cond.=" OR s.state_name LIKE '%".$show_string."%' ";
            $cond.=" OR d.district_name LIKE '%".$show_string."%' ";
            $cond.=" OR city.city_name LIKE '%".$show_string."%' ) ";          
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
       $this->db->select("admins.*, c.country_name, s.state_name, d.district_name, city.city_name");
       $this->db->from("admins");
       $this->db->join("mst_countries c", 'admins.country_id = c.id', 'left');
       $this->db->join("mst_states s", 'admins.state_id = s.id', 'left');
       $this->db->join("mst_districts d", 'admins.district_id = d.id', 'left');
       $this->db->join("mst_cities city", 'admins.city_id = city.id', 'left');
       $this->db->where("admins.is_delete='No' and admins.user_type!='admin'");
        return $this->db->count_all_results();
    }

    function getSubAdminDetails($cond)
    {
        $this->db->select("a.*, c.country_name, s.state_name, d.district_name, city.city_name");
        $this->db->from("admins a");
        $this->db->join("mst_countries c", 'a.country_id = c.id', 'left');
        $this->db->join("mst_states s", 'a.state_id = s.id', 'left');
        $this->db->join("mst_districts d", 'a.district_id = d.id', 'left');
        $this->db->join("mst_cities city", 'a.city_id = city.id', 'left');
        $this->db->where($cond);   
       return $this->db->get()->row();
    }
     
}