<?php
if(!defined('BASEPATH'))exit('No direct script access allowed');

class States_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    } 
    
    var $column_order = array(null,'ct.country_name','st.state_name',null,null);
    var $column_search = array('st.state_name','ct.country_name');
    var $order = array('st.id' => 'DESC'); // default order
 
    private function _get_datatables_query()
    {    
        $this->db->select('st.*,ct.country_name');
        $this->db->from('mst_states st');
        $this->db->join('mst_countries ct', 'ct.id=st.country_id', 'left');
        $this->db->where('st.is_delete="No"');
 
        $i = 0;
        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (ct.country_name LIKE '%".$show_string."%' ";       
            $cond.=" OR st.state_name LIKE '%".$show_string."%' ) ";
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
 
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
        $this->db->select('st.*,ct.country_name');
        $this->db->from('mst_states st');
        $this->db->join('mst_countries ct', 'ct.id=st.country_id', 'left');
        $this->db->where('st.is_delete="No"');
        return $this->db->count_all_results();
    }
}