<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Departments_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    //$table = 'mst_departments';
    var $column_order = array(null,'mst_departments.department_name',null,null); //set column field database for datatable orderable
    var $column_search = array('mst_departments.department_name'); //set column field database for datatable searchable
    var $order = array('mst_departments.id' => 'Desc'); // default order
 
    private function _get_datatables_query()
    {
        $this->db->select("mst_departments.*, parent.title as authority");
        $this->db->from("mst_departments");
        $this->db->join("mst_departments_parent parent","parent.id=mst_departments.parent_id","left");
        $this->db->where('mst_departments.is_delete="No"');

        $i = 0;
     
        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (mst_departments.department_name LIKE '%".$show_string."%' ) ";        
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
        $this->db->select("*");
        $this->db->from("mst_departments");
        $this->db->where('mst_departments.is_delete="No"');
       return $this->db->count_all_results();
    }

    public function NotAssingHeadsdata()
    {
        $this->db->select('departments_head.*');
        $this->db->from('departments_head');
        $this->db->where('departments_head.id NOT IN (SELECT dept_head_id FROM mst_departments)');
        return $this->db->get()->result();
    }


    public function getAuthoritiesDepartment($cond) 
    {
        $this->db->select("d.id, d.department_name,
                COUNT(c.id) as total_complaints,
                COUNT(IF(complaint_status = 'Pending', 1, NULL)) 'Pending',
                COUNT(IF(complaint_status = 'Approved', 1, NULL)) 'Approved',
                COUNT(IF(complaint_status = 'Resolved', 1, NULL)) 'Resolved'");
        $this->db->from('mst_departments d');
        $this->db->join("mst_departments_parent mdp", "d.parent_id=mdp.id", "INNER");
        $this->db->join("complaints c", "d.id=c.department_id", "INNER");
        $this->db->where("d.is_delete='No' and d.parent_id='".$cond."'");
        $this->db->group_by('d.id');
        return $this->db->get()->result();
    }
     
}