<?php

if(!defined('BASEPATH'))exit('No direct script access allowed');

class Complaints_model extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
   
    /*---------------------SERVER SIDE DATA TABLE FETCH STATE RECORD CODE----------------------------------*/
 
    var $column_order = array(null,'ci.name','comp.comp_code','comp.title','comp.description','c.name','b.branch_name','dep.department_name',null); //set column field database for datatable orderable

    var $column_search = array('ci.name','comp.comp_code','comp.title','comp.description','c.name','b.branch_name','dep.department_name'); //set column field database for datatable searchable

    var $order = array('comp.id' => 'DESC'); // default order
 
    private function _get_datatables_query()
    {
       $this->db->select("comp.*,dep.department_name,ci.name,c.name as corporate_name,b.branch_name");
       $this->db->from("complaints comp");
       $this->db->join("corporates c", 'c.id = comp.corporate_id', 'left');
       $this->db->join("mst_departments dep", 'dep.id = comp.department_id', 'left');
       $this->db->join("mst_department_branches b", 'b.id = comp.branch_id', 'left');
       $this->db->join("citizens ci", 'ci.id = comp.citizen_id', 'left');
       $this->db->where("comp.is_delete='No'");
 
        $i = 0;
     
        if($_POST['search']['value']) // if datatable send POST for search
        {
            $explode_string = explode(' ', $_POST['search']['value']);

            foreach ($explode_string as $show_string) {
            $cond  = " ";
            $cond.=" (ci.name LIKE '%".$show_string."%' ";
            $cond.=" OR comp.comp_code LIKE '%".$show_string."%' ";
            $cond.=" OR comp.title LIKE '%".$show_string."%' ";
            $cond.=" OR comp.description LIKE '%".$show_string."%' ";
            $cond.=" OR c.name LIKE '%".$show_string."%' ";
            $cond.=" OR b.branch_name LIKE '%".$show_string."%' ";
            $cond.=" OR dep.department_name LIKE '%".$show_string."%' ) ";
         
            $this->db->where($cond);
            }
        }
         
        if(isset($_POST['order'])) // here order processing
        {
            $this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
        }
        else if(isset($this->order))
        {
            $order = $this->order;
            $this->db->order_by(key($order), $order[key($order)]);
        }
    }
 
    function get_datatables()
    {
        $this->_get_datatables_query();
        if($_POST['length'] != -1)
        $this->db->limit($_POST['length'], $_POST['start']);
        $query = $this->db->get();
        return $query->result();
    }
    
    function count_filtered()
    {
        $this->_get_datatables_query();
        $query = $this->db->get();
        return $query->num_rows();
    }
 
    public function count_all()
    {
        $this->db->select("comp.*,dep.department_name,ci.name,ci.email,ci.mobile");
       $this->db->from("complaints comp");
       $this->db->join("corporates c", 'c.id = comp.corporate_id', 'left');
       $this->db->join("mst_departments dep", 'dep.id = comp.department_id', 'left');
       $this->db->join("mst_department_branches b", 'b.id = comp.branch_id', 'left');
       $this->db->join("citizens ci", 'ci.id = comp.citizen_id', 'left');
       $this->db->where("comp.is_delete='No'");
        return $this->db->count_all_results();
    }

    function viewCompDetails($cond)
    {    
      $this->db->select("comp.*,ci.name as citizen_name,ci.image as citizen_image,ci.email as citizen_email,ci.mobile as citizen_mobile, ci.profession_id,ci.gender as citizen_gender,ci.address as citizen_address,ci.pincode as citizen_pincode,corp.name as corporate_name,corp.address as corporate_address,corp.mobile as corporate_mobile,corp.email as corporate_email,corp.role,mla.name as mla, c.country_name, s.state_name, mc.city_name, d.district_name, b.branch_emp_id, dep.department_name");

      $this->db->from("complaints comp");
      $this->db->join("citizens ci", 'ci.id = comp.citizen_id', 'left');
      $this->db->join("corporates corp", 'corp.id = comp.corporate_id', 'left');
      $this->db->join("corporates mla", 'mla.id = corp.parent_id', 'left');
      $this->db->join("mst_departments dep", 'dep.id = comp.department_id', 'left');
      $this->db->join("mst_countries c", 'c.id = comp.country_id', 'left');
      $this->db->join("mst_states s", 's.id = comp.state_id', 'left');
      $this->db->join("mst_cities mc", 'mc.id = comp.city_id', 'left');
      $this->db->join("mst_districts d", 'd.id = comp.district_id', 'left');
      $this->db->join("mst_department_branches b", 'b.id = comp.branch_id', 'left');
      $this->db->where("comp.$cond && comp.is_delete='No'");
      $query = $this->db->get();
      return $query->row();
    }
     
}